/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.rgstate;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.StateChangeEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.kv.impl.api.Request;
import oracle.kv.impl.api.Response;
import oracle.kv.impl.api.StatusChanges;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.api.rgstate.RepGroupState;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;

public class RepGroupStateTable
implements TopologyManager.PostUpdateListener {
    private final ResourceId resourceId;
    private final Map<RepGroupId, RepGroupState> groupMap;

    public RepGroupStateTable(ResourceId resourceId) {
        this.resourceId = resourceId;
        this.groupMap = new ConcurrentHashMap<RepGroupId, RepGroupState>();
    }

    public synchronized Collection<RepNodeState> getRepNodeStates() {
        HashSet<RepNodeState> rns = new HashSet<RepNodeState>();
        for (RepGroupState rgs : this.groupMap.values()) {
            rns.addAll(rgs.getRepNodeStates());
        }
        return rns;
    }

    synchronized Collection<RepNodeState> getRNStatesNeedingRepair() {
        HashSet<RepNodeState> rns = new HashSet<RepNodeState>();
        for (RepGroupState rgs : this.groupMap.values()) {
            for (RepNodeState state : rgs.getRepNodeStates()) {
                if (!state.reqHandlerNeedsRepair()) continue;
                rns.add(state);
            }
        }
        return rns;
    }

    public synchronized RepGroupState getGroupState(RepGroupId rgId) {
        RepGroupState rgs = this.groupMap.get(rgId);
        if (rgs != null) {
            return rgs;
        }
        rgs = new RepGroupState(rgId);
        this.groupMap.put(rgId, rgs);
        return rgs;
    }

    public RepNodeState getNodeState(RepNodeId rnId) {
        RepGroupState rg = this.getGroupState(new RepGroupId(rnId.getGroupId()));
        return rg.get(rnId);
    }

    public ReplicatedEnvironment.State getRepState(RepNodeId rnId) {
        RepGroupState rgs = this.getGroupState(new RepGroupId(rnId.getGroupId()));
        return rgs.get(rnId).getRepState();
    }

    public void update(StateChangeEvent event) {
        RepNodeId rnId = (RepNodeId)this.resourceId;
        RepGroupState rgs = this.getGroupState(new RepGroupId(rnId.getGroupId()));
        RepNodeId masterId = null;
        if (event.getState().isReplica() || event.getState().isMaster()) {
            String masterName = event.getMasterNodeName();
            masterId = RepNodeId.parse(masterName);
        }
        rgs.update(rnId, masterId, event.getState(), event.getEventTime());
    }

    public void update(Request request, Response response, int respMs) {
        StatusChanges changes;
        RepNodeId rnId = response.getRespondingRN();
        RepGroupState rgs = this.getGroupState(new RepGroupId(rnId.getGroupId()));
        RepNodeState rnState = this.getNodeState(rnId);
        rnState.updateVLSN(response.getVLSN());
        rnState.accumRespTime(request.isWrite(), respMs);
        TopologyInfo topoInfo = response.getTopoInfo();
        if (topoInfo != null && topoInfo.getChanges() == null) {
            rnState.updateTopoSeqNum(topoInfo.getSourceSeqNum());
        }
        if ((changes = response.getStatusChanges()) == null) {
            return;
        }
        RepNodeId masterId = changes.getCurrentMaster();
        rgs.update(rnId, masterId, changes.getState(), changes.getStatusTime());
    }

    @Override
    public boolean postUpdate(Topology topology) {
        for (RepGroup rg : topology.getRepGroupMap().getAll()) {
            this.getGroupState((RepGroupId)rg.getResourceId()).update(rg, topology);
        }
        return false;
    }
}

