/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.api.table.IndexRange;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.util.SortableString;
import oracle.kv.impl.util.TxnUtil;

public class TableOperationHandler {
    static int STOP = -1;
    static int CONTINUE = -2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean indexScan(Transaction txn, SecondaryDatabase db, IndexImpl index, IndexRange range, byte[] resumeSecondaryKey, byte[] resumePrimaryKey, boolean noData, int batchSize, IndexScanVisitor visitor) {
        int nRecords = 0;
        SecondaryCursor cursor = db.openCursor(txn, OperationHandler.CURSOR_READ_COMMITTED);
        try {
            OperationStatus status;
            DatabaseEntry pkeyEntry;
            DatabaseEntry keyEntry;
            if (range.isReverse()) {
                boolean bl = TableOperationHandler.reverseScan(cursor, index, range, resumeSecondaryKey, resumePrimaryKey, noData, batchSize, visitor);
                return bl;
            }
            byte[] startKey = range.getStartKey();
            DatabaseEntry dataEntry = new DatabaseEntry();
            if (noData) {
                dataEntry.setPartial(0, 0, true);
            }
            if (resumeSecondaryKey != null) {
                keyEntry = new DatabaseEntry(resumeSecondaryKey);
                pkeyEntry = new DatabaseEntry(resumePrimaryKey);
                status = TableOperationHandler.resume(cursor, range, keyEntry, pkeyEntry, dataEntry);
            } else if (startKey != null) {
                keyEntry = new DatabaseEntry(startKey);
                pkeyEntry = new DatabaseEntry();
                status = range.getExactMatch() ? cursor.getSearchKey(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT) : cursor.getSearchKeyRange(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
            } else {
                if (range.getExactMatch()) {
                    boolean bl = false;
                    return bl;
                }
                keyEntry = new DatabaseEntry();
                pkeyEntry = new DatabaseEntry();
                status = cursor.getFirst(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
            }
            while (status == OperationStatus.SUCCESS) {
                int num = visitor.visit(cursor, keyEntry, pkeyEntry, dataEntry);
                if (num == CONTINUE) continue;
                if (num == STOP) {
                    break;
                }
                if (batchSize > 0 && (nRecords += num) >= batchSize) {
                    boolean bl = true;
                    return bl;
                }
                status = visitor.getNext(cursor, keyEntry, pkeyEntry, dataEntry);
            }
        }
        finally {
            TxnUtil.close((Cursor)cursor);
        }
        return false;
    }

    private static boolean reverseScan(SecondaryCursor cursor, IndexImpl index, IndexRange range, byte[] resumeSecondaryKey, byte[] resumePrimaryKey, boolean noData, int batchSize, IndexScanVisitor visitor) {
        OperationStatus status;
        DatabaseEntry pkeyEntry;
        DatabaseEntry keyEntry;
        byte[] endKey = range.getEndKey();
        DatabaseEntry dataEntry = new DatabaseEntry();
        int nRecords = 0;
        if (noData) {
            dataEntry.setPartial(0, 0, true);
        }
        if (resumeSecondaryKey != null) {
            keyEntry = new DatabaseEntry(resumeSecondaryKey);
            pkeyEntry = new DatabaseEntry(resumePrimaryKey);
            status = TableOperationHandler.resume(cursor, range, keyEntry, pkeyEntry, dataEntry);
        } else if (endKey != null) {
            keyEntry = new DatabaseEntry(endKey);
            pkeyEntry = new DatabaseEntry();
            status = DbInternal.search((Cursor)cursor, (DatabaseEntry)keyEntry, (DatabaseEntry)pkeyEntry, (DatabaseEntry)dataEntry, (DbInternal.Search)DbInternal.Search.LT, (LockMode)LockMode.DEFAULT);
        } else if (range.getPrefixKey() != null) {
            keyEntry = new DatabaseEntry();
            pkeyEntry = new DatabaseEntry();
            status = TableOperationHandler.getEndFromPrefix(cursor, index, range, keyEntry, pkeyEntry, dataEntry);
        } else {
            keyEntry = new DatabaseEntry();
            pkeyEntry = new DatabaseEntry();
            status = cursor.getLast(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
        }
        while (status == OperationStatus.SUCCESS) {
            int num = visitor.visit(cursor, keyEntry, pkeyEntry, dataEntry);
            if (num == CONTINUE) continue;
            if (num == STOP) break;
            if (batchSize > 0 && (nRecords += num) >= batchSize) {
                return true;
            }
            status = visitor.getPrev(cursor, keyEntry, pkeyEntry, dataEntry);
        }
        return false;
    }

    private static OperationStatus resume(SecondaryCursor cursor, IndexRange range, DatabaseEntry keyEntry, DatabaseEntry pkeyEntry, DatabaseEntry dataEntry) {
        DbInternal.Search search = range.isReverse() ? DbInternal.Search.LT : DbInternal.Search.GT;
        OperationStatus status = DbInternal.searchBoth((Cursor)cursor, (DatabaseEntry)keyEntry, (DatabaseEntry)pkeyEntry, (DatabaseEntry)dataEntry, (DbInternal.Search)search, (LockMode)LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS || range.getExactMatch()) {
            return status;
        }
        return DbInternal.search((Cursor)cursor, (DatabaseEntry)keyEntry, (DatabaseEntry)pkeyEntry, (DatabaseEntry)dataEntry, (DbInternal.Search)search, (LockMode)LockMode.DEFAULT);
    }

    private static OperationStatus getEndFromPrefix(SecondaryCursor cursor, IndexImpl index, IndexRange range, DatabaseEntry keyEntry, DatabaseEntry pkeyEntry, DatabaseEntry dataEntry) {
        assert (range.getPrefixKey() != null);
        IndexKeyImpl indexKey = index.rowFromIndexKey(range.getPrefixKey(), true);
        if (!indexKey.incrementIndexKey()) {
            return cursor.getLast(keyEntry, pkeyEntry, dataEntry, LockMode.DEFAULT);
        }
        byte[] bytes = index.serializeIndexKey(indexKey);
        keyEntry.setData(bytes);
        return DbInternal.search((Cursor)cursor, (DatabaseEntry)keyEntry, (DatabaseEntry)pkeyEntry, (DatabaseEntry)dataEntry, (DbInternal.Search)DbInternal.Search.LT, (LockMode)LockMode.DEFAULT);
    }

    static TableImpl getAndCheckTable(OperationHandler operationHandler, long tableId) {
        if (tableId == 0L) {
            return null;
        }
        TableImpl table = TableOperationHandler.getTable(operationHandler, tableId);
        if (table == null) {
            throw new FaultException("Cannot access table.  It may not exist, id: " + tableId, true);
        }
        return table;
    }

    static TableImpl getTable(OperationHandler operationHandler, long tableId) {
        return operationHandler.getRepNode().getTable(tableId);
    }

    static TableImpl findTableByKeyBytes(OperationHandler operationHandler, byte[] keyBytes) {
        if (keyBytes == null || keyBytes.length == 0) {
            return null;
        }
        Key fullKey = Key.fromByteArray(keyBytes);
        String firstComponent = fullKey.getMajorPath().get(0);
        TableImpl topLevelTable = null;
        try {
            long possibleTableId = SortableString.longFromSortable(firstComponent);
            topLevelTable = operationHandler.getRepNode().getTable(possibleTableId);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        if (topLevelTable == null) {
            topLevelTable = operationHandler.getRepNode().getR2CompatTable(firstComponent);
        }
        if (topLevelTable != null) {
            return topLevelTable.findTargetTable(keyBytes);
        }
        return null;
    }

    static interface IndexScanVisitor {
        public int visit(SecondaryCursor var1, DatabaseEntry var2, DatabaseEntry var3, DatabaseEntry var4);

        public OperationStatus getNext(SecondaryCursor var1, DatabaseEntry var2, DatabaseEntry var3, DatabaseEntry var4);

        public OperationStatus getPrev(SecondaryCursor var1, DatabaseEntry var2, DatabaseEntry var3, DatabaseEntry var4);
    }
}

