/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultValueVersion;
import oracle.kv.impl.api.ops.SingleKeyOperation;
import oracle.kv.impl.security.KVStorePrivilege;
import oracle.kv.impl.security.SystemPrivilege;
import oracle.kv.impl.security.TablePrivilege;
import oracle.kv.impl.topo.PartitionId;

public class Get
extends SingleKeyOperation {
    private final long tableId;

    public Get(byte[] keyBytes) {
        this(keyBytes, 0L);
    }

    public Get(byte[] keyBytes, long tableId) {
        super(InternalOperation.OpCode.GET, keyBytes);
        this.tableId = tableId;
    }

    long getTableId() {
        return this.tableId;
    }

    Get(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.GET, in, serialVersion);
        this.tableId = serialVersion >= 4 ? in.readLong() : 0L;
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        if (serialVersion >= 4) {
            out.writeLong(this.tableId);
        } else if (this.tableId != 0L) {
            this.throwTablesRequired(serialVersion);
        }
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, OperationHandler operationHandler) {
        this.verifyDataAccess(operationHandler, this.tableId);
        ResultValueVersion resultValueVersion = operationHandler.get(txn, partitionId, this.getKeyBytes());
        return new Result.GetResult(this.getOpCode(), resultValueVersion);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.tableId != 0L) {
            sb.append(" Table Id ");
            sb.append(this.tableId);
        }
        return sb.toString();
    }

    @Override
    List<? extends KVStorePrivilege> schemaAccessPrivileges() {
        return SystemPrivilege.schemaReadPrivList;
    }

    @Override
    List<? extends KVStorePrivilege> generalAccessPrivileges() {
        return SystemPrivilege.readOnlyPrivList;
    }

    @Override
    public List<? extends KVStorePrivilege> tableAccessPrivileges(long tableId1) {
        return Collections.singletonList(new TablePrivilege.ReadTable(tableId1));
    }
}

