/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.lob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Key;
import oracle.kv.Value;
import oracle.kv.ValueVersion;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.lob.ChunkKeyFactory;
import oracle.kv.impl.api.lob.ChunkKeysIterator;
import oracle.kv.impl.api.lob.LOBMetadataKeys;
import oracle.kv.impl.util.UserDataControl;
import oracle.kv.lob.KVLargeObject;
import oracle.kv.lob.PartialLOBException;

public abstract class Operation {
    protected static final String INTERNAL_KEY_SPACE = "";
    protected static final String ILK_PREFIX_COMPONENT = "lob";
    protected static final String ILK_PREFIX = Key.createKey(Arrays.asList("", "lob")).toString() + "/";
    protected static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String UTF8_REPLACEMENT = UTF8_CHARSET.newDecoder().replacement();
    protected final KVStoreImpl kvsImpl;
    protected final Key appLOBKey;
    protected Key internalLOBKey;
    protected long chunkTimeoutMs;
    protected int chunkSize;
    protected int chunksPerPartition;
    protected long lobSize = Long.MIN_VALUE;
    protected long numChunks = Long.MIN_VALUE;
    protected LOBProps lobProps;
    protected ChunkKeyFactory chunkKeyFactory;
    static int testMetadataVersion = 0;

    Operation(KVStoreImpl kvsImpl, Key appLobKey, long chunkTimeout, TimeUnit timeoutUnit) {
        this.kvsImpl = kvsImpl;
        this.appLOBKey = this.checkLOBKey(appLobKey);
        this.chunkTimeoutMs = chunkTimeout > 0L ? TimeUnit.MILLISECONDS.convert(chunkTimeout, timeoutUnit) : kvsImpl.getDefaultLOBTimeout();
    }

    public static void setTestMetadataVersion(int testMetadataVersion) {
        Operation.testMetadataVersion = testMetadataVersion;
    }

    protected ValueVersion initMetadata(KVLargeObject.LOBState allowState) throws PartialLOBException {
        ValueVersion metadataVV = this.kvsImpl.get(this.internalLOBKey, Consistency.ABSOLUTE, this.chunkTimeoutMs, TimeUnit.MILLISECONDS);
        if (metadataVV == null) {
            String msg = "Partially put LOB (missing metadata). Key: " + UserDataControl.displayKey(this.appLOBKey) + " Internal key: " + this.internalLOBKey;
            throw new PartialLOBException(msg, KVLargeObject.LOBState.PARTIAL_PUT, false);
        }
        this.initMetadata(metadataVV.getValue());
        if (this.lobProps.isPartiallyDeleted() && KVLargeObject.LOBState.PARTIAL_DELETE != allowState) {
            throw new PartialLOBException("Partially deleted LOB. Key: " + UserDataControl.displayKey(this.appLOBKey) + " Internal key: " + this.internalLOBKey, KVLargeObject.LOBState.PARTIAL_DELETE, false);
        }
        if (this.lobProps.isPartiallyAppended() && KVLargeObject.LOBState.PARTIAL_APPEND != allowState) {
            throw new PartialLOBException("Partially appended LOB. Key: " + UserDataControl.displayKey(this.appLOBKey) + " Internal key: " + this.internalLOBKey, KVLargeObject.LOBState.PARTIAL_APPEND, false);
        }
        if (this.lobProps.isPartiallyPut() && KVLargeObject.LOBState.PARTIAL_PUT != allowState) {
            throw new PartialLOBException("Partially put LOB. Key: " + UserDataControl.displayKey(this.appLOBKey) + " Internal key: " + this.internalLOBKey, KVLargeObject.LOBState.PARTIAL_PUT, false);
        }
        if (allowState == KVLargeObject.LOBState.COMPLETE && !this.lobProps.isComplete()) {
            throw new IllegalStateException("Expected complete LOB. Key: " + UserDataControl.displayKey(this.appLOBKey) + " Internal key: " + this.internalLOBKey);
        }
        return metadataVV;
    }

    protected void initMetadata(Value propMapValue) {
        this.lobProps = new LOBProps(propMapValue);
        int mdVersion = this.lobProps.getMetadataVersion();
        if (mdVersion > this.getCurrentVersion()) {
            throw new IllegalStateException("Unknown metadata version:" + mdVersion);
        }
        this.chunkKeyFactory = new ChunkKeyFactory(mdVersion);
    }

    protected void initMetadata() {
        this.lobProps = new LOBProps();
        int mdVersion = this.lobProps.getMetadataVersion();
        this.chunkKeyFactory = new ChunkKeyFactory(mdVersion);
    }

    private int getCurrentVersion() {
        int mdVersion = testMetadataVersion > 0 ? testMetadataVersion : 2;
        return mdVersion;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public LOBProps getLOBProps() {
        return this.lobProps;
    }

    public KVStoreImpl getKvsImpl() {
        return this.kvsImpl;
    }

    public Key getInternalLOBKey() {
        return this.internalLOBKey;
    }

    public long getChunkTimeoutMs() {
        return this.chunkTimeoutMs;
    }

    protected ChunkKeysIterator getChunkKeysByteRangeIterator(long startByteIndex, long endByteIndex) {
        return new ChunkKeysIterator(this.internalLOBKey, startByteIndex, endByteIndex, this.chunkSize, this.chunksPerPartition, this.chunkKeyFactory);
    }

    protected ChunkKeysIterator getChunkKeysNumChunksIterator(long nChunks) {
        return new ChunkKeysIterator(this.internalLOBKey, 0L, (long)this.chunkSize * nChunks, this.chunkSize, this.chunksPerPartition, this.chunkKeyFactory);
    }

    public ChunkKeyFactory getChunkKeyFactory() {
        return this.chunkKeyFactory;
    }

    private Key checkLOBKey(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("LOB key must not be null");
        }
        List<String> fullPath = key.getFullPath();
        String lastComponent = fullPath.get(fullPath.size() - 1);
        String lobSuffix = this.kvsImpl.getDefaultLOBSuffix();
        if (lobSuffix != null && !lastComponent.endsWith(lobSuffix)) {
            throw new IllegalArgumentException("LOB key: " + key + " must end with the suffix: " + lobSuffix);
        }
        return key;
    }

    public static Key valueToILK(Value serializedKeyValue) {
        try {
            return Operation.valueToILKInternal(serializedKeyValue, UTF8_CHARSET);
        }
        catch (IllegalArgumentException iae) {
            try {
                return Operation.valueToILKInternal(serializedKeyValue, null);
            }
            catch (IllegalArgumentException iae2) {
                throw iae;
            }
        }
    }

    public static Key valueToILKInternal(Value serializedKeyValue, Charset charSet) throws IllegalStateException {
        String ilkString;
        String string = ilkString = charSet == null ? new String(serializedKeyValue.getValue()) : new String(serializedKeyValue.getValue(), charSet);
        if (!ilkString.startsWith(ILK_PREFIX)) {
            throw new IllegalArgumentException("Invalid ILK:" + ilkString);
        }
        if (ilkString.contains(UTF8_REPLACEMENT)) {
            throw new IllegalArgumentException("Invalid ILK:" + ilkString);
        }
        Key ilk = Key.fromString(ilkString);
        if (ilk.getFullPath().size() != 3) {
            throw new IllegalStateException("Invalid ILK:" + ilkString);
        }
        return ilk;
    }

    public static Value ilkToValue(Key key) {
        return Value.createValue(key.toString().getBytes(UTF8_CHARSET));
    }

    static long skipInput(InputStream in, long nBytes) throws IOException {
        long totalBytesSkipped;
        long thisSkip;
        for (totalBytesSkipped = 0L; totalBytesSkipped < nBytes && (thisSkip = in.skip(nBytes - totalBytesSkipped)) != 0L; totalBytesSkipped += thisSkip) {
        }
        return totalBytesSkipped;
    }

    class LOBProps
    implements LOBMetadataKeys {
        private final Map<String, Object> propMap;

        LOBProps() {
            this.propMap = new HashMap<String, Object>();
            this.propMap.put("metadataVersion", Operation.this.getCurrentVersion());
        }

        public LOBProps(Value propMapValue) {
            Object rawObject = null;
            Exception exception = null;
            try {
                Map coercePropMap;
                ByteArrayInputStream bis = new ByteArrayInputStream(propMapValue.getValue());
                ObjectInputStream ois = new ObjectInputStream(bis);
                rawObject = ois.readObject();
                this.propMap = coercePropMap = (Map)rawObject;
                Operation.this.chunkSize = (Integer)this.propMap.get("chunkSize");
                Operation.this.chunksPerPartition = (Integer)this.propMap.get("numChunksPerPartition");
                if (this.getLOBSize() != null) {
                    Operation.this.lobSize = this.getLOBSize();
                }
                if (this.getNumChunks() != null) {
                    Operation.this.numChunks = this.getNumChunks();
                }
                return;
            }
            catch (IOException e) {
                exception = e;
            }
            catch (ClassNotFoundException e) {
                exception = e;
            }
            catch (ClassCastException e) {
                exception = e;
            }
            String msg = "Unexpected exception. +  The value: " + rawObject + " associated with the key: " + UserDataControl.displayKey(Operation.this.appLOBKey) + " does not represent a LOB value.";
            throw new IllegalArgumentException(msg, exception);
        }

        Value serialize() {
            int mdVersion = this.getMetadataVersion();
            Map<String, Object> serialMap = this.propMap;
            if (mdVersion == 1) {
                Long nchunks;
                serialMap = new HashMap<String, Object>(this.propMap);
                Long lscid = this.getLong("lastSuperChunkId");
                if (lscid != null) {
                    if (lscid > Integer.MAX_VALUE) {
                        throw new IllegalStateException("LAST_SUPER_CHUNK_ID:" + lscid + " exceeds Integer.MAX_VALUE");
                    }
                    serialMap.put("lastSuperChunkId", new Integer((int)lscid.longValue()));
                }
                if ((nchunks = this.getLong("numChunks")) != null) {
                    if (nchunks > Integer.MAX_VALUE) {
                        throw new IllegalStateException("NUM_CHUNKS:" + nchunks + " exceeds Integer.MAX_VALUE");
                    }
                    serialMap.put("numChunks", new Integer((int)nchunks.longValue()));
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(serialMap);
                oos.close();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Unexpected exception", ioe);
            }
            return Value.createValue(bos.toByteArray());
        }

        int getVersion() {
            return (Integer)this.propMap.get("metadataVersion");
        }

        private Long getLong(String key) {
            Object value = this.propMap.get(key);
            return value instanceof Integer ? new Long(((Integer)value).intValue()) : (Long)value;
        }

        boolean isComplete() {
            return this.propMap.containsKey("numChunks");
        }

        public boolean isPartiallyPut() {
            return this.propMap.get("numChunks") == null && !this.isPartiallyDeleted() && !this.isPartiallyAppended();
        }

        public boolean isPartiallyAppended() {
            return this.propMap.get("appendLobSize") != null;
        }

        boolean isPartiallyDeleted() {
            return this.propMap.get("deleted") != null;
        }

        public void markDeleted() {
            this.propMap.put("deleted", new Date().toString());
        }

        public Object remove(String key) {
            return this.propMap.remove(key);
        }

        public Long getNumChunks() {
            return this.getLong("numChunks");
        }

        public void setNumChunks(long numChunks) {
            this.propMap.put("numChunks", numChunks);
        }

        public Long getLastSuperChunkId() {
            return this.getLong("lastSuperChunkId");
        }

        public void setLastSuperChunkId(long superChunkId) {
            this.propMap.put("lastSuperChunkId", superChunkId);
        }

        public Long getAppendLobSize() {
            return (Long)this.propMap.get("appendLobSize");
        }

        public void setAppendLobSize(long appendLobSize) {
            this.propMap.put("appendLobSize", appendLobSize);
        }

        public Long getLOBSize() {
            return this.getLong("lobSize");
        }

        void setLOBSize(long lobSize) {
            this.propMap.put("lobSize", lobSize);
        }

        public int getMetadataVersion() {
            return (Integer)this.propMap.get("metadataVersion");
        }

        void startAppend() {
            this.setAppendLobSize(Operation.this.lobSize);
            this.remove("lobSize");
            this.remove("numChunks");
        }

        void endAppend() {
            this.remove("appendLobSize");
            this.endPut();
        }

        void startPut() {
            Operation.this.chunkSize = Operation.this.kvsImpl.getDefaultChunkSize();
            Operation.this.chunksPerPartition = Operation.this.kvsImpl.getDefaultChunksPerPartition();
            Operation.this.lobSize = 0L;
            Operation.this.numChunks = 0L;
            this.propMap.put("chunkSize", Operation.this.chunkSize);
            this.propMap.put("numChunksPerPartition", Operation.this.chunksPerPartition);
            this.propMap.put("appKey", Operation.this.appLOBKey.toString());
            this.propMap.put("lastSuperChunkId", 1L);
        }

        void endPut() {
            if (Operation.this.lobSize == 0L && Operation.this.numChunks != 0L || Operation.this.lobSize != 0L && (Operation.this.lobSize - 1L) / (long)Operation.this.chunkSize + 1L != Operation.this.numChunks) {
                String msg = "LOBsize:" + Operation.this.lobSize + " is inconsistent with the chunk count:" + Operation.this.numChunks + " for the chunk size:" + Operation.this.chunkSize;
                throw new IllegalStateException(msg);
            }
            if (Operation.this.numChunks == 0L && this.getLastSuperChunkId() != 1L || Operation.this.numChunks > 0L && this.getLastSuperChunkId() != (Operation.this.numChunks - 1L) / (long)Operation.this.chunksPerPartition + 1L) {
                String msg = "Inconsistent super chunk id:" + this.getLastSuperChunkId() + " for num chunks:" + Operation.this.numChunks;
                throw new IllegalStateException(msg);
            }
            this.setLOBSize(Operation.this.lobSize);
            this.setNumChunks(Operation.this.numChunks);
            Long lastScid = this.getLastSuperChunkId();
            if (lastScid == null || lastScid < 0L) {
                throw new IllegalStateException("LOBProps:" + Operation.this.lobProps);
            }
        }

        public String toString() {
            return "< LOBProps:  Internal LOB key:" + Operation.this.internalLOBKey + " LOB size:" + this.getLOBSize() + " Chunk size:" + Operation.this.getChunkSize() + " Num chunks: " + this.getNumChunks() + " Last SC id:" + this.getLastSuperChunkId() + " >";
        }
    }
}

