/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Direction;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class TableInputSplit
extends InputSplit
implements Writable {
    private String[] locations = new String[0];
    private String kvStore;
    private String[] kvHelperHosts;
    private String tableName;
    private String primaryKeyProperty;
    private String fieldRangeProperty;
    private Direction direction;
    private Consistency consistency;
    private long timeout;
    private TimeUnit timeoutUnit;
    private int maxRequests;
    private int batchSize;
    private int maxBatches;
    private List<Set<Integer>> partitionSets;
    private String kvStoreSecurityFile;

    public long getLength() {
        return this.partitionSets.size();
    }

    public String[] getLocations() {
        return this.locations;
    }

    TableInputSplit setLocations(String[] newLocations) {
        this.locations = newLocations;
        return this;
    }

    TableInputSplit setKVHelperHosts(String[] newHelperHosts) {
        this.kvHelperHosts = newHelperHosts;
        return this;
    }

    public String[] getKVHelperHosts() {
        return this.kvHelperHosts;
    }

    TableInputSplit setKVStoreName(String newStoreName) {
        this.kvStore = newStoreName;
        return this;
    }

    public String getKVStoreName() {
        return this.kvStore;
    }

    public String getTableName() {
        return this.tableName;
    }

    TableInputSplit setTableName(String newTableName) {
        this.tableName = newTableName;
        return this;
    }

    TableInputSplit setPrimaryKeyProperty(String newProperty) {
        this.primaryKeyProperty = newProperty;
        return this;
    }

    String getPrimaryKeyProperty() {
        return this.primaryKeyProperty;
    }

    TableInputSplit setFieldRangeProperty(String newProperty) {
        this.fieldRangeProperty = newProperty;
        return this;
    }

    String getFieldRangeProperty() {
        return this.fieldRangeProperty;
    }

    TableInputSplit setDirection(Direction newDirection) {
        this.direction = newDirection;
        return this;
    }

    Direction getDirection() {
        return this.direction;
    }

    TableInputSplit setConsistency(Consistency newConsistency) {
        this.consistency = newConsistency;
        return this;
    }

    Consistency getConsistency() {
        return this.consistency;
    }

    TableInputSplit setTimeout(long newTimeout) {
        this.timeout = newTimeout;
        return this;
    }

    long getTimeout() {
        return this.timeout;
    }

    TableInputSplit setTimeoutUnit(TimeUnit newTimeoutUnit) {
        this.timeoutUnit = newTimeoutUnit;
        return this;
    }

    TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    TableInputSplit setMaxRequests(int newMaxRequests) {
        this.maxRequests = newMaxRequests;
        return this;
    }

    int getMaxRequests() {
        return this.maxRequests;
    }

    TableInputSplit setBatchSize(int newBatchSize) {
        this.batchSize = newBatchSize;
        return this;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    TableInputSplit setMaxBatches(int newMaxBatches) {
        this.maxBatches = newMaxBatches;
        return this;
    }

    int getMaxBatches() {
        return this.maxBatches;
    }

    void setPartitionSets(List<Set<Integer>> partitionSets) {
        this.partitionSets = partitionSets;
    }

    List<Set<Integer>> getPartitionSets() {
        return this.partitionSets;
    }

    TableInputSplit setKVStoreSecurityFile(String securityFile) {
        this.kvStoreSecurityFile = securityFile;
        return this;
    }

    String getKVStoreSecurityFile() {
        return this.kvStoreSecurityFile;
    }

    public void write(DataOutput out) throws IOException {
        int i;
        out.writeInt(this.locations.length);
        for (i = 0; i < this.locations.length; ++i) {
            Text.writeString((DataOutput)out, (String)this.locations[i]);
        }
        out.writeInt(this.kvHelperHosts.length);
        for (i = 0; i < this.kvHelperHosts.length; ++i) {
            Text.writeString((DataOutput)out, (String)this.kvHelperHosts[i]);
        }
        Text.writeString((DataOutput)out, (String)this.kvStore);
        Text.writeString((DataOutput)out, (String)this.tableName);
        Text.writeString((DataOutput)out, (String)(this.primaryKeyProperty == null ? "" : this.primaryKeyProperty));
        Text.writeString((DataOutput)out, (String)(this.fieldRangeProperty == null ? "" : this.fieldRangeProperty));
        Text.writeString((DataOutput)out, (String)(this.direction == null ? "" : this.direction.name()));
        this.writeBytes(out, this.consistency == null ? null : this.consistency.toByteArray());
        out.writeLong(this.timeout);
        Text.writeString((DataOutput)out, (String)(this.timeoutUnit == null ? "" : this.timeoutUnit.name()));
        out.writeInt(this.maxRequests);
        out.writeInt(this.batchSize);
        out.writeInt(this.maxBatches);
        out.writeInt(this.partitionSets.size());
        for (Set<Integer> partitions : this.partitionSets) {
            out.writeInt(partitions.size());
            for (Integer p : partitions) {
                out.writeInt(p);
            }
        }
        Text.writeString((DataOutput)out, (String)(this.kvStoreSecurityFile == null ? "" : this.kvStoreSecurityFile));
    }

    public void readFields(DataInput in) throws IOException {
        int nSets;
        String dirStr;
        int len = in.readInt();
        this.locations = new String[len];
        for (int i = 0; i < len; ++i) {
            this.locations[i] = Text.readString((DataInput)in);
        }
        int nHelperHosts = in.readInt();
        this.kvHelperHosts = new String[nHelperHosts];
        for (int i = 0; i < nHelperHosts; ++i) {
            this.kvHelperHosts[i] = Text.readString((DataInput)in);
        }
        this.kvStore = Text.readString((DataInput)in);
        this.tableName = Text.readString((DataInput)in);
        this.primaryKeyProperty = Text.readString((DataInput)in);
        if (this.primaryKeyProperty != null && "".equals(this.primaryKeyProperty)) {
            this.primaryKeyProperty = null;
        }
        this.fieldRangeProperty = Text.readString((DataInput)in);
        if (this.fieldRangeProperty != null && "".equals(this.fieldRangeProperty)) {
            this.fieldRangeProperty = null;
        }
        this.direction = (dirStr = Text.readString((DataInput)in)) == null || "".equals(dirStr) ? Direction.UNORDERED : Direction.valueOf(dirStr);
        byte[] consBytes = this.readBytes(in);
        this.consistency = consBytes == null ? null : Consistency.fromByteArray(consBytes);
        this.timeout = in.readLong();
        String tuStr = Text.readString((DataInput)in);
        this.timeoutUnit = tuStr == null || "".equals(tuStr) ? null : TimeUnit.valueOf(tuStr);
        this.maxRequests = in.readInt();
        this.batchSize = in.readInt();
        this.maxBatches = in.readInt();
        this.partitionSets = new ArrayList<Set<Integer>>(nSets);
        for (nSets = in.readInt(); nSets > 0; --nSets) {
            int nPartitions;
            HashSet<Integer> partitions = new HashSet<Integer>(nPartitions);
            this.partitionSets.add(partitions);
            for (nPartitions = in.readInt(); nPartitions > 0; --nPartitions) {
                partitions.add(in.readInt());
            }
        }
        this.kvStoreSecurityFile = Text.readString((DataInput)in);
        if (this.kvStoreSecurityFile == null || "".equals(this.kvStoreSecurityFile)) {
            this.kvStoreSecurityFile = null;
        }
    }

    private void writeBytes(DataOutput out, byte[] bytes) throws IOException {
        if (bytes == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private byte[] readBytes(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == 0) {
            return null;
        }
        byte[] ret = new byte[len];
        in.readFully(ret);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TableInputSplit)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TableInputSplit obj1 = this;
        TableInputSplit obj2 = (TableInputSplit)((Object)obj);
        String obj2KvStoreName = obj2.getKVStoreName();
        if (obj1.kvStore == null || obj2KvStoreName == null) {
            return false;
        }
        if (!obj1.kvStore.equals(obj2KvStoreName)) {
            return false;
        }
        if (obj1.locations == null || obj2.getLocations() == null) {
            return false;
        }
        List<String> obj1Locations = Arrays.asList(obj1.locations);
        List<String> obj2Locations = Arrays.asList(obj2.getLocations());
        if (obj1Locations.size() != obj2Locations.size()) {
            return false;
        }
        if (!obj1Locations.containsAll(obj2Locations)) {
            return false;
        }
        if (obj1.kvHelperHosts == null || obj2.getKVHelperHosts() == null) {
            return false;
        }
        List<String> obj1KvHelperHosts = Arrays.asList(obj1.kvHelperHosts);
        List<String> obj2KvHelperHosts = Arrays.asList(obj2.getKVHelperHosts());
        if (obj1KvHelperHosts.size() != obj2KvHelperHosts.size()) {
            return false;
        }
        if (!obj1KvHelperHosts.containsAll(obj2KvHelperHosts)) {
            return false;
        }
        if (obj1.tableName != null && !obj1.tableName.equals(obj2.getTableName())) {
            return false;
        }
        if (obj1.primaryKeyProperty != null && !obj1.primaryKeyProperty.equals(obj2.getPrimaryKeyProperty())) {
            return false;
        }
        if (obj1.fieldRangeProperty != null && !obj1.fieldRangeProperty.equals(obj2.getFieldRangeProperty())) {
            return false;
        }
        if (this.partitionSets != null) {
            return obj1.partitionSets == null ? false : this.partitionSets.containsAll(obj2.partitionSets);
        }
        return obj2.partitionSets == null;
    }

    public int hashCode() {
        int pm = 37;
        int hc = 11;
        int hcSum = 0;
        if (this.kvStore != null) {
            hcSum += this.kvStore.hashCode();
        }
        hcSum += Arrays.hashCode(this.locations);
        hcSum += Arrays.hashCode(this.kvHelperHosts);
        if (this.tableName != null) {
            hcSum += this.tableName.hashCode();
        }
        if (this.primaryKeyProperty != null) {
            hcSum += this.primaryKeyProperty.hashCode();
        }
        if (this.fieldRangeProperty != null) {
            hcSum += this.fieldRangeProperty.hashCode();
        }
        if (this.partitionSets != null) {
            hcSum += this.partitionSets.hashCode();
        }
        hc = 37 * hc + hcSum;
        return hc;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName());
        buf.append(": [store=");
        buf.append(this.kvStore);
        buf.append(", dataNodeLocations=");
        if (this.locations != null) {
            buf.append(Arrays.asList(this.locations));
        } else {
            buf.append("null");
        }
        buf.append(", kvStoreHosts=");
        if (this.kvHelperHosts != null) {
            buf.append(Arrays.asList(this.kvHelperHosts));
        } else {
            buf.append("null");
        }
        if (this.tableName == null) {
            buf.append(", tableName=NOT_SET_YET");
        } else {
            buf.append(", tableName=");
            buf.append(this.tableName);
        }
        if (this.primaryKeyProperty == null) {
            buf.append(", primaryKeyProperty=wild-card");
        } else {
            buf.append(", primaryKeyProperty=");
            buf.append(this.primaryKeyProperty);
        }
        if (this.fieldRangeProperty == null) {
            buf.append(", fieldRangeProperty=all-ranges");
        } else {
            buf.append(", fieldRangeProperty=");
            buf.append(this.fieldRangeProperty);
        }
        if (this.partitionSets == null) {
            buf.append(", partitionSets=null");
        } else {
            int maxListSize = 5;
            int maxSetSize = 3;
            buf.append(", partitionSets=[");
            int i = 0;
            for (Set<Integer> partitionSet : this.partitionSets) {
                if (i >= 5) {
                    buf.append(", ...");
                    break;
                }
                if (i > 0) {
                    buf.append(", [");
                } else {
                    buf.append("[");
                }
                ++i;
                this.bufPartitionIdSets(partitionSet, 3, buf);
                buf.append("]");
            }
            buf.append("]");
        }
        buf.append("]");
        return buf.toString();
    }

    private void bufPartitionIdSets(Set<Integer> partitionSet, int maxSetSize, StringBuilder buf) {
        int i = 0;
        for (Integer partitionId : partitionSet) {
            if (i >= maxSetSize) {
                buf.append(", ...");
                break;
            }
            if (i > 0) {
                buf.append(", " + partitionId);
            } else {
                buf.append(partitionId);
            }
            ++i;
        }
    }
}

