/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.hadoop.table.TableInputSplit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;

public class TableHiveInputSplit
extends FileSplit {
    private final TableInputSplit v2Split;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public TableHiveInputSplit() {
        super((Path)null, 0L, 0L, EMPTY_STRING_ARRAY);
        this.v2Split = new TableInputSplit();
    }

    public TableHiveInputSplit(Path filePath, TableInputSplit v2Split) {
        super(filePath, 0L, 0L, EMPTY_STRING_ARRAY);
        this.v2Split = v2Split;
    }

    public Path getPath() {
        return super.getPath();
    }

    public long getLength() {
        return this.v2Split.getLength();
    }

    public String[] getLocations() throws IOException {
        return this.v2Split.getLocations();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.v2Split.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.v2Split.readFields(in);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TableHiveInputSplit)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TableHiveInputSplit obj1 = this;
        TableHiveInputSplit obj2 = (TableHiveInputSplit)((Object)obj);
        Path path1 = obj1.getPath();
        Path path2 = obj2.getPath();
        if (path1 != null ? !path1.equals((Object)path2) : path2 != null) {
            return false;
        }
        return obj1.v2Split.equals((Object)obj2.v2Split);
    }

    public int hashCode() {
        int hc = 0;
        Path filePath = this.getPath();
        if (filePath != null) {
            hc = filePath.hashCode();
        }
        return hc + this.v2Split.hashCode();
    }

    public String toString() {
        if (this.v2Split == null) {
            return super.toString();
        }
        StringBuilder buf = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName());
        buf.append(": [path=");
        buf.append(this.getPath());
        buf.append("], ");
        buf.append(this.v2Split.toString());
        return buf.toString();
    }

    public String getKVStoreName() {
        return this.v2Split.getKVStoreName();
    }

    public String[] getKVHelperHosts() {
        return this.v2Split.getKVHelperHosts();
    }

    public String getTableName() {
        return this.v2Split.getTableName();
    }
}

