/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class VLSN
implements Loggable,
Comparable<VLSN>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LOG_SIZE = 8;
    public static final VLSN NULL_VLSN = new VLSN(-1L);
    public static final VLSN FIRST_VLSN = new VLSN(1L);
    private long sequence;

    public VLSN(long sequence) {
        this.sequence = sequence;
    }

    public VLSN() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VLSN)) {
            return false;
        }
        VLSN otherVLSN = (VLSN)obj;
        return otherVLSN.sequence == this.sequence;
    }

    public final boolean equals(VLSN otherVLSN) {
        return otherVLSN != null && otherVLSN.sequence == this.sequence;
    }

    public int hashCode() {
        return Long.valueOf(this.sequence).hashCode();
    }

    public long getSequence() {
        return this.sequence;
    }

    public final boolean isNull() {
        return this.sequence == VLSN.NULL_VLSN.sequence;
    }

    public static boolean isNull(long sequence) {
        return sequence == VLSN.NULL_VLSN.sequence;
    }

    public VLSN getNext() {
        return this.isNull() ? FIRST_VLSN : new VLSN(this.sequence + 1L);
    }

    public VLSN getPrev() {
        return this.isNull() || this.sequence == 1L ? NULL_VLSN : new VLSN(this.sequence - 1L);
    }

    public boolean follows(VLSN other) {
        return other.isNull() && this.sequence == 1L || !other.isNull() && other.getSequence() == this.sequence - 1L;
    }

    @Override
    public int compareTo(VLSN other) {
        if (this.sequence == VLSN.NULL_VLSN.sequence && other.sequence == VLSN.NULL_VLSN.sequence) {
            return 0;
        }
        if (this.sequence == VLSN.NULL_VLSN.sequence) {
            return -1;
        }
        if (other.sequence == VLSN.NULL_VLSN.sequence) {
            return 1;
        }
        long otherSequence = other.getSequence();
        if (this.sequence - otherSequence > 0L) {
            return 1;
        }
        if (this.sequence == otherSequence) {
            return 0;
        }
        return -1;
    }

    public static VLSN min(VLSN a, VLSN b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException("The arguments must not be null");
        }
        if (a.isNull()) {
            return b;
        }
        if (b.isNull()) {
            return a;
        }
        return a.compareTo(b) <= 0 ? a : b;
    }

    @Override
    public int getLogSize() {
        return 8;
    }

    @Override
    public void writeToLog(ByteBuffer buffer) {
        LogUtils.writeLong((ByteBuffer)buffer, (long)this.sequence);
    }

    @Override
    public void readFromLog(ByteBuffer buffer, int entryVersion) {
        this.sequence = LogUtils.readLong((ByteBuffer)buffer);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<vlsn v=\"").append(this).append("\">");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof VLSN)) {
            return false;
        }
        return this.sequence == ((VLSN)other).sequence;
    }

    public String toString() {
        return String.format("%,d", this.sequence);
    }
}

