/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.uri.URITemplates;
import oracle.dbtools.rt.web.FrameOptions;
import oracle.dbtools.rt.web.HttpMethod;

public class RequestHandlerMetaData {
    private final boolean corsEnabled;
    private final FrameOptions frameOptions;
    private final Iterable<CharSequence> methods;
    private final Iterable<String> originsAllowed;
    private final SecurityConfig securityConfig;
    private final URITemplate uriTemplate;
    private final boolean validateCSRFToken;

    private RequestHandlerMetaData(Iterable<CharSequence> methods, URITemplate uriTemplate, SecurityConfig securityConfig, boolean validateCSRFToken, Iterable<String> originsAllowed, boolean corsEnabled, FrameOptions frameOptions) {
        this.methods = methods;
        this.uriTemplate = uriTemplate;
        this.securityConfig = securityConfig;
        this.validateCSRFToken = validateCSRFToken;
        this.originsAllowed = originsAllowed;
        this.corsEnabled = corsEnabled;
        this.frameOptions = frameOptions;
    }

    public boolean corsEnabled() {
        return this.corsEnabled;
    }

    public FrameOptions frameOptions() {
        return this.frameOptions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestHandlerMetaData other = (RequestHandlerMetaData)obj;
        if (this.corsEnabled != other.corsEnabled) {
            return false;
        }
        if (this.frameOptions != other.frameOptions) {
            return false;
        }
        if (this.methods == null ? other.methods != null : !this.methods.equals(other.methods)) {
            return false;
        }
        if (this.originsAllowed == null ? other.originsAllowed != null : !this.originsAllowed.equals(other.originsAllowed)) {
            return false;
        }
        if (this.securityConfig == null ? other.securityConfig != null : !this.securityConfig.equals(other.securityConfig)) {
            return false;
        }
        if (this.uriTemplate == null ? other.uriTemplate != null : !this.uriTemplate.equals(other.uriTemplate)) {
            return false;
        }
        return this.validateCSRFToken == other.validateCSRFToken;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.corsEnabled ? 1231 : 1237);
        result = 31 * result + (this.frameOptions == null ? 0 : this.frameOptions.hashCode());
        result = 31 * result + (this.methods == null ? 0 : this.methods.hashCode());
        result = 31 * result + (this.originsAllowed == null ? 0 : this.originsAllowed.hashCode());
        result = 31 * result + (this.securityConfig == null ? 0 : this.securityConfig.hashCode());
        result = 31 * result + (this.uriTemplate == null ? 0 : this.uriTemplate.hashCode());
        result = 31 * result + (this.validateCSRFToken ? 1231 : 1237);
        return result;
    }

    public boolean matches(CharSequence method, String path) {
        return this.uriTemplate.matches(path) && this.matches(method);
    }

    public Iterable<CharSequence> methods() {
        return this.methods;
    }

    public Iterable<String> originsAllowed() {
        return this.originsAllowed;
    }

    public SecurityConfig securityConfig() {
        return this.securityConfig;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("RequestHandlerMetaData [corsEnabled=");
        builder2.append(this.corsEnabled);
        builder2.append(", frameOptions=");
        builder2.append((Object)this.frameOptions);
        builder2.append(", methods=");
        builder2.append(this.methods);
        builder2.append(", originsAllowed=");
        builder2.append(this.originsAllowed);
        builder2.append(", securityConfig=");
        builder2.append(this.securityConfig);
        builder2.append(", uriTemplate=");
        builder2.append(this.uriTemplate);
        builder2.append(", validateCSRFToken=");
        builder2.append(this.validateCSRFToken);
        builder2.append("]");
        return builder2.toString();
    }

    public URITemplate uriTemplate() {
        return this.uriTemplate;
    }

    public boolean validateCSRFToken() {
        return this.validateCSRFToken;
    }

    private boolean matches(CharSequence method) {
        CharSequence supported;
        boolean matches = false;
        Iterator<CharSequence> i$ = this.methods.iterator();
        while (i$.hasNext() && !(matches = this.matches(supported = i$.next(), method))) {
        }
        return matches;
    }

    private boolean matches(CharSequence supported, CharSequence method) {
        return supported.toString().equalsIgnoreCase(method.toString());
    }

    public static Builder builder(String uriTemplate, CharSequence ... methods) {
        return new Builder(URITemplates.uriTemplate(uriTemplate), methods);
    }

    public static Builder builder(URITemplate uriTemplate, CharSequence ... methods) {
        return new Builder(uriTemplate, methods);
    }

    public static class Builder {
        private boolean corsEnabled = true;
        private FrameOptions frameOptions = FrameOptions.DENY;
        private final List<CharSequence> methods = new ArrayList<CharSequence>();
        private final List<String> originsAllowed = new ArrayList<String>();
        private SecurityConfig securityConfig = SecurityConfigs.NONE;
        private final URITemplate uriTemplate;
        private boolean validateCSRFToken = false;

        private Builder(URITemplate uriTemplate, CharSequence ... methods) {
            this.uriTemplate = uriTemplate;
            this.method(methods);
        }

        public RequestHandlerMetaData build() {
            if (this.methods.isEmpty()) {
                this.methods.add(HttpMethod.GET);
            }
            return new RequestHandlerMetaData(Collections.unmodifiableList(this.methods), this.uriTemplate, this.securityConfig, this.validateCSRFToken, this.originsAllowed, this.corsEnabled, this.frameOptions);
        }

        public Builder corsEnabled(boolean corsEnabled) {
            this.corsEnabled = corsEnabled;
            return this;
        }

        public Builder frameOptions(FrameOptions frameOptions) {
            this.frameOptions = frameOptions;
            return this;
        }

        public Builder method(CharSequence ... methods) {
            Iterables.add(this.methods, (Iterable)Iterables.iterable((Object[])methods));
            return this;
        }

        public Builder originsAllowed(String ... originsAllowed) {
            Iterables.add(this.originsAllowed, (Iterable)Iterables.iterable((Object[])originsAllowed));
            return this;
        }

        public Builder securityConfig(SecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public Builder validateCSRFToken(boolean validateCSRFToken) {
            this.validateCSRFToken = validateCSRFToken;
            return this;
        }
    }
}

