/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.auth.AuthenticationStatus;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.session.SessionState;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.CustomHttpHeader;
import oracle.dbtools.rt.web.FrameOptions;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.RequestPaths;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.WebException;

public abstract class RequestHandler
implements ResourceDispatcher {
    private final RequestHandlerMetaData metadata;
    private static final String CSRF_FIELD_NAME = "csrf_token";

    protected RequestHandler(RequestHandlerMetaData metadata) {
        this.metadata = metadata;
    }

    @Override
    public ResourceDispatcher.Score canDispatch(RequestEntity request) {
        return this.choose(request);
    }

    @Override
    public final HttpResource dispatch(ResourceDispatcher.Score score, RequestEntity request) throws IOException {
        if (score == null) {
            score = this.choose(request);
        }
        if (score.score() < 0) {
            throw WebException.notFound();
        }
        this.authorize(request);
        return this.dispatch(request);
    }

    public boolean isHtml(Entity response) {
        EntityHeader header = response.headers().header(HttpHeader.CONTENT_TYPE);
        if (header != null) {
            ContentType contentType = ContentType.contentType(header.value());
            return ContentType.matches(ContentTypes.HTML_TYPES, contentType);
        }
        return false;
    }

    public RequestHandlerMetaData metadata() {
        return this.metadata;
    }

    protected void activate() throws Exception {
    }

    protected final void activate(ServiceProperties props) throws Exception {
        this.activate();
    }

    protected Entity customMethod(RequestEntity request) throws IOException {
        throw this.methodNotAllowed(request);
    }

    protected void deactivate() throws Exception {
    }

    protected final void deactivate(ServiceProperties props) throws Exception {
        this.deactivate();
    }

    protected Map<String, String> decodeUriTemplate(CharSequence path) {
        return this.metadata.uriTemplate().decode(path.toString());
    }

    protected Map<String, String> decodeUriTemplate(RequestEntity request) {
        return this.decodeUriTemplate(request.path());
    }

    protected Entity delete(RequestEntity request) throws IOException {
        throw this.methodNotAllowed(request);
    }

    protected String etag(RequestEntity request) throws IOException {
        return "";
    }

    protected Entity get(RequestEntity request) throws IOException {
        throw this.methodNotAllowed(request);
    }

    protected WebException methodNotAllowed(CharSequence requestedMethod) {
        ArrayList<String> allowableMethods = new ArrayList<String>();
        for (CharSequence method : this.metadata.methods()) {
            String m = method.toString();
            if (requestedMethod.toString().equalsIgnoreCase(m)) {
                throw new IllegalStateException(m);
            }
            allowableMethods.add(m);
        }
        return WebException.methodNotAllowed(allowableMethods);
    }

    protected Entity post(RequestEntity request) throws IOException {
        throw this.methodNotAllowed(request);
    }

    protected Entity put(RequestEntity request) throws IOException {
        throw this.methodNotAllowed(request);
    }

    protected Entity response(RequestEntity request) throws IOException {
        String method = request.method();
        Entity response = null;
        response = HttpMethod.GET.equals(method) ? this.get(request) : (HttpMethod.POST.equals(method) ? this.post(request) : (HttpMethod.PUT.equals(method) ? this.put(request) : (HttpMethod.DELETE.equals(method) ? this.delete(request) : (HttpMethod.OPTIONS.equals(method) ? this.options(request) : this.customMethod(request)))));
        response = this.frameOptions(response, this.metadata().frameOptions());
        return response;
    }

    protected final SessionState session(RequestEntity request) {
        SessionState session = SessionState.session(request);
        if (session == null) {
            LogonRealm logonRealm = this.metadata.securityConfig().logonRealm();
            if (LogonRealm.NONE == logonRealm) {
                logonRealm = LogonRealm.realm(request);
            }
            throw logonRealm.notAuthorized(request, AuthenticationStatus.UNKNOWN);
        }
        return session;
    }

    private void authorize(RequestEntity request) {
        request.verifySecurityConstraint(this.metadata.securityConfig().constraint(), this.metadata.securityConfig().logonRealm());
        this.crossSiteRequestForgeryProtection(request);
    }

    private ResourceDispatcher.Score choose(RequestEntity request) {
        int score;
        if (this.metadata.matches((CharSequence)request.method(), request.path()) && (score = this.score(this.metadata.uriTemplate(), request)) >= 0) {
            return new ResourceDispatcher.Score(score, this.metadata.securityConfig(), null, this.metadata.originsAllowed(), this.metadata.corsEnabled());
        }
        return ResourceDispatcher.NO_MATCH;
    }

    private void crossSiteRequestForgeryProtection(RequestEntity request) {
        String actualToken;
        SessionState session;
        String expectedToken;
        if (this.metadata.validateCSRFToken() && request.method().equalsIgnoreCase(HttpMethod.POST.method()) && !(expectedToken = (session = this.session(request)).csrfToken()).equals(actualToken = (String)Requests.formFields(request).get((Object)CSRF_FIELD_NAME))) {
            LogonRealm realm = LogonRealm.realm(request);
            throw realm.notAuthorized(request, AuthenticationStatus.UNKNOWN);
        }
    }

    private final HttpResource dispatch(RequestEntity request) throws IOException {
        Entity response = this.response(request);
        return new Response(request, response);
    }

    private Entity frameOptions(Entity response, FrameOptions frameOptions) {
        if (frameOptions == null || !this.isHtml(response)) {
            return response;
        }
        EntityHeaders headers = Entities.headers(CustomHttpHeader.FRAME_OPTIONS, frameOptions.name());
        return Entities.merge(response, headers);
    }

    private WebException methodNotAllowed(RequestEntity request) {
        String requestedMethod = request.method();
        return this.methodNotAllowed(requestedMethod);
    }

    private Entity options(RequestEntity request) throws IOException {
        String allowableMethods = Iterables.join(this.metadata.methods(), (String)", ");
        return Entities.entity(null, Entities.headers(HttpHeader.ALLOW, allowableMethods));
    }

    private final int score(URITemplate uriTemplate, RequestPaths request) {
        return uriTemplate.priority();
    }

    protected static Entity alsoClose(Entity entity, Object ... dependents) {
        return Entities.alsoClose(entity, dependents);
    }

    protected static Entity entity(CharSequence ... headerPairs) throws IOException {
        return RequestHandler.entity(null, RequestHandler.headers(headerPairs), new Object[0]);
    }

    protected static Entity entity(InputStream body, EntityHeaders headers, Object ... alsoClose) throws IOException {
        return RequestHandler.alsoClose(Entities.entity(body, headers), alsoClose);
    }

    protected static EntityHeaders headers(CharSequence ... headerPairs) {
        return Entities.headers(headerPairs);
    }

    protected static RequestHandlerMetaData.Builder metadata(String uriTemplate, CharSequence ... methods) {
        return RequestHandlerMetaData.builder(uriTemplate, methods);
    }

    protected static RequestHandlerMetaData publicResource(String uriTemplate) {
        return RequestHandler.metadata(uriTemplate, HttpMethod.GET).securityConfig(SecurityConfigs.NONE).build();
    }

    protected static RequestHandlerMetaData secure(String uriTemplate, CharSequence ... methods) {
        return RequestHandler.metadata(uriTemplate, methods).securityConfig(SecurityConfigs.SECURE).build();
    }

    protected static RequestHandlerMetaData secureService(String uriTemplate, CharSequence ... methods) {
        return RequestHandler.metadata(uriTemplate, methods).securityConfig(SecurityConfigs.SECURE_REST_SERVICE).build();
    }

    protected static RequestHandlerMetaData secureSession(LogonRealm realm, String uriTemplate, CharSequence ... methods) {
        return RequestHandler.metadata(uriTemplate, methods).securityConfig(realm.securityConfig()).build();
    }

    private final class Response
    implements HttpResource {
        private final RequestEntity request;
        private final Entity response;

        private Response(RequestEntity request, Entity response) {
            this.response = response;
            this.request = request;
        }

        @Override
        public Entity response(RequestEntity request) throws IOException {
            return this.response;
        }

        @Override
        public String version() {
            try {
                return RequestHandler.this.etag(this.request);
            }
            catch (IOException e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }
    }
}

