/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.apex.statistics.ErrorMessage;
import oracle.dbtools.apex.statistics.Statistics;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Collections;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.json.query.JSONQueryStream;
import oracle.dbtools.rt.statistics.ErrorMessageToResultRow;
import oracle.dbtools.rt.web.AcceptFormatting;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResources;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandler;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class ErrorsService
extends RequestHandler {
    private static final ErrorMessageToResultRow ERRORS_TO_ROWS = new ErrorMessageToResultRow();
    public static final RequestHandlerMetaData META_DATA = ErrorsService.secureService("_/statistics/errors", HttpMethod.GET);

    public ErrorsService() {
        super(META_DATA);
    }

    @Override
    protected Entity delete(RequestEntity request) throws IOException {
        Statistics.getInstance().clearErrorMessages();
        return HttpResources.NO_CONTENT;
    }

    @Override
    protected Entity get(RequestEntity request) throws IOException {
        AcceptFormatting contentFormatting = AcceptFormatting.contentFormatting(request);
        JSONOptions options = JSONOptions.configure(contentFormatting.parameters());
        Statistics.Report report = Statistics.getInstance().getReport();
        List errors = report.getErrors();
        Iterator<ResultRow> rows = this.asResultRows(Collections.reverseIterator((List)errors));
        return ErrorsService.entity((InputStream)((Object)new JSONQueryStream(rows, options, false, null)), ErrorsService.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, ContentTypes.JSON}), new Object[0]);
    }

    private Iterator<ResultRow> asResultRows(Iterator<ErrorMessage> errors) {
        return Iterators.transform(errors, (Transform)ERRORS_TO_ROWS);
    }
}

