/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityBase;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.resource.templates.v2.ResourceParameter;
import oracle.dbtools.rt.web.SecurityConstraint;
import oracle.dbtools.rt.web.ValidContentType;

public class ResourceHandler
extends TenantEntityBase
implements TenantEntity {
    @ValidContentType
    private String[] acceptableTypes;
    private String content;
    private Format format;
    private int itemsPerPage = -1;
    private String method;
    private String[] originsAllowed;
    private ResourceParameter[] parameters;
    private Https requireHttps = Https.YES;
    private SourceType sourceType;
    private TenantIdentifier templateId;

    public void content(String content) {
        this.content = content;
    }

    public int itemsPerPage() {
        return this.itemsPerPage;
    }

    public String method() {
        return this.method;
    }

    public ResourceParameter[] parameters() {
        return this.parameters;
    }

    @Override
    public TenantIdentifier parentId() {
        return this.templateId;
    }

    @Override
    public void parentId(TenantIdentifier templateId) {
        this.templateId = templateId;
    }

    public SecurityConstraint securityConstraint() {
        if (this.requireHttps == null) {
            return null;
        }
        switch (this.requireHttps) {
            case YES: {
                return SecurityConstraint.SECURE;
            }
        }
        return SecurityConstraint.NONE;
    }

    public void securityConstraint(SecurityConstraint securityConstraint) {
        Https requireHttps;
        this.requireHttps = requireHttps = ResourceHandler.requireHttps(securityConstraint);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceHandler [id=");
        b.append(this.id());
        b.append(", templateId=");
        b.append(this.templateId);
        b.append(", method=");
        b.append(this.method);
        b.append(", parameters=");
        b.append(Arrays.toString(this.parameters));
        b.append(", contentType=");
        b.append(this.contentType());
        b.append(", content=");
        b.append(this.content);
        b.append(", acceptableTypes=");
        b.append(Arrays.toString(this.acceptableTypes));
        b.append(", originsAllowed=");
        b.append(Arrays.toString(this.originsAllowed));
        b.append(", itemsPerPage=");
        b.append(this.itemsPerPage);
        b.append(", securityConstraint=");
        b.append((Object)this.securityConstraint());
        b.append(", metadata=");
        b.append(this.metadata());
        b.append("]");
        return b.toString();
    }

    String[] acceptableTypes() {
        return this.acceptableTypes;
    }

    void acceptableTypes(String ... acceptableTypes) {
        this.acceptableTypes = acceptableTypes;
    }

    String content() {
        return this.content;
    }

    String contentType() {
        return ResourceHandler.contentType(this.sourceType, this.format);
    }

    Format format() {
        return this.format;
    }

    void format(Format format) {
        this.format = format;
    }

    Iterable<ResourceParameter> inbound() {
        return Iterables.select((Iterable)Iterables.iterable((Object[])this.parameters), (Selector)new Selector<ResourceParameter>(){

            public Boolean apply(ResourceParameter x) {
                return x.access() == ParameterAccess.IN || x.access() == ParameterAccess.INOUT;
            }
        });
    }

    void itemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    void method(String method) {
        this.method = method.toUpperCase();
    }

    String[] originsAllowed() {
        return this.originsAllowed;
    }

    Iterable<ResourceParameter> outbound() {
        return Iterables.select((Iterable)Iterables.iterable((Object[])this.parameters), (Selector)new Selector<ResourceParameter>(){

            public Boolean apply(ResourceParameter x) {
                return x.access() == ParameterAccess.OUT || x.access() == ParameterAccess.INOUT;
            }
        });
    }

    void parameters(ResourceParameter ... parameters) {
        this.parameters = parameters;
    }

    Https requireHttps() {
        return this.requireHttps;
    }

    void requireHttps(Https requireHttps) {
        this.requireHttps = requireHttps;
    }

    SourceType sourceType() {
        return this.sourceType;
    }

    void sourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    TenantIdentifier templateId() {
        return this.templateId;
    }

    void templateId(TenantIdentifier templateId) {
        this.templateId = templateId;
    }

    public static ResourceHandlerBuilder builder() {
        return new ResourceHandlerBuilder();
    }

    public static ResourceHandlerBuilder builder(ResourceHandler existing) {
        return new ResourceHandlerBuilder(existing);
    }

    private static String contentType(SourceType type, Format format) {
        String contentType = "oracle.dbtools.rt.web.ResourceGenerator";
        if (SourceType.QUERY == type) {
            contentType = Format.CSV == format ? "csv/query" : "json/query";
        } else if (SourceType.QUERY_1_ROW == type) {
            contentType = "json/query;type=single";
        } else if (SourceType.PLSQL == type) {
            contentType = "plsql/block";
        } else if (SourceType.FEED == type) {
            contentType = "json/query;type=feed";
        } else if (SourceType.MEDIA == type) {
            contentType = "resource/lob";
        }
        return contentType;
    }

    private static Https requireHttps(SecurityConstraint securityConstraint) {
        Https requireHttps = Https.YES;
        switch (securityConstraint) {
            case SECURE: 
            case SECURE_AND_AUTHENTICATED: {
                requireHttps = Https.YES;
                break;
            }
            default: {
                requireHttps = Https.NO;
            }
        }
        return requireHttps;
    }

    private static Pair<SourceType, Format> sourceTypeAndFormat(String contentType) {
        SourceType sourceType = SourceType.QUERY;
        Format format = Format.DEFAULT;
        if ("csv/query".equals(contentType)) {
            format = Format.CSV;
        } else if ("json/query;type=single".equals(contentType)) {
            sourceType = SourceType.QUERY_1_ROW;
        } else if ("plsql/block".equals(contentType)) {
            sourceType = SourceType.PLSQL;
        } else if ("resource/lob".equals(contentType)) {
            sourceType = SourceType.MEDIA;
        } else if ("json/query;type=feed".equals(contentType)) {
            sourceType = SourceType.FEED;
        }
        return Pair.pair((Object)((Object)sourceType), (Object)((Object)format));
    }

    private static enum SourceType {
        FEED,
        MEDIA,
        PLSQL,
        QUERY,
        QUERY_1_ROW;

    }

    private static enum Https {
        NO,
        YES;

    }

    private static enum Format {
        CSV,
        DEFAULT;

    }

    public static final class ResourceHandlerBuilder
    extends Builder<ResourceHandler> {
        protected ResourceHandlerBuilder() {
        }

        protected ResourceHandlerBuilder(ResourceHandler existing) {
            super(existing);
        }

        @Override
        protected ResourceHandler newHandler() {
            return new ResourceHandler();
        }
    }

    public static abstract class Builder<T extends ResourceHandler> {
        protected T handler;
        protected final Set<ResourceParameter> parameters = new LinkedHashSet<ResourceParameter>();
        private final Set<String> acceptableTypes = new LinkedHashSet<String>();
        private final Set<String> originsAllowed = new LinkedHashSet<String>();

        protected Builder() {
            this.handler = this.newHandler();
        }

        protected Builder(T existing) {
            this();
            Iterables.add(this.acceptableTypes, (Iterable)Iterables.iterable((Object[])((ResourceHandler)existing).acceptableTypes()));
            Iterables.add(this.originsAllowed, (Iterable)Iterables.iterable((Object[])((ResourceHandler)existing).originsAllowed()));
            Iterables.add(this.parameters, (Iterable)Iterables.iterable((Object[])((ResourceHandler)existing).parameters()));
            ((ResourceHandler)this.handler).content(((ResourceHandler)existing).content());
            ((ResourceHandler)this.handler).sourceType(((ResourceHandler)existing).sourceType());
            ((ResourceHandler)this.handler).format(((ResourceHandler)existing).format());
            ((TenantEntityBase)this.handler).id(((TenantEntityBase)existing).id());
            ((ResourceHandler)this.handler).itemsPerPage(((ResourceHandler)existing).itemsPerPage());
            ((ResourceHandler)this.handler).method(((ResourceHandler)existing).method());
            ((ResourceHandler)this.handler).requireHttps(((ResourceHandler)existing).requireHttps());
            ((ResourceHandler)this.handler).templateId(((ResourceHandler)existing).templateId());
        }

        public Builder<T> acceptable(String type) {
            this.acceptableTypes.add(type);
            return this;
        }

        public T build() {
            ((ResourceHandler)this.handler).acceptableTypes(this.acceptableTypes.toArray(new String[this.acceptableTypes.size()]));
            ((ResourceHandler)this.handler).parameters(this.parameters.toArray(new ResourceParameter[this.parameters.size()]));
            Iterator<ResourceParameter> params = this.parameters.iterator();
            for (int i = 0; i < ((ResourceHandler)this.handler).parameters().length; ++i) {
                ((ResourceHandler)this.handler).parameters()[i] = params.next();
            }
            return this.handler;
        }

        public Builder<T> content(String text) {
            ((ResourceHandler)this.handler).content(text);
            return this;
        }

        public Builder<T> contentType(String contentType) {
            Pair sourceTypeAndFormat = ResourceHandler.sourceTypeAndFormat(contentType);
            ((ResourceHandler)this.handler).sourceType((SourceType)((Object)sourceTypeAndFormat.first()));
            ((ResourceHandler)this.handler).format((Format)((Object)sourceTypeAndFormat.second()));
            return this;
        }

        public boolean hasContent() {
            return ((ResourceHandler)this.handler).content() != null && !((ResourceHandler)this.handler).content().trim().isEmpty();
        }

        public Builder<T> id(TenantIdentifier id) {
            ((TenantEntityBase)this.handler).id(id);
            return this;
        }

        public Builder<T> itemsPerPage(int itemsPerPage) {
            ((ResourceHandler)this.handler).itemsPerPage(itemsPerPage);
            return this;
        }

        public Builder<T> method(String m) {
            ((ResourceHandler)this.handler).method(m.toUpperCase());
            return this;
        }

        public Builder<T> originAllowed(String originAllowed) {
            this.originsAllowed.add(originAllowed);
            return this;
        }

        public Builder<T> parameter(ResourceParameter.Kind type, String bindName, String originalName, Class<?> classOf, ParameterAccess access) {
            this.parameters.add(new ResourceParameter(type, bindName, originalName, classOf, access));
            return this;
        }

        public Builder<T> securityConstraint(SecurityConstraint securityConstraint) {
            ((ResourceHandler)this.handler).securityConstraint(securityConstraint);
            return this;
        }

        public Builder<T> templateId(TenantIdentifier templateId) {
            ((ResourceHandler)this.handler).parentId(templateId);
            return this;
        }

        protected abstract T newHandler();
    }
}

