/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.query;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Iterator;
import javax.xml.namespace.QName;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRowIterator;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ChunkedInputStream;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.StringBuilders;
import oracle.dbtools.common.util.Timestamps;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.json.JSONBuilder;
import oracle.dbtools.json.JSONFormatter;
import oracle.dbtools.json.JSONNode;
import oracle.dbtools.json.JSONOptions;
import oracle.dbtools.json.JSONProperty;
import oracle.dbtools.json.JSONValue;

public class JSONQueryStream
extends ChunkedInputStream {
    public static final QName ANTI_HIJACKING = new QName("items");

    public JSONQueryStream(Iterator<ResultRow> results, JSONOptions options, boolean firstRowOnly) {
        this(results, options, firstRowOnly, null);
    }

    public JSONQueryStream(Iterator<ResultRow> results, JSONOptions options, boolean firstRowOnly, Iterable<JSONProperty> additionalProperties) {
        super((ChunkedInputStream.Chunker)new JSONChunker(results, options, firstRowOnly, additionalProperties));
    }

    static JSONBuilder toJson(JSONOptions options, ResultRow result) {
        JSONBuilder b = JSONBuilder.o((JSONOptions)options);
        b.options(options);
        for (int i = 1; i <= result.size(); ++i) {
            String n = result.name(i);
            Object v = result.get(i);
            if (v instanceof Timestamp) {
                v = Timestamps.toString((long)((Timestamp)v).getTime());
            } else if (v instanceof ResultRow) {
                v = JSONQueryStream.toJson(options, (ResultRow)v);
            } else if (v instanceof ResultRowIterator) {
                v = JSONQueryStream.toJson(options, (ResultRowIterator)v);
            }
            b.p(n, v);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONBuilder toJson(JSONOptions options, ResultRowIterator rows) {
        JSONBuilder b = JSONBuilder.a((JSONOptions)options, (Iterable)new JSONRows(options, rows));
        b.options(options);
        JSONBuilder jSONBuilder = b;
        return jSONBuilder;
    }

    private static final class ResultRowToJSON
    implements Transform<ResultRow, JSONValue<?>> {
        private final JSONOptions options;

        private ResultRowToJSON(JSONOptions options) {
            this.options = options;
        }

        public JSONValue<?> apply(ResultRow row) {
            return JSONBuilder.v((JSONBuilder)JSONQueryStream.toJson(this.options, row));
        }
    }

    private static final class JSONRows
    implements Iterable<JSONValue<?>> {
        private final JSONOptions options;
        private final ResultRowIterator rows;

        private JSONRows(JSONOptions options, ResultRowIterator rows) {
            this.rows = rows;
            this.options = options;
        }

        @Override
        public Iterator<JSONValue<?>> iterator() {
            ResultRowToJSON json = new ResultRowToJSON(this.options);
            return Iterators.doNotClose((Iterator)Iterators.transform((Iterator)this.rows, (Transform)json));
        }
    }

    private static class JSONChunker
    extends AbstractIterator<byte[]>
    implements ChunkedInputStream.Chunker {
        private int count = 0;
        private final boolean firstRowOnly;
        private final JSONOptions options;
        private final Iterator<ResultRow> results;
        private final StringBuilder text = new StringBuilder();
        private final JSONFormatter w = new JSONFormatter((Appendable)this.text);

        public JSONChunker(Iterator<ResultRow> results, JSONOptions options, boolean firstRowOnly, Iterable<JSONProperty> additionalProperties) {
            this.results = results;
            this.firstRowOnly = firstRowOnly;
            this.options = options;
            this.preventArrayHijacking(additionalProperties);
        }

        public void close() throws IOException {
            Closeables.close((Object[])new Object[]{this.w, this.text, this.results});
        }

        protected byte[] advance() {
            byte[] chunk = null;
            if (this.results.hasNext()) {
                if (this.firstRowOnly && this.count > 0) {
                    return chunk;
                }
                ResultRow result = this.results.next();
                ++this.count;
                JSONBuilder b = JSONQueryStream.toJson(this.options, result);
                JSONBuilder.render((JSONFormatter)this.w, (JSONOptions)b.options(), (JSONNode)b.build());
            } else if (!this.firstRowOnly) {
                this.w.endArray();
                this.w.end();
            }
            this.w.flush();
            if (this.text.length() > 0) {
                chunk = StringBuilders.bytes((StringBuilder)this.text);
                StringBuilders.reset((StringBuilder)this.text);
            }
            return chunk;
        }

        private void preventArrayHijacking(Iterable<JSONProperty> additionalProperties) {
            if (!this.firstRowOnly) {
                this.w.start();
                if (additionalProperties != null) {
                    JSONBuilder.render((JSONFormatter)this.w, (JSONOptions)this.options, additionalProperties);
                }
                this.w.name(ANTI_HIJACKING);
                this.w.startArray();
            }
        }
    }
}

