/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication.apex;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import oracle.dbtools.apex.OWA;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.HeaderCallback;
import oracle.dbtools.auth.challenges.Challenges;
import oracle.dbtools.common.app.Version;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.plugin.api.security.AuthenticationChallenge;
import oracle.dbtools.rt.authentication.AllHeadersCallback;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.authentication.apex.SessionVerifierBase;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.oauth.CompoundPrincipalCallback;
import oracle.dbtools.rt.web.CustomHttpHeader;
import oracle.dbtools.rt.web.HttpHeader;

@Service(priority=1)
@Authenticates(value=AuthenticationRealm.RESOURCE_TEMPLATES)
public class ApexSessionVerifier
extends SessionVerifierBase
implements RealmAuthenticator {
    private static final String[] EMPTY = new String[0];
    private static final String ROLES = "roles";
    private static final String UNKNOWN = "nobody";
    private static final String USER = "user";
    private static final String GET_ROLES = "declare\ntype        t_roles_array is table of varchar2(4000);\nroles_array t_roles_array;\nroles varchar2(32767) := '';\nbegin\n select column_value\n  bulk collect into roles_array\n  from table(wwv_flow_listener.get_workspace_user_groups(:tenant_id,:user_id));\n for role in 1 .. roles_array.count loop\n  roles := roles || roles_array(role) || ', ';\n end loop;\n :roles := roles;\nend;\n";
    private static final Statement GET_ROLES_STMT = JDBCIdentifiers.tenantKeyParameter(StatementBuilder.call().append((CharSequence)"declare\ntype        t_roles_array is table of varchar2(4000);\nroles_array t_roles_array;\nroles varchar2(32767) := '';\nbegin\n select column_value\n  bulk collect into roles_array\n  from table(wwv_flow_listener.get_workspace_user_groups(:tenant_id,:user_id));\n for role in 1 .. roles_array.count loop\n  roles := roles || roles_array(role) || ', ';\n end loop;\n :roles := roles;\nend;\n")).parameter("user_id", String.class).parameter("roles", String.class, ParameterAccess.OUT).build();
    private static final Log LOG = Log.get(ApexSessionVerifier.class);
    private static final String VERIFY_SESSION = "declare\n  nm  owa.vc_arr := :header_names;   \n  vl  owa.vc_arr := :header_values;   \nbegin  \n dbms_session.modify_package_state(dbms_session.reinitialize);\n sys.owa.init_cgi_env( :num_headers, nm, vl ); \n\n wwv_flow.show (\n  p_request  => 'FSP_SHOW_POPUPLOV',\n  p_company  => :tenant_id,\n  p_instance => :session_id,\n  p_flow_id  => :application_id);\n :user  := wwv_flow.g_user;\nend;";
    private static final Statement VERIFY_STMT = JDBCIdentifiers.tenantKeyParameter(StatementBuilder.call().append((CharSequence)"declare\n  nm  owa.vc_arr := :header_names;   \n  vl  owa.vc_arr := :header_values;   \nbegin  \n dbms_session.modify_package_state(dbms_session.reinitialize);\n sys.owa.init_cgi_env( :num_headers, nm, vl ); \n\n wwv_flow.show (\n  p_request  => 'FSP_SHOW_POPUPLOV',\n  p_company  => :tenant_id,\n  p_instance => :session_id,\n  p_flow_id  => :application_id);\n :user  := wwv_flow.g_user;\nend;")).parameter("num_headers", Integer.class).parameter("header_names", String[].class).parameter("header_values", String[].class).parameter("session_id").parameter("application_id").parameter("user", String.class, ParameterAccess.OUT).build();

    public AuthenticationResult authenticate(CallbackHandler callbackHandler) {
        CompoundPrincipalCallback cp = new CompoundPrincipalCallback();
        HeaderCallback s = new HeaderCallback((CharSequence)CustomHttpHeader.APEX_SESSION);
        AllHeadersCallback h = new AllHeadersCallback();
        this.callback(callbackHandler, new Callback[]{h, s, cp});
        OWA.Headers hdrs = this.getHeaders(h.getHeaders());
        CompoundPrincipal requestPrincipal = cp.getPrincipal();
        String explicit = s.getValue();
        if (requestPrincipal != null) {
            Object[] segments = EMPTY;
            if (!NullOrEmpty.nullOrEmpty((CharSequence)explicit)) {
                segments = Text.commaDelimited((String)explicit);
                if (!NullOrEmpty.nullOrEmpty((Object[])segments) && segments.length > 1) {
                    Object applicationId = segments[0];
                    Object sessionId = segments[1];
                    String user = this.verify(requestPrincipal, (String)applicationId, (String)sessionId, hdrs);
                    String[] roles = EMPTY;
                    if (user != null) {
                        roles = this.roles(requestPrincipal, user);
                        return this.authorize(callbackHandler, user, roles);
                    }
                }
                return AuthenticationResult.notAuthorized((AuthenticationChallenge)Challenges.NO_CHALLENGE);
            }
        }
        return AuthenticationResult.unknown();
    }

    private String cookies(Iterable<String> cookies) {
        if (NullOrEmpty.nullOrEmpty(cookies)) {
            return null;
        }
        return Iterables.join(cookies, (String)"; ");
    }

    private OWA.Headers getHeaders(MultiAssociativeArray<String, String> hdrs) {
        OWA.Headers _header = new OWA.Headers();
        for (String name : hdrs) {
            for (String value : hdrs.values((Object)name)) {
                _header.addHeader(name, value);
            }
        }
        _header.addHeader("APEX_LISTENER_VERSION", Version.INSTANCE.getVersion());
        _header.addHeader("DOC_ACCESS_PATH", "");
        _header.addHeader("DOCUMENT_TABLE", "");
        _header.addHeader("GATEWAY_IVERSION", "3");
        _header.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        _header.addHeader("PATH_INFO", "wwv_flow_listener");
        _header.addHeader("HTTP_HOST", "localhost");
        _header.addHeader("REMOTE_ADDR", "localhost");
        _header.addHeader("REMOTE_USER", null);
        _header.addHeader("HTTP_USER_AGENT", "Apex Listener");
        _header.addHeader("HTTP_COOKIE", this.cookies(hdrs.values((Object)HttpHeader.COOKIE)));
        _header.addHeader("HTTP_ACCEPT", this.value(hdrs, "accept"));
        _header.addHeader("HTTP_ACCEPT_ENCODING", this.value(hdrs, "accept-encoding"));
        _header.addHeader("HTTP_ACCEPT_LANGUAGE", this.value(hdrs, "accept-language"));
        _header.addHeader("HTTP_ACCEPT_CHARSET", this.value(hdrs, "accept-charset"));
        _header.addHeader("HTTP_IF_MODIFIED_SINCE", null);
        _header.addHeader("HTTP_IF_NONE_MATCH", null);
        _header.addHeader("PLSQL_GATEWAY", "WebDb");
        _header.addHeader("QUERY_STRING", null);
        _header.addHeader("REQUEST_CHARSET", "AL32UTF8");
        _header.addHeader("REQUEST_IANA_CHARSET", Text.defaultEncoding());
        return _header;
    }

    /*
     * Exception decompiling
     */
    private String[] roles(CompoundPrincipal requestPrincipal, String user) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String value(MultiAssociativeArray<String, String> headers, String name) {
        return (String)headers.get((Object)name);
    }

    /*
     * Exception decompiling
     */
    private String verify(CompoundPrincipal requestPrincipal, String applicationId, String sessionId, OWA.Headers hdrs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static JDBCCallProvider jdbc() {
        return (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
    }

    private static JDBCPrincipal jdbcPrincipal(CompoundPrincipal principal) {
        JDBCCallProvider jdbc = (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
        if (principal == null) {
            return null;
        }
        JDBCPrincipal existing = (JDBCPrincipal)principal.principal(JDBCPrincipal.class);
        if (existing == null) {
            existing = jdbc.principal(null);
        }
        return existing;
    }
}

