/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tree;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.ide.controls.JLabeledRadioButton;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.controls.tree.TreeCellRadioSelectedEvent;
import oracle.ide.controls.tree.TreeCellRadioSelectedListener;
import oracle.ide.util.TriStateBoolean;

class JTreeListener
implements MouseListener,
MouseMotionListener,
TreeWillExpandListener {
    private final EventListenerList _listenerList = new EventListenerList();
    private boolean _isArmed = false;
    private long _pressedTime = -1L;
    private int _pressedRow = -1;
    private int _checkOrRadioWidth = -1;
    private boolean _trackingMousePress = false;
    private boolean _trackingKeyPress = false;
    private static final int BOUNCE_TIME = 150;
    private boolean _propagateCheckState = true;

    JTreeListener() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this._trackingKeyPress) {
            if (SwingUtilities.isRightMouseButton(e) || SwingUtilities.isMiddleMouseButton(e)) {
                this.mouseReleased(e);
            }
            JTree tree = (JTree)e.getComponent();
            this.releaseRow(tree, -1, System.currentTimeMillis());
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this._pressedTime = e.getWhen();
        JTree tree = (JTree)e.getComponent();
        this.pressRow(tree, this.getCurrentRow(e));
        if (this._pressedRow >= 0) {
            this._trackingMousePress = true;
            tree.addMouseMotionListener(this);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._trackingKeyPress) {
            JTree tree = (JTree)e.getComponent();
            this.releaseRow(tree, -1, System.currentTimeMillis());
            return;
        }
        long releasedTime = e.getWhen();
        JTree tree = (JTree)e.getComponent();
        this.releaseRow(tree, this.getCurrentRow(e), releasedTime);
        this._trackingMousePress = false;
        tree.removeMouseMotionListener(this);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._pressedRow == -1) {
            return;
        }
        int currentRow = this.getCurrentRow(e);
        if (currentRow != this._pressedRow && this._isArmed || currentRow == this._pressedRow && !this._isArmed) {
            JTree tree = (JTree)e.getComponent();
            TreePath selPath = tree.getPathForRow(this._pressedRow);
            JMutableTreeNode treeNode = (JMutableTreeNode)selPath.getLastPathComponent();
            JTreeCellData treeCellData = treeNode.getModel();
            this._isArmed = currentRow == this._pressedRow;
            treeCellData.setArmed(this._isArmed);
            Rectangle r = tree.getRowBounds(this._pressedRow);
            tree.repaint(r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        CustomJTree tree = (CustomJTree)e.getSource();
        MouseEvent mouseEvent = tree._currentMouseEvent;
        if (mouseEvent == null || this.getCurrentRow(mouseEvent) < 0) {
            return;
        }
        throw new ExpandVetoException(e);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
        this.treeWillExpand(e);
    }

    void addTreeCellCheckedListener(TreeCellCheckedListener l) {
        this._listenerList.add(TreeCellCheckedListener.class, l);
    }

    void removeTreeCellCheckedListener(TreeCellCheckedListener l) {
        this._listenerList.remove(TreeCellCheckedListener.class, l);
    }

    void addTreeCellRadioSelectedListener(TreeCellRadioSelectedListener l) {
        this._listenerList.add(TreeCellRadioSelectedListener.class, l);
    }

    void removeTreeCellRadioSelectedListener(TreeCellRadioSelectedListener l) {
        this._listenerList.remove(TreeCellRadioSelectedListener.class, l);
    }

    void fireCellChecked(JMutableTreeNode cell) {
        Object[] listeners = this._listenerList.getListenerList();
        TreeCellCheckedEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeCellCheckedListener.class || e != null) continue;
            e = new TreeCellCheckedEvent(cell);
            ((TreeCellCheckedListener)listeners[i + 1]).cellChecked(e);
        }
    }

    void fireCellUnchecked(JMutableTreeNode cell) {
        Object[] listeners = this._listenerList.getListenerList();
        TreeCellCheckedEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeCellCheckedListener.class || e != null) continue;
            e = new TreeCellCheckedEvent(cell);
            ((TreeCellCheckedListener)listeners[i + 1]).cellUnchecked(e);
        }
    }

    void fireRadioSelected(JMutableTreeNode cell) {
        if (cell == null) {
            return;
        }
        Object[] listeners = this._listenerList.getListenerList();
        TreeCellRadioSelectedEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeCellRadioSelectedListener.class || e != null) continue;
            e = new TreeCellRadioSelectedEvent(cell);
            ((TreeCellRadioSelectedListener)listeners[i + 1]).cellSelected(e);
        }
    }

    void fireRadioUnselected(JMutableTreeNode cell) {
        if (cell == null) {
            return;
        }
        Object[] listeners = this._listenerList.getListenerList();
        TreeCellRadioSelectedEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeCellRadioSelectedListener.class || e != null) continue;
            e = new TreeCellRadioSelectedEvent(cell);
            ((TreeCellRadioSelectedListener)listeners[i + 1]).cellUnselected(e);
        }
    }

    void keyPressRow(JTree tree, int row) {
        if (this._trackingMousePress || this._trackingKeyPress) {
            this.releaseRow(tree, -1, System.currentTimeMillis());
            return;
        }
        this._trackingKeyPress = true;
        this.pressRow(tree, row);
    }

    void keyReleaseRow(JTree tree, int row) {
        if (this._trackingMousePress || !this._trackingKeyPress) {
            this.releaseRow(tree, -1, System.currentTimeMillis());
            return;
        }
        this._trackingKeyPress = false;
        this.releaseRow(tree, row, 0L);
    }

    boolean isPropagateCheckState() {
        return this._propagateCheckState;
    }

    void setPropagateCheckState(boolean propagate) {
        this._propagateCheckState = propagate;
    }

    private void pressRow(JTree tree, int row) {
        if (row < 0) {
            this._pressedRow = -1;
            return;
        }
        if (this._pressedRow >= 0) {
            throw new IllegalStateException("Can't invoke pressRow() when a different row is already being pressed");
        }
        TreePath selPath = tree.getPathForRow(row);
        JMutableTreeNode treeNode = (JMutableTreeNode)selPath.getLastPathComponent();
        JTreeCellData treeCellData = treeNode.getModel();
        boolean hasCheckBox = treeCellData.getHasCheckBox();
        boolean isCheckBoxSelectable = treeCellData.isCheckBoxSelectable();
        boolean hasRadioButton = treeCellData.getHasRadioButton();
        boolean isRadioButtonEnabled = treeCellData.isRadioButtonEnabled();
        boolean isInternalRadioEnabled = treeCellData.isInternalRadioEnabled();
        if (!(hasCheckBox && isCheckBoxSelectable || hasRadioButton && isRadioButtonEnabled && isInternalRadioEnabled)) {
            this._pressedRow = -1;
            return;
        }
        this._isArmed = true;
        treeCellData.setArmed(true);
        treeCellData.setPressed(true);
        tree.addSelectionRow(row);
        this._pressedRow = row;
        Rectangle r = tree.getRowBounds(this._pressedRow);
        tree.repaint(r.x, r.y, r.width, r.height);
    }

    private void releaseRow(JTree tree, int row, long releasedTime) {
        this._checkOrRadioWidth = -1;
        this._isArmed = false;
        if (this._pressedRow < 0) {
            this._pressedTime = -1L;
            return;
        }
        long diffTime = releasedTime > 0L ? releasedTime - this._pressedTime : 0L;
        TreePath pressedPath = tree.getPathForRow(this._pressedRow);
        JMutableTreeNode pressedNode = (JMutableTreeNode)pressedPath.getLastPathComponent();
        JTreeCellData pressedData = pressedNode.getModel();
        pressedData.setPressed(false);
        pressedData.setArmed(false);
        if (row >= 0 && (this._pressedRow == row || diffTime <= 150L)) {
            if (pressedData.getHasCheckBox()) {
                TriStateBoolean checkBoxState = pressedData.getCheckBoxState();
                TriStateBoolean newCheckBoxState = checkBoxState.toggle();
                pressedData.setCheckBoxState(newCheckBoxState);
                boolean booleanValue = newCheckBoxState.booleanValue();
                if (this.isPropagateCheckState()) {
                    pressedNode.selectDescendants(booleanValue);
                }
                if (booleanValue) {
                    this.fireCellChecked(pressedNode);
                } else {
                    this.fireCellUnchecked(pressedNode);
                }
                if (this.isPropagateCheckState()) {
                    pressedNode.updateNodes();
                }
            } else if (pressedData.getHasRadioButton() && !pressedData.isRadioButtonSelected() && pressedData.isRadioButtonEnabled()) {
                JMutableTreeNode unselectedNode = pressedNode.unselectSibling();
                this.fireRadioUnselected(unselectedNode);
                pressedData.setRadioButtonSelected(true);
                this.fireRadioSelected(pressedNode);
            }
        }
        tree.repaint();
        this._pressedRow = -1;
    }

    private int getCurrentRow(MouseEvent e) {
        int y;
        int x;
        JTree tree = (JTree)e.getComponent();
        int row = tree.getRowForLocation(x = e.getX(), y = e.getY());
        if (row < 0) {
            return -1;
        }
        if (this._checkOrRadioWidth < 0) {
            TreePath path = tree.getPathForRow(row);
            Object lastPath = path.getLastPathComponent();
            TreeCellRenderer tcr = tree.getCellRenderer();
            Component component = tcr.getTreeCellRendererComponent(tree, lastPath, tree.isRowSelected(row), tree.isExpanded(row), tree.getModel().isLeaf(lastPath), row, true);
            this._checkOrRadioWidth = component instanceof JLabeledCheckBox ? ((JLabeledCheckBox)component).checkBox.getWidth() : (component instanceof JLabeledRadioButton ? ((JLabeledRadioButton)component).radioButton.getWidth() : 0);
        }
        Rectangle rowBounds = tree.getRowBounds(row);
        if (x > rowBounds.x + this._checkOrRadioWidth) {
            return -1;
        }
        return row;
    }
}

