/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;

class GITRemoteBranchThread
extends Thread {
    private GitClient _client;
    private String _remoteUrl;
    Map<String, GitBranch> _branches = new HashMap<String, GitBranch>();
    private GitException _exception;
    private boolean _cancel = false;
    private IndeterminateProgressMonitor _progress;

    GITRemoteBranchThread(GitClient client, String remoteUrl, IndeterminateProgressMonitor progress) {
        super("git-remote-branches");
        this._client = client;
        this._remoteUrl = remoteUrl;
        this._progress = progress;
    }

    public boolean isCancel() {
        return this._cancel;
    }

    public GitException getError() {
        return this._exception;
    }

    public Map<String, GitBranch> getBranches() {
        return this._branches;
    }

    @Override
    public void run() {
        try {
            GITCommandProgressMonitor monitor = this.getMonitor();
            this.getRemoteBranches(monitor);
        }
        catch (GitException.AuthorizationException e) {
            this._exception = e;
        }
        catch (GitException e) {
            this._exception = e;
        }
        finally {
            this._progress.finish();
        }
    }

    protected boolean getRemoteBranches(GITCommandProgressMonitor monitor) throws GitException, GitException.AuthorizationException {
        monitor.setOperation("listRemoteBranches");
        this._branches.putAll(this._client.listRemoteBranches(this._remoteUrl, (ProgressMonitor)monitor));
        return true;
    }

    protected void setError(GitException e) {
        this._exception = e;
    }

    protected IndeterminateProgressMonitor getProgress() {
        return this._progress;
    }

    protected GITCommandProgressMonitor getMonitor() {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("");
        VCSCancellable cancellable = new VCSCancellable(){

            public boolean isCancelled() {
                GITRemoteBranchThread.this._cancel = true;
                return GITRemoteBranchThread.this._progress.isCanceled();
            }
        };
        monitor.setCancellable(cancellable);
        return monitor;
    }

    protected GitClient getClient() {
        return this._client;
    }

    protected String getRemoteUrl() {
        return this._remoteUrl;
    }
}

