/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITBranchRevisionPanel;

public class GITCreateBranchPanel
extends JPanel {
    private static final String F1_HELP_ID = "f1_git_create_branch_html";
    private JLabel _lblName = new JLabel();
    private JTextField _fldName = new JTextField();
    private JCheckBox _chbCreate = new JCheckBox();
    private GITBranchRevisionPanel _panel = new GITBranchRevisionPanel();

    public GITCreateBranchPanel() {
        this.init();
        this.initLayout();
        this.addListener();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, F1_HELP_ID);
    }

    public Component getDefaultComp() {
        return this._fldName;
    }

    public String getBranchName() {
        return this._fldName.getText();
    }

    public boolean checkoutBranch() {
        return this._chbCreate.isSelected();
    }

    public void setRoot(URL root) {
        this._panel.setRepositoryRoot(root);
    }

    public void setRevisionBranch(String branch) {
        this._panel.setSelectedBranch(branch);
    }

    public String getRevisionBranch() {
        return this._panel.getSelectedBranch();
    }

    public void setRevisionTag(String tag) {
        this._panel.setSelectedTag(tag);
    }

    public String getRevisionTag() {
        return this._panel.getSelectedTag();
    }

    public String getRevision() {
        return this._panel.getSelectedRevision();
    }

    private void init() {
        ResourceUtils.resLabel((JLabel)this._lblName, (Component)this._fldName, (String)Resource.get("CREATEBRANCH_NAME"));
        ResourceUtils.resButton((AbstractButton)this._chbCreate, (String)Resource.get("CREATE_BRANCH_CHECKOUT"));
        this._chbCreate.setEnabled(false);
    }

    private void initLayout() {
        Insets ins = new Insets(5, 5, 0, 5);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this._fldName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 18, 5, 0), 0, 0));
        this.add((Component)this._panel, new GridBagConstraints(0, 1, 2, 2, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.add((Component)this._chbCreate, new GridBagConstraints(0, 3, 2, 2, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addListener() {
        this._fldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GITCreateBranchPanel.this._chbCreate.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (e.getDocument().getLength() == 0) {
                    GITCreateBranchPanel.this._chbCreate.setEnabled(false);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }
}

