/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.commithistory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITCommitVersionCompare
extends VCSCommand {
    public static String COMMAND_ID = "oracle.jdeveloper.vcs.git.commitversioncompare";

    public GITCommitVersionCompare() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    protected int doitImpl() throws Exception {
        String filepath = (String)this.getContext().getProperty("commit-version-file-path");
        String commitid = (String)this.getContext().getProperty("commit-version-id");
        URL root = (URL)this.getContext().getProperty("commit-git-root");
        String title = Resource.get("COMMIT_HISTORY_NO_FILE");
        if (filepath != null) {
            GitClient client = null;
            try {
                URL url = URLFactory.newURL((URL)root, (String)filepath);
                String type = GITUtil.getSuffixAsType(url);
                String charsetName = StreamDecoder.getDefaultEncoding((URL)url);
                File file = new File(url.getPath());
                client = GITClientAdaptor.getClient(url);
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("catFile");
                ByteArrayOutputStream commitOS = new ByteArrayOutputStream();
                client.catFile(file, commitid, (OutputStream)commitOS, (ProgressMonitor)monitor);
                Pair<String, File> previous = this.getPreviousCommitId(client, file, commitid, monitor);
                ByteArrayOutputStream previousOS = new ByteArrayOutputStream();
                if (previous != null) {
                    client.catFile((File)previous.getSecond(), (String)previous.getFirst(), (OutputStream)previousOS, (ProgressMonitor)monitor);
                    title = GITUtil.shortCommitId((String)previous.getFirst()) + " " + ((File)previous.getSecond()).getName();
                }
                InputStreamTextContributor prvContrib = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(previousOS.toByteArray()), charsetName, title, title, type);
                title = GITUtil.shortCommitId(commitid) + " " + file.getName();
                InputStreamTextContributor commitContrib = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(commitOS.toByteArray()), charsetName, title, title, type);
                CompareIdeViewer.getCompareIdeViewer().show((CompareContributor)prvContrib, (CompareContributor)commitContrib, (Element)new CommitNode(url));
            }
            catch (GitException ex) {
                throw new GITProcessException(Resource.format("ERROR_COMMIT_COMPARE", filepath), (Exception)((Object)ex));
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
            return 0;
        }
        return 1;
    }

    private Pair<String, File> getPreviousCommitId(GitClient client, File file, String commitId, GITCommandProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        SearchCriteria sc = new SearchCriteria();
        sc.setRevisionTo(commitId);
        sc.setFiles(new File[]{file});
        sc.setFollowRenames(true);
        sc.setLimit(2);
        GitRevisionInfo[] info = client.log(sc, (ProgressMonitor)monitor);
        if (info.length != 2) {
            return null;
        }
        Map files = info[0].getModifiedFiles();
        GitRevisionInfo.GitFileInfo fileInfo = (GitRevisionInfo.GitFileInfo)files.get(file);
        return new Pair((Object)info[1].getRevision(), (Object)(fileInfo.getOriginalFile() != null ? fileInfo.getOriginalFile() : file));
    }

    private static class CommitNode
    implements Element,
    Locatable {
        private URL _url;

        private CommitNode(URL url) {
            this._url = url;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return null;
        }

        public Object getData() {
            return null;
        }

        public String getShortLabel() {
            return URLFileSystem.getName((URL)this._url);
        }

        public String getLongLabel() {
            return URLFileSystem.getPlatformPathName((URL)this._url);
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return null;
        }

        public URL getURL() {
            return this._url;
        }

        public void setURL(URL url) {
            this._url = url;
        }
    }
}

