/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITAbstractOperation;
import oracle.jdevimpl.vcs.git.nav.GITBranchNode;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.nav.GITTagNode;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITCreateBranchPanel;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationCreateBranch
extends GITAbstractOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.createbranch";

    public GITOperationCreateBranch() {
        super(COMMAND_ID, VCSCommandStyle.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doitImpl(final VCSProfile profile) throws Exception {
        Node node = this.getContext().getNode();
        final GITCreateBranchPanel panel = new GITCreateBranchPanel();
        URL r = null;
        if (node instanceof GITBranchNode || node instanceof GITTagNode) {
            r = GITUtil.getRootContaining(GITNavURLFileSystemHelper.fromNavigatorURL(node.getURL()));
            if (node instanceof GITBranchNode) {
                panel.setRevisionBranch(node.getShortLabel());
            } else if (node instanceof GITTagNode) {
                panel.setRevisionTag(node.getShortLabel());
            }
        } else {
            r = this.getGitClientRoot(profile);
            panel.setRevisionBranch(this.getCurrentBranch(r));
        }
        final URL root = r;
        panel.setRoot(root);
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getDefaultComp(), (String)this.getDialogTitle(), (int)7);
        dialog.setMinimumSize(550, 200);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("CREATEBRANCH_DIALOG_HINT"));
        dialog.setDialogHeader((Component)header);
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    return;
                }
                GITOperationCreateBranch.this.validateDialog(evt, panel, root);
                try {
                    GITOperationCreateBranch.this.createBranch(root, panel);
                }
                catch (GITProcessException e) {
                    GITOperationCreateBranch.this.getExceptionHandler().handleException((Exception)((Object)e));
                    throw new PropertyVetoException(e.getMessage(), evt);
                }
            }
        });
        try {
            if (dialog.runDialog()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GITRepositoryNavigator.getInstance().updateNavigator(root, false);
                        profile.getStatusCacheBridge().clear();
                    }
                });
                int n = 0;
                return n;
            }
        }
        finally {
            dialog.dispose();
        }
        return 1;
    }

    private void validateDialog(PropertyChangeEvent evt, GITCreateBranchPanel panel, URL url) throws PropertyVetoException {
        String name = panel.getBranchName();
        if (name == null || name.isEmpty()) {
            MessageDialog.error((Component)panel, (Object)Resource.get("CREATEBRANCH_NO_NAME"), (String)Resource.get("CREATEBR_TITLE"), null);
            throw new PropertyVetoException(Resource.get("CREATEBRANCH_NO_NAME"), evt);
        }
        String branch = panel.getRevisionBranch();
        if (branch != null && !GITUtil.getBranches(url).containsKey(branch)) {
            MessageDialog.error((Component)panel, (Object)Resource.format("ERROR_BRANCH_NOT_EXIST", branch), (String)Resource.get("CREATEBR_TITLE"), null);
            throw new PropertyVetoException(Resource.format("ERROR_BRANCH_NOT_EXIST", branch), evt);
        }
        Map<String, GitTag> tags = GITUtil.getTags(url);
        String useTag = panel.getRevisionTag();
        if (useTag != null && !useTag.isEmpty() && !tags.containsKey(useTag)) {
            MessageDialog.error((Component)panel, (Object)Resource.format("ERROR_TAG_NOT_EXIST", useTag), (String)Resource.get("TAGERROR_TITLE"), null);
            throw new PropertyVetoException(Resource.format("ERROR_TAG_NOT_EXIST", panel.getName()), evt);
        }
        try {
            if (this.branchExist(url, name)) {
                MessageDialog.error((Component)panel, (Object)Resource.format("CREATEBRANCH_EXIST", name), (String)Resource.get("CREATEBR_TITLE"), null);
                throw new PropertyVetoException(Resource.format("CREATEBRANCH_EXIST", name), evt);
            }
        }
        catch (GITProcessException e) {
            this.getExceptionHandler().handleException((Exception)((Object)e));
            throw new PropertyVetoException(e.getMessage(), evt);
        }
    }

    private boolean createBranch(URL root, GITCreateBranchPanel panel) throws GITProcessException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("CREATE_BRANCH_OPERATION"));
        GitClient client = null;
        monitor.setLog(true);
        try {
            client = GITClientAdaptor.getClient(root);
            GitBranch gBranch = client.createBranch(panel.getBranchName(), panel.getRevision(), (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.format("CHECKOUT_CREATE_BRANCH_FAILED", panel.getBranchName()), monitor.getError());
            }
            if (panel.checkoutBranch()) {
                client.checkoutRevision(panel.getBranchName(), true, (ProgressMonitor)monitor);
            }
            boolean bl = true;
            return bl;
        }
        catch (GitException e) {
            throw new GITProcessException(Resource.format("CHECKOUT_CREATE_BRANCH_FAILED", panel.getBranchName()), e.getCause().getMessage());
        }
        finally {
            monitor.logCompleted();
            if (client != null) {
                client.release();
            }
        }
    }

    private boolean branchExist(URL url, String branch) throws GITProcessException {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
            monitor.setLog(false);
            Map branches = client.getBranches(true, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_BRANCH_ERROR"), monitor.getError());
            }
            boolean bl = branches.containsKey(branch);
            return bl;
        }
        catch (GitException e) {
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_BRANCH_ERROR"), e.getCause().getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }
}

