/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.mysql5;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdEnumColumn;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSetColumn;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.mysql3.MySQLColumnHelper;
import oracle.dbtools.migration.workbench.mysql3.MySQLOfflineUtils;
import oracle.dbtools.migration.workbench.mysql4.MySQL4OfflineCapturer;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MySQL5OfflineCapturer
extends MySQL4OfflineCapturer {
    private XMLDocument _xmlDocument;
    private Node _rootNode;
    private ArrayList<String> m_dblist = null;

    @Override
    public String captureInitializeImpl(String string, Properties properties) throws OfflineCaptureException {
        this.m_inputDirectory = string;
        this.m_properties = properties;
        try {
            String string2 = string.concat(File.separator).concat(properties.getProperty("alldbsfile").trim());
            FileInputStream fileInputStream = new FileInputStream(new File(string2));
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            String string3 = this.getEncoding();
            if (string3 == null) {
                dOMParser.parse((InputStream)fileInputStream);
            } else {
                dOMParser.parse((Reader)new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string3)));
            }
            this._xmlDocument = dOMParser.getDocument();
            this._rootNode = this._xmlDocument.getElementsByTagName("mysqldump").item(0);
            this.m_dblist = this.getSelectedDatabaseList();
            for (String string4 : this.m_dblist) {
                this.addDatabaseToCapture(string4);
            }
        }
        catch (Exception exception) {
            throw new OfflineCaptureException(exception);
        }
        return "MySQLOffline5";
    }

    @Override
    public void captureStarting() {
        this.m_dbName = this.getNextDatabase();
    }

    @Override
    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        if (string.equals("MD_SCHEMAS")) {
            NodeList nodeList = this._rootNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                this.captureDatabase(node, captureContext);
            }
            this.captureConstraints(captureContext);
            this.captureStoredPrograms(captureContext);
            this.captureView(captureContext);
        } else {
            super.captureObjects(string, captureContext, migrationObjectFilter);
        }
    }

    private void captureDatabase(Node node, CaptureContext captureContext) {
        if (node.getNodeName().equals("database")) {
            this.captureSchema(captureContext, node);
        }
    }

    private void captureSchema(CaptureContext captureContext, Node node) {
        try {
            String string = XMLHelper.getAttributeNode((Node)node, (String)"name");
            if (this.m_dbName.equals(string)) {
                CaptureAudience captureAudience = captureContext.getAudience();
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CATALOGID");
                MdSchema mdSchema = new MdSchema(dBObjectId);
                mdSchema.setName(string);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_SCHEMAS"), mdSchema.getName());
                captureAudience.fireListeners(captureEvent);
                mdSchema = (MdSchema)this.getStorer().storeObject((PersistableObject)mdSchema);
                captureEvent.setEventId(4);
                captureAudience.fireListeners(captureEvent);
                captureContext.setContextVariable("SCHEMAID", (Object)mdSchema.getKey());
                XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"table_structure");
                for (int i = 0; i < xMLNodeArray.length; ++i) {
                    this.captureTable((Node)xMLNodeArray[i], captureContext, mdSchema);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureTable(Node node, CaptureContext captureContext, MdSchema mdSchema) {
        try {
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            String string = XMLHelper.getAttributeNode((Node)node, (String)"name");
            Node node2 = XMLHelper.getChildNode((Node)node, (String)"options");
            String string2 = XMLHelper.getAttributeNode((Node)node2, (String)"Comment");
            if (!string2.equalsIgnoreCase("View")) {
                String string3 = "";
                MdCatalog mdCatalog = (MdCatalog)captureContext.getContextVariable("CATALOG");
                if (mdCatalog != null && !mdCatalog.getDummyFlag().equals("Y")) {
                    string3 = mdCatalog.getCatalogName() + ".";
                }
                String string4 = mdSchema.getName();
                string3 = string3 + string4 + ".";
                string3 = string3 + string;
                MdTable mdTable = new MdTable(dBObjectId, string, string3);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TABLES"), mdTable.getTableName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdTable = (MdTable)this.getStorer().storeObject((PersistableObject)mdTable);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"field");
                for (int i = 0; i < xMLNodeArray.length; ++i) {
                    this.captureColumnDetails(captureContext, mdTable, (Node)xMLNodeArray[i], mdSchema, i + 1);
                }
                this.captureIndexes(captureContext, mdTable, node);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureColumnDetails(CaptureContext captureContext, MdTable mdTable, Node node, MdSchema mdSchema, int n) {
        Object object = null;
        try {
            Object object2;
            String string;
            DBObjectId dBObjectId = mdTable.getKey();
            DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            boolean bl = false;
            String string2 = XMLHelper.getAttributeNode((Node)node, (String)"Field");
            String string3 = "`" + mdSchema.getObjectName() + "`.`" + mdTable.getObjectName() + "`.`" + string2 + "`";
            String[] stringArray = null;
            String string4 = XMLHelper.getAttributeNode((Node)node, (String)"Type");
            MySQLColumnHelper mySQLColumnHelper = new MySQLColumnHelper(string4);
            String string5 = mySQLColumnHelper.getDataTypeName();
            if ((string5.equals("ENUM") || string5.equals("SET")) && (stringArray = this.getAllValues(string4)) != null) {
                object = string5.equals("ENUM") ? new MdEnumColumn(dBObjectId, string2, Integer.valueOf(n), stringArray, dBObjectId2) : new MdSetColumn(dBObjectId, string2, Integer.valueOf(n), stringArray, dBObjectId2);
                bl = true;
            }
            if ((string = XMLHelper.getAttributeNode((Node)node, (String)"Extra")).equals("auto_increment") && this.m_getMaxOfColumn.containsKey(string3) && !bl) {
                object2 = (Integer)this.m_getMaxOfColumn.get(string3);
                object = new MdIdentityColumn(dBObjectId, string2, Integer.valueOf(n), 0L, 1L, (long)((Integer)object2).intValue(), dBObjectId2);
                bl = true;
            }
            if (!bl) {
                object = new MdColumn(dBObjectId, string2, Integer.valueOf(n));
            }
            if (string != null && string.trim().length() > 0) {
                object.addProperty(new AdditionalProperty("EXTRA", string), dBObjectId2);
            }
            object.setColumnType(string5);
            object.setPrecision(Integer.valueOf(mySQLColumnHelper.getPrecision()));
            if (mySQLColumnHelper.hasPrecisionAndScale()) {
                object.setScale(Integer.valueOf(mySQLColumnHelper.getScale()));
            }
            if (((String)(object2 = XMLHelper.getAttributeNode((Node)node, (String)"Null"))).equalsIgnoreCase("YES")) {
                object.setNullable("Y");
            } else {
                object.setNullable("N");
            }
            String string6 = XMLHelper.getAttributeNode((Node)node, (String)"Key");
            if (string6.equals("PRI")) {
                // empty if block
            }
            String string7 = XMLHelper.getAttributeNode((Node)node, (String)"Default");
            object.setDefaultValue(string7);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_COLUMNS"), object.getColumnName());
            captureContext.getAudience().fireListeners(captureEvent);
            object = (MdColumn)this.getStorer().storeObject((PersistableObject)object);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureIndexes(CaptureContext captureContext, MdTable mdTable, Node node) {
        try {
            String string = "";
            String string2 = "";
            XMLNode[] xMLNodeArray = XMLHelper.getChildNodes((Node)node, (String)"key");
            MdIndexe mdIndexe = null;
            MdConstraint mdConstraint = null;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                String string3 = XMLHelper.getAttributeNode((Node)xMLNodeArray[i], (String)"Key_name");
                string2 = XMLHelper.getAttributeNode((Node)xMLNodeArray[i], (String)"Column_name");
                String string4 = XMLHelper.getAttributeNode((Node)xMLNodeArray[i], (String)"Index_type");
                String string5 = XMLHelper.getAttributeNode((Node)xMLNodeArray[i], (String)"Non_unique");
                if (!string.equalsIgnoreCase(string3)) {
                    Node node2 = xMLNodeArray[i].getParentNode();
                    XMLNode[] xMLNodeArray2 = XMLHelper.getChildNodes((Node)node2, (String)"field");
                    String[] stringArray = new String[xMLNodeArray2.length];
                    String[] stringArray2 = new String[xMLNodeArray2.length];
                    for (int j = 0; j < xMLNodeArray2.length; ++j) {
                        stringArray[j] = XMLHelper.getAttributeNode((Node)xMLNodeArray2[j], (String)"Field");
                        stringArray2[j] = XMLHelper.getAttributeNode((Node)xMLNodeArray2[j], (String)"Key");
                    }
                    String string6 = "";
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!stringArray[j].equals(string2)) continue;
                        string6 = stringArray2[j];
                    }
                    if (string6.startsWith("PRI") && string5.equals("0") && string3.equals("PRIMARY")) {
                        bl = false;
                        bl2 = true;
                        mdConstraint = new MdConstraint(mdTable.getKey(), "MySQL");
                        mdConstraint.setName(string3);
                        mdConstraint.setConstraintType("PK");
                        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), string3);
                        captureContext.getAudience().fireListeners(captureEvent);
                        mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                        captureEvent.setEventId(4);
                        captureContext.getAudience().fireListeners(captureEvent);
                        string = mdConstraint.getObjectName();
                    } else {
                        if (string6.startsWith("UNI")) continue;
                        bl = true;
                        bl2 = false;
                        mdIndexe = new MdIndexe(mdTable.getKey());
                        mdIndexe.setIndexName(string3);
                        mdIndexe.setIndexType("NON_UNIQUE");
                        if (string4 != null && string4.trim().length() > 0) {
                            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
                            mdIndexe.addProperty(new AdditionalProperty("INDEX_TYPE", string4), dBObjectId);
                        }
                        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), mdIndexe.getIndexName());
                        captureContext.getAudience().fireListeners(captureEvent);
                        mdIndexe = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe);
                        captureEvent.setEventId(4);
                        captureContext.getAudience().fireListeners(captureEvent);
                        string = mdIndexe.getIndexName();
                    }
                }
                if (bl && !bl2) {
                    this.captureIndexDetails(captureContext, (Node)xMLNodeArray[i], mdIndexe, string2);
                    continue;
                }
                if (bl || !bl2) continue;
                this.captureConstraintIndexDetails(captureContext, (Node)xMLNodeArray[i], mdConstraint, string2);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureConstraintIndexDetails(CaptureContext captureContext, Node node, MdConstraint mdConstraint, String string) {
        try {
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            String string2 = XMLHelper.getAttributeNode((Node)node, (String)"Seq_in_index");
            MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), new Integer(string2));
            mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string));
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getObjectName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureIndexDetails(CaptureContext captureContext, Node node, MdIndexe mdIndexe, String string) {
        try {
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            String string2 = XMLHelper.getAttributeNode((Node)node, (String)"Seq_in_index");
            MdIndexDetail mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), persistenceUtility.getIdForColumn(mdIndexe.getTableId(), string), new Integer(string2));
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), mdIndexe.getIndexName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdIndexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)mdIndexDetail);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void captureView(CaptureContext captureContext) throws PersistenceException {
        String string = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("views_info"));
        Object[] objectArray = MySQLOfflineUtils.getViews(string).toArray();
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CATALOGID");
        DBObjectId dBObjectId2 = null;
        for (int i = 0; i < objectArray.length / 4; ++i) {
            String string2;
            MdSchema mdSchema;
            CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId(dBObjectId);
            while (closeableIterator.hasNext()) {
                mdSchema = (MdSchema)closeableIterator.next();
                string2 = mdSchema.getName();
                if (!string2.equals(objectArray[i * 4])) continue;
                dBObjectId2 = mdSchema.getKey();
                break;
            }
            if (dBObjectId2 == null) continue;
            mdSchema = new MdView(dBObjectId2, "MySQL");
            string2 = (String)objectArray[i * 4 + 1];
            mdSchema.setViewName(string2);
            mdSchema.setNativeSql(this.putInViewPrefix((String)objectArray[i * 4 + 2], string2));
            mdSchema.setCreatedBy((String)objectArray[i * 4 + 3]);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_VIEWS"), mdSchema.getViewName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdSchema = (MdView)this.getStorer().storeObject((PersistableObject)mdSchema);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
    }

    protected void captureStoredPrograms(CaptureContext captureContext) throws PersistenceException {
        String string = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("routines_info"));
        HashMap<String, String> hashMap = MySQLOfflineUtils.getRoutines(string);
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CATALOGID");
        DBObjectId dBObjectId2 = null;
        Set<String> set = hashMap.keySet();
        for (String string2 : set) {
            MdSchema mdSchema;
            String string3;
            String string4 = hashMap.get(string2);
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreElements()) {
                string3 = stringTokenizer.nextToken().trim();
                if (string3.startsWith("SCHEMA")) {
                    string5 = string3.substring(string3.indexOf("=") + 2, string3.length() - 1);
                }
                if (string3.startsWith("DEFINER")) {
                    string8 = string3.substring(string3.indexOf("=") + 1, string3.length());
                }
                if (string3.startsWith("ROUTINE_NAME")) {
                    string6 = string3.substring(string3.indexOf("=") + 1, string3.length());
                }
                if (!string3.startsWith("ROUTINE_TYPE")) continue;
                string7 = string3.substring(string3.indexOf("=") + 1, string3.length());
            }
            string3 = persistenceUtility.getSchemasforCatalogId(dBObjectId);
            while (string3.hasNext()) {
                mdSchema = (MdSchema)string3.next();
                if (!mdSchema.getName().equals(string5)) continue;
                dBObjectId2 = mdSchema.getKey();
                break;
            }
            if (dBObjectId2 == null) continue;
            mdSchema = new MdStoredProgram(dBObjectId2, "MySQL");
            mdSchema.setName(string6);
            mdSchema.setProgramtype(string7);
            mdSchema.setNativeSql(string4);
            mdSchema.setCreatedBy(string8);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_STORED_PROGRAMS"), mdSchema.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdSchema = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)mdSchema);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
    }

    @Override
    public String getModelName() throws CaptureException {
        return "MySQL5";
    }

    @Override
    public String[] getScriptFiles(int n) throws OfflineCaptureException {
        String[] stringArray = new String[]{"master_5.", "get_table_5.", "get_col_table_5.", "get_max_col_5.", "get_stored_proc_5.", "get_constraint_5.", "mysql5.ocp"};
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringArray[i] = n == 2 ? stringArray[i].concat("sh") : stringArray[i].concat("bat");
        }
        return stringArray;
    }
}

