/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import oracle.ocvs.OCVSFileUtil;

public class OCVSPassFile {
    private final File _passFile;

    public OCVSPassFile(File passFile) {
        this._passFile = passFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPassword(String root, char[] password) throws IOException {
        try (RandomAccessFile pass = null;){
            pass = new RandomAccessFile(this._passFile, "rw");
            if (this.findPassword(root, pass) == null) {
                pass.seek(pass.length());
                pass.writeBytes(root + ' ' + new String(password) + '\n');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePassword(String root) throws IOException {
        if (!this._passFile.exists()) {
            return;
        }
        String[] lines = OCVSFileUtil.readFileLines(this._passFile);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(this._passFile));
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].startsWith(root + ' ')) continue;
                bw.write(lines[i]);
                bw.newLine();
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this._passFile.length() <= 0L) {
            this._passFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getPassword(String root) throws IOException {
        if (!this._passFile.exists()) {
            return null;
        }
        char[] password = null;
        try (RandomAccessFile pass = null;){
            pass = new RandomAccessFile(this._passFile, "r");
            password = this.findPassword(root, pass);
        }
        return password;
    }

    private char[] findPassword(String root, RandomAccessFile pass) throws IOException {
        String s;
        do {
            if ((s = pass.readLine()) != null) continue;
            return null;
        } while (!s.startsWith(root + ' '));
        int n = root.length() + 1;
        return s.length() <= n ? "".toCharArray() : s.substring(n).toCharArray();
    }
}

