/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import oracle.ocvs.OCVSFileUtil;
import oracle.ocvs.OCVSForkConnection;

public class OCVSExtConnection
extends OCVSForkConnection {
    private final String _hostName;
    private final String _userName;
    private String _rsh = "rsh";

    public OCVSExtConnection(String hostName, String userName) {
        this._hostName = hostName;
        this._userName = userName;
    }

    public void setRemoteShell(String rsh) {
        this._rsh = rsh;
    }

    @Override
    protected String[] createServerCommandArray() {
        String[] prefixArray = this._rsh.startsWith("ssh") ? new String[]{this._rsh, "-l", this._userName, this._hostName} : new String[]{this._rsh, this._hostName, "-l", this._userName};
        return this.concatenateStringArrays(prefixArray, super.createServerCommandArray());
    }

    @Override
    protected InputStream getInputStreamImpl() {
        InputStream inputStream = super.getInputStreamImpl();
        if (OCVSFileUtil.IS_CRLF_PLATFORM) {
            inputStream = new CRLFInputStream(inputStream);
        }
        return inputStream;
    }

    @Override
    protected InputStream getErrorStreamImpl() throws IOException {
        InputStream errorStream = super.getErrorStreamImpl();
        if (OCVSFileUtil.IS_CRLF_PLATFORM) {
            errorStream = new CRLFInputStream(errorStream);
        }
        return errorStream;
    }

    private String[] concatenateStringArrays(String[] arr1, String[] arr2) {
        String[] arr3 = new String[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, arr3, 0, arr1.length);
        System.arraycopy(arr2, 0, arr3, arr1.length, arr2.length);
        return arr3;
    }

    private class CRLFInputStream
    extends FilterInputStream {
        private final PushbackInputStream _pis;

        CRLFInputStream(InputStream inputStream) {
            super(new PushbackInputStream(inputStream));
            this._pis = (PushbackInputStream)this.in;
        }

        @Override
        public int available() throws IOException {
            int n = this._pis.available();
            if (n <= 0) {
                return n;
            }
            int c = this._pis.read();
            this._pis.unread(c);
            if (c == -1) {
                return -1;
            }
            if (c == 13) {
                return n > 1 ? n : 0;
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            int c = this._pis.read();
            if (c == -1) {
                return -1;
            }
            if (c == 13) {
                int c2 = this._pis.read();
                this._pis.unread(c2);
                if (c2 == 10) {
                    return this._pis.read();
                }
            }
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            for (int i = off; i < off + len; ++i) {
                int c = this.read();
                if (c == -1) {
                    return i - off;
                }
                b[i] = (byte)c;
            }
            return len;
        }

        @Override
        public long skip(long n) throws IOException {
            for (long i = 0L; i < n; ++i) {
                int c = this.read();
                if (c != -1) continue;
                return i;
            }
            return n;
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

