/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class OCVSDateFormatUtil {
    private static final String ENTRY_TIMESTAMP_FORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private static final String ENTRY_TIMESTAMP_TIME_ZONE = "GMT";
    private static final Locale ENTRY_TIMESTAMP_LOCALE = Locale.US;
    private static final String MODTIME_TIMESTAMP_FORMAT = "dd MMM yyyy HH:mm:ss zz";
    private static final Locale MODTIME_TIMESTAMP_LOCALE = Locale.US;

    private OCVSDateFormatUtil() {
    }

    public static final String formatEntriesDate(Date date) {
        String text = OCVSDateFormatUtil.createEntriesDateFormat().format(date);
        if (text.charAt(8) != '0') {
            return text;
        }
        char[] charArray = text.toCharArray();
        charArray[8] = 32;
        return new String(charArray);
    }

    public static final Date parseModTimeDate(String text) throws ParseException {
        return OCVSDateFormatUtil.createModTimeDateFormat().parse(text);
    }

    private static final DateFormat createEntriesDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat(ENTRY_TIMESTAMP_FORMAT, ENTRY_TIMESTAMP_LOCALE);
        format.setTimeZone(TimeZone.getTimeZone(ENTRY_TIMESTAMP_TIME_ZONE));
        return format;
    }

    private static final DateFormat createModTimeDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat(MODTIME_TIMESTAMP_FORMAT, MODTIME_TIMESTAMP_LOCALE);
        return format;
    }
}

