/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeClipboard;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.help.Helpable;
import oracle.ide.log.LogManager;
import oracle.ide.palette2.PaletteEvent;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteManager;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PaletteSection;
import oracle.ide.palette2.PaletteWindow;
import oracle.ide.palette2.layouts.PaletteLayoutDescriptor;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetDialog;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetItem;
import oracle.ideimpl.palette2.MyComponentsGroup;
import oracle.ideimpl.palette2.MyComponentsPages;
import oracle.ideimpl.palette2.MyComponentsSectionDialog;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteAugmentedSection;
import oracle.ideimpl.palette2.PaletteDockable2;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.ideimpl.palette2.PaletteManagerImpl;
import oracle.ideimpl.palette2.PaletteSectionUI;
import oracle.ideimpl.palette2.PaletteWindowImpl;
import oracle.ideimpl.palette2.PaletteWindowUI;

public class PaletteControllerUI
implements Controller,
ContextMenuListener,
ActionListener {
    private static PaletteControllerUI _singleton = new PaletteControllerUI();
    private PaletteGroupUI selectedGroupUI;
    private PaletteSectionUI selectedSectionUI;
    private PaletteItemUI selectedItemUI;
    private static ContextMenu contextMenu;
    private final int HELP_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette2.HELP");
    private IdeAction helpAction;
    private JMenuItem HELP_MENU;
    private final int ADD_TO_FAVORITES_ITEM_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette2.ADDTOFAVORITESITEM");
    private IdeAction addToFavoritesItemAction;
    private JMenuItem ADD_TO_FAVORITES_ITEM_MENU;
    private final int REMOVE_FROM_FAVORITES_ITEM_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette2.REMOVEFROMFAVORITESITEM");
    private IdeAction removeFromFavoritesItemAction;
    private JMenuItem REMOVE_FROM_FAVORITES_ITEM_MENU;
    private final int CLEAR_RECENTLY_USED_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette2.CLEARRECENTLYUSEDITEMS");
    private IdeAction clearRecentlyUsedItemsAction;
    private JMenuItem CLEAR_RECENTLY_USED_ITEM_MENU;
    private final int NEW_CODE_SNIPPET_ITEM_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette2.NEWCODESNIPPETITEM");
    private IdeAction newCodeSnippetItemAction;
    private JMenuItem NEW_CODE_SNIPPET_ITEM_MENU;
    private final int UPDATE_CODE_SNIPPET_ITEM_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette2.UPDATECODESNIPPETITEM");
    private IdeAction updateCodeSnippetItemAction;
    private JMenuItem UPDATE_CODE_SNIPPET_ITEM_MENU;
    private final int REMOVE_CODE_SNIPPET_ITEM_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette2.REMOVECODESNIPPETITEM");
    private IdeAction removeCodeSnippetItemAction;
    private JMenuItem REMOVE_CODE_SNIPPET_ITEM_MENU;
    private final int NEW_SECTION_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette2.NEWSECTION");
    private IdeAction newSectionAction;
    private JMenuItem NEW_SECTION_MENU;
    private final int RENAME_SECTION_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette2.RENAMESECTION");
    private IdeAction renameSectionAction;
    private JMenuItem RENAME_SECTION_MENU;
    private final int REMOVE_SECTION_COMMAND = Ide.findOrCreateCmdID((String)"oracle.ideimpl.palette2.REMOVESECTION");
    private IdeAction removeSectionAction;
    private JMenuItem REMOVE_SECTION_MENU;
    private final int PASTE_COMMAND = Ide.findCmdID((String)"Ide.PASTE_CMD_ID");
    private IdeAction pasteAction;
    private JMenuItem PASTE_MENU;
    private boolean stickyMode = false;
    private boolean doDebugLog = false;
    private List<JMenuItem> layoutItems = new ArrayList<JMenuItem>();
    private JMenuItem useLargeIconsMenuItem;
    PopUpMouselessNavigationHelper mouselessNavigatorHelper = new PopUpMouselessNavigationHelper();
    KeyboardFocusNavHelper keyboardNavigatorHelper = new KeyboardFocusNavHelper();

    private MyComponentsPages getMyComponentsPages() {
        PaletteWindowUI paletteWindow = (PaletteWindowUI)AdapterManager.Factory.getAdapterManager().adapt((Object)PaletteWindowImpl.getInstance(), PaletteWindowUI.class);
        if (null == paletteWindow) {
            return null;
        }
        for (PalettePages pages : paletteWindow.getProviderPages()) {
            if (!(pages instanceof MyComponentsPages)) continue;
            return (MyComponentsPages)pages;
        }
        return null;
    }

    private PaletteControllerUI() {
        this.pasteAction = IdeAction.find((int)this.PASTE_COMMAND);
        this.pasteAction.addController((Controller)this);
        EditorManager.getEditorManager().addEditorListener((EditorListener)new PaletteEditorTracker());
    }

    protected void logText(String text) {
        if (this.doDebugLog) {
            LogManager.getLogManager().getMsgPage().log((Object)text);
        }
    }

    public static PaletteControllerUI getInstance() {
        return _singleton;
    }

    public PaletteWindow getPaletteWindow() {
        return PaletteWindowImpl.getInstance();
    }

    public PaletteSectionUI getSelectedSectionUI() {
        return this.selectedSectionUI;
    }

    public PaletteItemUI getSelectedItemUI() {
        return this.selectedItemUI;
    }

    public PaletteItem getSelectedItem() {
        if (this.selectedItemUI != null) {
            return this.selectedItemUI.getPaletteItem();
        }
        return null;
    }

    public void markRecentUsage() {
        PaletteItemUI pI = this.getSelectedItemUI();
        if (pI != null) {
            pI.markRecentUsage();
        }
    }

    public void unSelectSelectedItem(boolean ignoreStickyChk) {
        PaletteItemUI pI;
        if ((ignoreStickyChk || !this.getStickyMode()) && (pI = this.getSelectedItemUI()) != null) {
            pI.showAsUnselected();
            this.setSelectedWindowUI((PaletteItemUI)null);
        }
    }

    private void straightUnselect() {
        PaletteItemUI pI = this.getSelectedItemUI();
        if (pI != null) {
            pI.showAsUnselected();
            this.setSelectedWindowUI((PaletteItemUI)null);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        String snippet;
        int commandId = action.getCommandId();
        boolean ret = false;
        if (commandId == PaletteManagerImpl.SEARCH_GO_ID) {
            PaletteWindowImpl pw = (PaletteWindowImpl)this.getPaletteWindow();
            pw.doSearch();
            return true;
        }
        if (commandId == PaletteManagerImpl.SEARCH_STOP_ID) {
            PaletteWindowImpl pw = (PaletteWindowImpl)this.getPaletteWindow();
            pw.stopSearch();
            return true;
        }
        if (action == this.helpAction) {
            PaletteItem pItem = this.selectedItemUI.getPaletteItem();
            String helpName = pItem.getHelpable();
            if (helpName != null && helpName.length() > 0) {
                Helpable helpable = null;
                try {
                    helpable = (Helpable)Class.forName(helpName).newInstance();
                    if (helpable != null) {
                        HelpSystem.getHelpSystem().showHelp(helpable.getHelpInfo());
                    }
                }
                catch (Exception ex) {
                    HelpSystem.getHelpSystem().showHelp(new HelpInfo(helpName));
                }
                ret = true;
            }
        } else if (action == this.addToFavoritesItemAction) {
            String groupName;
            String currentPage = null;
            currentPage = this.selectedItemUI.getPageName();
            if (currentPage == null || currentPage.length() == 0) {
                currentPage = this.getCurrentPageName();
            }
            if (((groupName = this.selectedItemUI.getGroupName()) == null || groupName.length() == 0) && (groupName = this.getCurrentGroupName()) == null) {
                return false;
            }
            this.getMyComponentsPages().addToFavorites(this.getSelectedItem(), currentPage, groupName, null, true);
            this.focusProperly();
            ret = true;
        } else if (action == this.removeFromFavoritesItemAction) {
            String sectionName = this.getCurrentSectionName();
            this.getMyComponentsPages().removeItem(7, this.getSelectedItem(), sectionName);
            this.focusProperly();
            ret = true;
        } else if (action == this.clearRecentlyUsedItemsAction) {
            this.getMyComponentsPages().clearRecentlyUsed(true);
            ret = true;
        } else if (action == this.newCodeSnippetItemAction) {
            this.showCodeSnippetDialog(null, null);
            this.focusProperly();
            ret = true;
        } else if (action == this.updateCodeSnippetItemAction) {
            this.showCodeSnippetDialog(this.getSelectedItem(), null);
            ret = true;
        } else if (action == this.removeCodeSnippetItemAction) {
            String sectionName = this.getCurrentSectionName();
            this.getMyComponentsPages().removeItem(11, this.getSelectedItem(), sectionName);
            this.getMyComponentsPages().purgeItem(this.getSelectedItem());
            this.focusProperly();
            ret = true;
        } else if (action == this.newSectionAction) {
            this.showSectionDialog(null);
            this.focusProperly();
            ret = true;
        } else if (action == this.renameSectionAction) {
            PaletteAugmentedSection augSection = (PaletteAugmentedSection)this.selectedSectionUI.getPaletteSection();
            this.showSectionDialog(augSection);
            this.focusProperly();
            ret = true;
        } else if (action == this.removeSectionAction) {
            PaletteAugmentedSection augSection = (PaletteAugmentedSection)this.selectedSectionUI.getPaletteSection();
            String groupName = this.getCurrentGroupName();
            if (groupName == null) {
                return false;
            }
            int comp = groupName.equals(PaletteArb.getString(7)) ? 7 : 11;
            this.getMyComponentsPages().removeSection(comp, augSection.getName());
            this.setSelectedWindowUI((PaletteSectionUI)null);
            this.focusProperly();
            ret = true;
        } else if (action == this.pasteAction && this.enablePaste() && (snippet = this.getTextFromClipBoard()) != null && snippet.length() > 0) {
            ret = true;
            this.showCodeSnippetDialog(null, snippet);
        }
        if (ret) {
            this.mouselessNavigatorHelper.actionPerformed(action);
        }
        return ret;
    }

    private void focusProperly() {
        if (!this.keyboardNavigatorHelper.isFocusedOnPaletteItem() && !this.keyboardNavigatorHelper.isFocusedOnDrawer()) {
            this.keyboardNavigatorHelper.focusOnDefault();
        }
    }

    private PaletteGroup getPaletteGroup() {
        PaletteGroup group = null;
        PaletteGroupUI groupUI = this.selectedGroupUI;
        if (groupUI == null) {
            PaletteSectionUI sectionUI = null;
            if (this.selectedSectionUI == null) {
                if (this.selectedItemUI != null) {
                    sectionUI = this.selectedItemUI.getPaletteSectionUI();
                }
            } else {
                sectionUI = this.selectedSectionUI;
            }
            if (sectionUI != null) {
                groupUI = sectionUI.getPaletteGroupUI();
            }
        }
        if (groupUI != null) {
            group = groupUI.getPaletteGroup();
        }
        return group;
    }

    private void showCodeSnippetDialog(PaletteItem item, String snippet) {
        String sectionName = this.getCurrentSectionName();
        MyComponentsCodeSnippetDialog dlg = new MyComponentsCodeSnippetDialog();
        PaletteGroup group = this.getPaletteGroup();
        if (group instanceof MyComponentsGroup) {
            dlg.invoke((MyComponentsGroup)group, sectionName, (MyComponentsCodeSnippetItem)item, snippet);
        }
    }

    private void showSectionDialog(PaletteAugmentedSection augSection) {
        MyComponentsSectionDialog dlg = new MyComponentsSectionDialog();
        PaletteGroup group = this.getPaletteGroup();
        if (group instanceof MyComponentsGroup) {
            dlg.invoke((MyComponentsGroup)group, augSection);
        }
    }

    public boolean update(IdeAction action, Context context) {
        boolean ret = false;
        int commandId = action.getCommandId();
        if (commandId == PaletteManagerImpl.SEARCH_GO_ID || commandId == PaletteManagerImpl.SEARCH_STOP_ID) {
            action.setEnabled(true);
            return true;
        }
        if (action == this.helpAction) {
            ret = true;
        } else if (action == this.addToFavoritesItemAction) {
            ret = true;
        } else if (action == this.removeFromFavoritesItemAction) {
            ret = true;
        } else if (action == this.newCodeSnippetItemAction) {
            ret = true;
        } else if (action == this.updateCodeSnippetItemAction) {
            ret = true;
        } else if (action == this.removeCodeSnippetItemAction) {
            ret = true;
        } else if (action == this.newSectionAction) {
            ret = null != this.selectedGroupUI ? !this.selectedGroupUI.getPaletteGroup().isEmpty() : false;
            action.setEnabled(ret);
        } else if (action == this.renameSectionAction) {
            ret = true;
        } else if (action == this.removeSectionAction) {
            ret = true;
        } else if (action == this.pasteAction && (ret = this.enablePaste())) {
            action.setEnabled(ret);
        }
        if (ret) {
            action.setEnabled(true);
        }
        return ret;
    }

    private boolean enablePaste() {
        String snippet;
        String groupName;
        PaletteGroup group;
        boolean ret = false;
        if (this.selectedGroupUI != null && (group = this.getPaletteGroup()) != null && (groupName = group.getName()) != null && groupName.equals(PaletteArb.getString(11)) && (snippet = this.getTextFromClipBoard()) != null && snippet.length() > 0) {
            ret = true;
        }
        return ret;
    }

    private String getTextFromClipBoard() {
        String text = null;
        Clipboard clipboard = IdeClipboard.getClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null) {
            try {
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    Object data = transferable.getTransferData(DataFlavor.stringFlavor);
                    text = data.toString();
                }
            }
            catch (Exception e) {
                text = null;
            }
        }
        return text;
    }

    public void setSelectedWindowUI(PaletteGroupUI group) {
        this.selectedGroupUI = group;
        this.selectedSectionUI = null;
        this.setSelectedItem(null);
    }

    private void setSelectedItem(PaletteItemUI piui) {
        this.selectedItemUI = piui;
        if (this.selectedItemUI == null && this.getStickyMode()) {
            this.setStickyMode(false);
        }
    }

    public void setSelectedWindowUI(PaletteSectionUI section) {
        this.selectedGroupUI = null;
        this.selectedSectionUI = section;
        this.setSelectedItem(null);
    }

    public void setSelectedWindowUI(PaletteItemUI item) {
        this.setSelectedWindowUI(item, "PALETTE2_ITEM_SELECTED");
    }

    public void setSelectedWindowUI(PaletteItemUI item, String event) {
        this.selectedGroupUI = null;
        this.selectedSectionUI = null;
        if (this.selectedItemUI != null) {
            if (this.getStickyMode()) {
                this.setStickyMode(false);
            }
            if (!("PALETTE2_ITEM_DRAG_DROPPED".equals(event) || "PALETTE2_BUTTON2_PRESSED".equals(event) || "PALETTE2_BUTTON2_RELEASED".equals(event))) {
                this.fireItemUnselected();
            }
        }
        this.setSelectedItem(item);
        if (item != null) {
            this.fireItemSelected(event);
        }
    }

    private String getCurrentPageName() {
        PaletteWindowImpl pW = (PaletteWindowImpl)this.getPaletteWindow();
        String currentPageName = pW.getSelectedPageName();
        return currentPageName;
    }

    private String getCurrentGroupName() {
        PaletteGroupUI groupUI = null;
        PaletteGroup group = null;
        if (this.selectedGroupUI != null) {
            groupUI = this.selectedGroupUI;
        } else if (this.selectedSectionUI != null) {
            groupUI = this.selectedSectionUI.getPaletteGroupUI();
        } else if (this.selectedItemUI != null) {
            PaletteSectionUI sectionUI = this.selectedItemUI.getPaletteSectionUI();
            groupUI = sectionUI.getPaletteGroupUI();
        }
        if (groupUI != null) {
            group = groupUI.getPaletteGroup();
            return null != group ? group.getName() : null;
        }
        return null;
    }

    protected String getCurrentSectionName() {
        String name = null;
        if (this.selectedSectionUI != null) {
            PaletteSection section = this.selectedSectionUI.getPaletteSection();
            name = section.getName();
        } else if (this.selectedItemUI != null) {
            PaletteSectionUI sectionUI = this.selectedItemUI.getPaletteSectionUI();
            PaletteSection section = sectionUI.getPaletteSection();
            name = section.getName();
        }
        return name;
    }

    private Dockable getCurrentDockable() {
        PaletteWindow paletteWindow = this.getPaletteWindow();
        if (null == paletteWindow) {
            return null;
        }
        PaletteWindowUI windowUI = (PaletteWindowUI)AdapterManager.Factory.getAdapterManager().adapt((Object)paletteWindow, PaletteWindowUI.class);
        if (null == windowUI) {
            return null;
        }
        String currentPageName = this.getCurrentPageName();
        String currentGroupName = this.getCurrentGroupName();
        return DockStation.getDockStation().getDockable(windowUI.getViewId(currentPageName, currentGroupName));
    }

    public boolean tryPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.mouselessNavigatorHelper.triggeredByMouse();
            this.getContextMenu().show(this.getPaletteWindow().getContext(e));
            return true;
        }
        return false;
    }

    public synchronized ContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new ContextMenu();
            contextMenu.addContextMenuListener((ContextMenuListener)this);
            ContextMenuListenersHook hook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
            if (hook != null) {
                contextMenu.addContextMenuListener(hook.getListener("palette"));
            }
        }
        return contextMenu;
    }

    public PaletteItem getCurrentlyFocusedPaletteItem() {
        if (this.keyboardNavigatorHelper != null && this.keyboardNavigatorHelper.getCurrentlyFocusedPaletteItem() != null) {
            return this.keyboardNavigatorHelper.getCurrentlyFocusedPaletteItem().getPaletteItem();
        }
        return null;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        PaletteItem pItem;
        String helpable;
        this.mouselessNavigatorHelper.menuWillBeShowing(contextMenu);
        this.buildMenu(contextMenu);
        String currentPage = this.getCurrentPageName();
        String currentGroupName = this.getCurrentGroupName();
        Boolean myComponents = false;
        if (currentPage.equals(PaletteArb.getString(5)) && currentGroupName != null && !currentGroupName.equals("SearchResultsGroup")) {
            myComponents = true;
        }
        if (myComponents.booleanValue()) {
            if (currentGroupName != null) {
                if (this.selectedGroupUI != null) {
                    if (currentGroupName.equals(PaletteArb.getString(11))) {
                        contextMenu.add((Component)this.NEW_CODE_SNIPPET_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.NEW_SECTION_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.PASTE_MENU, MenuConstants.SECTION_COMP_PALETTE_VIEW);
                    } else if (currentGroupName.equals(PaletteArb.getString(7))) {
                        contextMenu.add((Component)this.NEW_SECTION_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                    }
                } else if (this.selectedSectionUI != null) {
                    if (currentGroupName.equals(PaletteArb.getString(11))) {
                        contextMenu.add((Component)this.NEW_CODE_SNIPPET_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.RENAME_SECTION_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.REMOVE_SECTION_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.PASTE_MENU, MenuConstants.SECTION_COMP_PALETTE_VIEW);
                    } else if (currentGroupName.equals(PaletteArb.getString(7))) {
                        contextMenu.add((Component)this.RENAME_SECTION_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.REMOVE_SECTION_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                    }
                } else if (this.selectedItemUI != null) {
                    if (currentGroupName.equals(PaletteArb.getString(11))) {
                        contextMenu.add((Component)this.NEW_CODE_SNIPPET_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.UPDATE_CODE_SNIPPET_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.REMOVE_CODE_SNIPPET_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.NEW_SECTION_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.PASTE_MENU, MenuConstants.SECTION_COMP_PALETTE_VIEW);
                        contextMenu.add((Component)this.ADD_TO_FAVORITES_ITEM_MENU, MenuConstants.increment((float)MenuConstants.SECTION_COMP_PALETTE_COMPONENT));
                    } else if (currentGroupName.equals(PaletteArb.getString(7))) {
                        contextMenu.add((Component)this.NEW_SECTION_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.REMOVE_FROM_FAVORITES_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                    } else if (currentGroupName.equals(PaletteArb.getString(9))) {
                        contextMenu.add((Component)this.ADD_TO_FAVORITES_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                        contextMenu.add((Component)this.CLEAR_RECENTLY_USED_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
                    }
                }
            }
        } else if (this.selectedItemUI != null) {
            contextMenu.add((Component)this.ADD_TO_FAVORITES_ITEM_MENU, MenuConstants.SECTION_COMP_PALETTE_COMPONENT);
        }
        if (currentGroupName != null && !currentGroupName.equals("SearchResultsGroup")) {
            for (JMenuItem item : this.layoutItems) {
                contextMenu.add((Component)item, MenuConstants.SECTION_COMP_PALETTE_VIEW);
            }
            contextMenu.add((Component)this.useLargeIconsMenuItem, MenuConstants.WEIGHT_COMP_PALETTE_TOGGLE_VIEW);
        }
        if (this.selectedItemUI != null && (helpable = (pItem = this.selectedItemUI.getPaletteItem()).getHelpable()) != null && helpable.length() > 0) {
            contextMenu.add((Component)this.HELP_MENU, MenuConstants.SECTION_HELP_ABOUT);
        }
        if (contextMenu.getMenuCount() > 0) {
            this.mouselessNavigatorHelper.menuShown();
        } else {
            this.mouselessNavigatorHelper.menuShown();
            this.mouselessNavigatorHelper.menuHiding();
        }
    }

    private void buildMenu(ContextMenu mgr) {
        Dockable dockable;
        if (this.HELP_MENU == null) {
            this.helpAction = this.getAction(this.HELP_COMMAND, null, PaletteArb.getString(35));
            this.HELP_MENU = mgr.createMenuItem((ToggleAction)this.helpAction, MenuConstants.WEIGHT_COMP_PALETTE_HELP);
        }
        if (this.ADD_TO_FAVORITES_ITEM_MENU == null) {
            this.addToFavoritesItemAction = this.getAction(this.ADD_TO_FAVORITES_ITEM_COMMAND, null, PaletteArb.getString(37));
            this.ADD_TO_FAVORITES_ITEM_MENU = mgr.createMenuItem((ToggleAction)this.addToFavoritesItemAction, MenuConstants.WEIGHT_COMP_PALETTE_ADD_TO_FAVORITES);
        }
        if (this.REMOVE_FROM_FAVORITES_ITEM_MENU == null) {
            this.removeFromFavoritesItemAction = this.getAction(this.REMOVE_FROM_FAVORITES_ITEM_COMMAND, null, PaletteArb.getString(38));
            this.REMOVE_FROM_FAVORITES_ITEM_MENU = mgr.createMenuItem((ToggleAction)this.removeFromFavoritesItemAction, MenuConstants.WEIGHT_COMP_PALETTE_REMOVE_FROM_FAVORITES);
        }
        if (this.CLEAR_RECENTLY_USED_ITEM_MENU == null) {
            this.clearRecentlyUsedItemsAction = this.getAction(this.CLEAR_RECENTLY_USED_COMMAND, null, PaletteArb.getString(39));
            this.CLEAR_RECENTLY_USED_ITEM_MENU = mgr.createMenuItem((ToggleAction)this.clearRecentlyUsedItemsAction, MenuConstants.WEIGHT_COMP_PALETTE_CLEAR_RECENTLY_USED);
        }
        if (this.NEW_CODE_SNIPPET_ITEM_MENU == null) {
            this.newCodeSnippetItemAction = this.getAction(this.NEW_CODE_SNIPPET_ITEM_COMMAND, null, PaletteArb.getString(40));
            this.NEW_CODE_SNIPPET_ITEM_MENU = mgr.createMenuItem((ToggleAction)this.newCodeSnippetItemAction, MenuConstants.WEIGHT_COMP_PALETTE_NEW_CODE_SNIPPET);
        }
        if (this.UPDATE_CODE_SNIPPET_ITEM_MENU == null) {
            this.updateCodeSnippetItemAction = this.getAction(this.UPDATE_CODE_SNIPPET_ITEM_COMMAND, null, PaletteArb.getString(41));
            this.UPDATE_CODE_SNIPPET_ITEM_MENU = mgr.createMenuItem((ToggleAction)this.updateCodeSnippetItemAction, MenuConstants.WEIGHT_COMP_PALETTE_UPDATE_CODE_SNIPPET);
        }
        if (this.REMOVE_CODE_SNIPPET_ITEM_MENU == null) {
            this.removeCodeSnippetItemAction = this.getAction(this.REMOVE_CODE_SNIPPET_ITEM_COMMAND, null, PaletteArb.getString(42));
            this.REMOVE_CODE_SNIPPET_ITEM_MENU = mgr.createMenuItem((ToggleAction)this.removeCodeSnippetItemAction, MenuConstants.WEIGHT_COMP_PALETTE_REMOVE_CODE_SNIPPET);
        }
        if ((dockable = this.getCurrentDockable()) instanceof PaletteDockable2) {
            PaletteDockable2 dock2 = (PaletteDockable2)dockable;
            String viewState = dock2.getViewState();
            ButtonGroup group = new ButtonGroup();
            List<PaletteLayoutDescriptor> descriptors = PaletteLayoutDescriptor.Manager.getLayoutDescriptors();
            Collections.sort(descriptors, new Comparator<PaletteLayoutDescriptor>(){

                @Override
                public int compare(PaletteLayoutDescriptor desc1, PaletteLayoutDescriptor desc2) {
                    return desc1.name().compareTo(desc2.name());
                }
            });
            for (PaletteLayoutDescriptor descriptor : descriptors) {
                ApplyPaletteLayoutAction action = new ApplyPaletteLayoutAction(dock2, descriptor);
                action.setState(descriptor.id().equals(viewState));
                JMenuItem item = mgr.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_COMP_PALETTE_TOGGLE_VIEW);
                group.add(item);
                this.layoutItems.add(item);
            }
            if (null == this.useLargeIconsMenuItem) {
                UseLargeIconsAction action = new UseLargeIconsAction();
                this.useLargeIconsMenuItem = mgr.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_COMP_PALETTE_TOGGLE_VIEW);
            }
        }
        if (this.NEW_SECTION_MENU == null) {
            this.newSectionAction = this.getAction(this.NEW_SECTION_COMMAND, null, PaletteArb.getString(45));
            this.NEW_SECTION_MENU = mgr.createMenuItem((ToggleAction)this.newSectionAction, MenuConstants.WEIGHT_COMP_PALETTE_NEW_CODE_SNIPPET);
        }
        if (this.RENAME_SECTION_MENU == null) {
            this.renameSectionAction = this.getAction(this.RENAME_SECTION_COMMAND, null, PaletteArb.getString(46));
            this.RENAME_SECTION_MENU = mgr.createMenuItem((ToggleAction)this.renameSectionAction, MenuConstants.WEIGHT_COMP_PALETTE_REMOVE_CODE_SNIPPET);
        }
        if (this.REMOVE_SECTION_MENU == null) {
            this.removeSectionAction = this.getAction(this.REMOVE_SECTION_COMMAND, null, PaletteArb.getString(47));
            this.REMOVE_SECTION_MENU = mgr.createMenuItem((ToggleAction)this.removeSectionAction, MenuConstants.WEIGHT_COMP_PALETTE_REMOVE_CODE_SNIPPET);
        }
        if (this.PASTE_MENU == null) {
            this.PASTE_MENU = mgr.createMenuItem((ToggleAction)this.pasteAction, MenuConstants.WEIGHT_COMP_PALETTE_REMOVE_CODE_SNIPPET);
        }
    }

    private IdeAction getAction(int commandID, MetaClass cmdClass, String name) {
        IdeAction action = IdeAction.findOrCreate((int)commandID, (MetaClass)cmdClass, (String)name);
        action.addController((Controller)this);
        this.addMnemonics(action, name);
        return action;
    }

    private void addMnemonics(IdeAction action, String mnemonic) {
        int mindex = mnemonic.indexOf("&");
        action.putValue("MnemonicKey", (Object)new Integer(mnemonic.charAt(mindex + 1)));
    }

    public void menuWillHide(ContextMenu contextMenu) {
        this.mouselessNavigatorHelper.menuHiding();
        for (JMenuItem item : this.layoutItems) {
            contextMenu.remove((Component)item);
        }
        this.layoutItems.clear();
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PaletteWindowImpl pW = (PaletteWindowImpl)this.getPaletteWindow();
        pW.selectionChanged();
    }

    protected void setStickyMode(boolean on) {
        PaletteItem item = this.getSelectedItem();
        if (item == null) {
            this.logText("paletteController, setStickMode state: sMode=" + on + " pI is null \n");
        } else {
            this.logText("paletteController, setStickMode state: sMode=" + on + " pi=" + item.getName() + " sticky=" + this.getStickyMode() + "\n");
        }
        if (item != null) {
            PaletteWindowImpl palette = (PaletteWindowImpl)this.getPaletteWindow();
            if (this.getStickyMode() && !on) {
                palette.fireStickyModeDeactivated(new PaletteEvent(item, "PALETTE2_STICKY_MODE_DEACTIVATED"));
                this.logText("paletteController, fireStickyModeDeactivated for " + item.getName() + "\n");
            }
            if (on) {
                final KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                mgr.addKeyEventPostProcessor(new KeyEventPostProcessor(){

                    @Override
                    public boolean postProcessKeyEvent(KeyEvent e) {
                        if (e.getKeyCode() == 27) {
                            mgr.removeKeyEventPostProcessor(this);
                            PaletteControllerUI.this.setStickyMode(false);
                            PaletteControllerUI.this.straightUnselect();
                            return true;
                        }
                        return false;
                    }
                });
                palette.fireStickyModeActivated(new PaletteEvent(item, "PALETTE2_STICKY_MODE_ACTIVATED"));
                this.logText("paletteController, fireStickyModeActivated for " + item.getName() + "\n");
            }
        }
        this.stickyMode = on;
    }

    protected boolean getStickyMode() {
        return this.stickyMode;
    }

    protected void fireItemSelected(String event) {
        PaletteItem paletteItem = this.getSelectedItem();
        if (paletteItem != null) {
            String groupName;
            this.logText("paletteController, fireItemselected " + paletteItem.getName() + "\n");
            String currentPage = null;
            currentPage = this.selectedItemUI.getPageName();
            if (currentPage == null || currentPage.length() == 0) {
                currentPage = this.getCurrentPageName();
            }
            if ((groupName = this.selectedItemUI.getGroupName()) == null || groupName.length() == 0) {
                groupName = this.getCurrentGroupName();
            }
            this.selectedItemUI.requestFocus();
            if (!("PALETTE2_ITEM_DRAG_SELECTED".equals(event) || "PALETTE2_BUTTON2_PRESSED".equals(event) || "PALETTE2_BUTTON2_RELEASED".equals(event))) {
                PaletteWindowImpl pW = (PaletteWindowImpl)this.getPaletteWindow();
                pW.fireItemSelected(new PaletteEvent(paletteItem, event));
            }
        }
    }

    protected void fireItemUnselected() {
        PaletteItem item = this.getSelectedItem();
        if (null != item) {
            PaletteEvent event = new PaletteEvent(item, "PALETTE2_ITEM_UNSELECTED");
            ((PaletteWindowImpl)this.getPaletteWindow()).fireItemUnselected(event);
        }
        this.logText("paletteController, fireItemUnselected " + (item != null ? item.getName() : "null") + "\n");
    }

    private static class UseLargeIconsAction
    extends ToggleAction {
        private UseLargeIconsAction() {
            super(PaletteArb.getString(48), null);
            this.setBooleanValue("Check", true);
            PaletteWindow window = PaletteManager.getPaletteManager().getPaletteWindow();
            boolean b = window.getUseLargeIcons();
            this.setState(b);
        }

        public void actionPerformed(ActionEvent e) {
            boolean useLargeIcons = this.getState();
            PaletteWindow window = PaletteManager.getPaletteManager().getPaletteWindow();
            window.setUseLargeIcons(useLargeIcons);
        }
    }

    private static class ApplyPaletteLayoutAction
    extends ToggleAction {
        private final transient PaletteDockable2 dockable;
        private final transient PaletteLayoutDescriptor layoutDescriptor;

        private ApplyPaletteLayoutAction(PaletteDockable2 dockable, PaletteLayoutDescriptor layoutDescriptor) {
            super(layoutDescriptor.name(), layoutDescriptor.icon());
            if (null == dockable) {
                throw new IllegalArgumentException("PaletteDockable must not be null");
            }
            this.dockable = dockable;
            if (null == layoutDescriptor) {
                throw new IllegalArgumentException("PaletteLayoutDescriptor must not be null");
            }
            this.layoutDescriptor = layoutDescriptor;
            this.setBooleanValue("Radio", true);
        }

        public void actionPerformed(ActionEvent e) {
            this.dockable.setViewState(this.layoutDescriptor.id());
        }
    }

    private class KeyboardFocusNavHelper {
        private Component nextInTabOrder = null;
        private Container root = null;

        private KeyboardFocusNavHelper() {
        }

        private void rememberFocus() {
            this.root = this.getFocusedComponent().getFocusCycleRootAncestor();
            this.nextInTabOrder = this.root.getFocusTraversalPolicy().getComponentAfter(this.root, this.getFocusedComponent());
        }

        private void focusOnDefault() {
            if (this.root != null) {
                this.root.getFocusTraversalPolicy().getDefaultComponent(this.root).requestFocusInWindow();
            } else if (this.getFocusedComponent() != null && this.getFocusedComponent().getFocusCycleRootAncestor() != null) {
                Container focusComponentRoot = this.getFocusedComponent().getFocusCycleRootAncestor();
                FocusTraversalPolicy focusTraversalPolicy = this.getFocusedComponent().getFocusCycleRootAncestor().getFocusTraversalPolicy();
                if (focusTraversalPolicy != null && focusTraversalPolicy.getDefaultComponent(focusComponentRoot) != null) {
                    focusTraversalPolicy.getDefaultComponent(focusComponentRoot).requestFocusInWindow();
                }
            }
        }

        private Component getFocusedComponent() {
            return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }

        private PaletteItemUI getCurrentlyFocusedPaletteItem() {
            if (this.isFocusedOnPaletteItem()) {
                return (PaletteItemUI)this.getFocusedComponent().getParent();
            }
            if (this.getFocusedComponent() instanceof PaletteItemUI) {
                return (PaletteItemUI)this.getFocusedComponent();
            }
            return null;
        }

        private boolean isFocusedOnPaletteItem() {
            return this.getFocusedComponent() != null ? this.getFocusedComponent().getParent() instanceof PaletteItemUI : false;
        }

        private boolean isFocusedOnDrawer() {
            return this.getFocusedComponent() != null ? this.getFocusedComponent() instanceof PaletteItemUI || this.getFocusedComponent() instanceof PaletteGroupUI : false;
        }

        private PaletteGroupUI getPaletteGroupUI() {
            if (this.getFocusedComponent() != null) {
                if (this.getFocusedComponent() instanceof PaletteItemUI) {
                    return ((PaletteItemUI)this.getFocusedComponent()).getPaletteSectionUI().getPaletteGroupUI();
                }
                if (this.getFocusedComponent() instanceof PaletteGroupUI) {
                    return (PaletteGroupUI)this.getFocusedComponent();
                }
            }
            return null;
        }
    }

    private class PopUpMouselessNavigationHelper {
        private PopUpState state = PopUpState.NOT_SHOWN;
        private boolean popupTriggeredByMouse = false;
        private boolean spoofedSelection = false;
        private boolean spoofedGroupSelection = false;
        private PopupMenuListener popupListener = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (PopUpMouselessNavigationHelper.this.popupTriggeredByMouse) {
                    PopUpMouselessNavigationHelper.this.popupTriggeredByMouse = false;
                } else if (PopUpMouselessNavigationHelper.this.spoofedSelection) {
                    PopUpMouselessNavigationHelper.this.spoofedSelection = false;
                    PaletteControllerUI.this.setSelectedWindowUI((PaletteItemUI)null);
                    PaletteControllerUI.this.setSelectedWindowUI((PaletteGroupUI)null);
                } else if (PopUpMouselessNavigationHelper.this.spoofedGroupSelection) {
                    PopUpMouselessNavigationHelper.this.spoofedGroupSelection = false;
                    PaletteControllerUI.this.setSelectedWindowUI((PaletteGroupUI)null);
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }
        };

        private PopUpMouselessNavigationHelper() {
        }

        private void menuShown() {
            assert (this.state != PopUpState.INVALID);
            if (this.popupTriggeredByMouse) {
                return;
            }
            if (this.state == PopUpState.MENU_WILL_SHOW) {
                this.state = PopUpState.MENU_SHOWN;
            }
        }

        private void menuHiding() {
            assert (this.state != PopUpState.INVALID);
            if (this.popupTriggeredByMouse) {
                return;
            }
            if (this.state == PopUpState.MENU_SHOWN) {
                this.state = PopUpState.NOT_SHOWN;
            }
        }

        private void actionPerformed(IdeAction itemAction) {
            assert (this.state != PopUpState.INVALID);
            if (this.popupTriggeredByMouse) {
                this.popupTriggeredByMouse = false;
            } else if (this.state == PopUpState.NOT_SHOWN) {
                if (this.spoofedSelection) {
                    this.spoofedSelection = false;
                    PaletteControllerUI.this.setSelectedWindowUI((PaletteItemUI)null);
                    PaletteControllerUI.this.setSelectedWindowUI((PaletteGroupUI)null);
                } else if (this.spoofedGroupSelection) {
                    this.spoofedGroupSelection = false;
                    PaletteControllerUI.this.setSelectedWindowUI((PaletteGroupUI)null);
                }
            } else {
                this.state = PopUpState.INVALID;
            }
        }

        private void menuWillBeShowing(ContextMenu contextMenu) {
            assert (this.state != PopUpState.INVALID);
            assert (contextMenu != null);
            JPopupMenu jpMenu = (JPopupMenu)contextMenu.getGUI(true);
            jpMenu.removePopupMenuListener(this.popupListener);
            jpMenu.addPopupMenuListener(this.popupListener);
            if (this.popupTriggeredByMouse) {
                return;
            }
            if (this.state == PopUpState.NOT_SHOWN) {
                this.state = PopUpState.MENU_WILL_SHOW;
                if (PaletteControllerUI.this.keyboardNavigatorHelper.isFocusedOnPaletteItem()) {
                    PaletteControllerUI.this.keyboardNavigatorHelper.rememberFocus();
                    PaletteItemUI currentlyHighlightedPaletteItemUI = PaletteControllerUI.this.keyboardNavigatorHelper.getCurrentlyFocusedPaletteItem();
                    if (PaletteControllerUI.this.selectedItemUI != currentlyHighlightedPaletteItemUI) {
                        this.spoofedSelection = true;
                        PaletteControllerUI.this.setSelectedWindowUI(currentlyHighlightedPaletteItemUI, "PALETTE2_BUTTON2_PRESSED");
                    }
                } else if (PaletteControllerUI.this.keyboardNavigatorHelper.isFocusedOnDrawer()) {
                    this.spoofedGroupSelection = true;
                    PaletteControllerUI.this.setSelectedWindowUI(PaletteControllerUI.this.keyboardNavigatorHelper.getPaletteGroupUI());
                }
            } else {
                this.state = PopUpState.INVALID;
            }
        }

        private void triggeredByMouse() {
            this.popupTriggeredByMouse = true;
        }
    }

    static enum PopUpState {
        INVALID,
        NOT_SHOWN,
        MENU_WILL_SHOW,
        MENU_SHOWN;

    }

    private class PaletteEditorTracker
    implements EditorListener {
        private Editor currentlyActiveEditor = null;

        private PaletteEditorTracker() {
        }

        public void editorOpened(Editor editor) {
            this.currentlyActiveEditor = editor;
            if (PaletteControllerUI.this.getStickyMode()) {
                PaletteControllerUI.this.setStickyMode(false);
            }
            PaletteControllerUI.this.straightUnselect();
        }

        public void editorActivated(Editor editor) {
            if (!this.areEqual(this.currentlyActiveEditor, editor)) {
                if (PaletteControllerUI.this.getStickyMode()) {
                    PaletteControllerUI.this.setStickyMode(false);
                }
                this.currentlyActiveEditor = editor;
            }
        }

        public void editorDeactivated(Editor editor) {
            this.currentlyActiveEditor = editor;
        }

        public void editorClosed(Editor editor) {
            if (this.areEqual(editor, this.currentlyActiveEditor)) {
                PaletteControllerUI.this.straightUnselect();
                this.currentlyActiveEditor = null;
            }
        }

        boolean areEqual(Editor editor1, Editor editor2) {
            boolean eq = false;
            if (editor1 != null && editor2 != null) {
                eq = editor1.equals(editor2);
            }
            return eq;
        }
    }
}

