/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.util.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.util.jdbc.JDBCTable;

public class JDBCSchema
extends Schema {
    private static final int _TABLE_NAME = 3;
    private Connection _connection;
    private String _schemaName;
    private Database _database;
    private Table[] _tables;
    private String[] _tableNames;

    public JDBCSchema(Connection connection, Database database, String schemaName) {
        this._schemaName = schemaName;
        this._connection = connection;
        this._database = database;
    }

    public Database getDatabase() {
        return this._database;
    }

    public String getName() {
        return this._schemaName;
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public int getTableCount() {
        if (this._tableNames == null) {
            this._tableNames = this.createTableNames();
        }
        return this._tableNames == null ? 0 : this._tableNames.length;
    }

    public Table getTable(int index) {
        if (this._tables == null) {
            this._tables = new Table[this.getTableCount()];
        }
        if (this._tables[index] == null) {
            this._tables[index] = this.createTable(index);
        }
        return this._tables[index];
    }

    public String getTableName(int index) {
        if (this._tableNames == null) {
            this._tableNames = this.createTableNames();
        }
        return this._tableNames == null ? null : this._tableNames[index];
    }

    public String getTableDisplayName(int index, Locale locale) {
        return this.getTableName(index);
    }

    public Connection getConnection() {
        return this._connection;
    }

    public String toString() {
        return this.getName();
    }

    protected Table createTable(int index) {
        String name = this.getTableName(index);
        return new JDBCTable(this._connection, this, name);
    }

    protected String[] createTableNames() {
        Object[] tableNames = null;
        try {
            ResultSet data = this._connection.getMetaData().getTables(null, this.getName(), null, null);
            Vector<String> temp = new Vector<String>();
            while (data.next()) {
                String table = data.getString(3);
                temp.addElement(table);
            }
            tableNames = new String[temp.size()];
            if (temp.size() != 0) {
                temp.copyInto(tableNames);
            }
            data.close();
        }
        catch (SQLException e) {
            System.err.println("A SQLException occured " + e);
        }
        return tableNames;
    }
}

