/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.NodeComponent;
import oracle.bali.dbUI.graph.NodeToolTipClient;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.JLEWindow;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.geom.Dimension2D;

public class JLENodeWindow
extends JLEWindow {
    private Listener _listener;
    private boolean _added;

    protected JLENodeWindow() {
        this(null);
    }

    protected JLENodeWindow(Node node) {
        NodeComponent nc = this.createNodeComponent();
        this._listener = new Listener();
        this.setContent((Component)((Object)nc));
        this.setNode(node);
        nc.getSpreadTable().getGrid().addKeyListener((KeyListener)this._listener);
        nc.getSpreadTable().getColumnHeader().addKeyListener((KeyListener)this._listener);
        this.getComponent().addKeyListener(this._listener);
        nc.addPropertyChangeListener(this._listener);
        this._addMouseListener(this.__getTitleBar(), this._listener);
        this._unregisterComponents(this.getComponent());
    }

    void setAutoDisplayToolTips(boolean autoDisplay) {
        super.setAutoDisplayToolTips(autoDisplay);
        NodeComponent nc = this.getNodeComponent();
        Grid g = nc.getSpreadTable().getGrid();
        GridToolTipManager gttm = g.getToolTipManager();
        if (gttm instanceof NodeToolTipClient) {
            ((NodeToolTipClient)gttm).setAlwaysDisplayed(autoDisplay);
        }
    }

    public void setNode(Node node) {
        Node oldNode = this.getNode();
        if (node != oldNode) {
            if (oldNode != null) {
                oldNode.removePropertyChangeListener(this._listener);
            }
            if (node != null) {
                node.addPropertyChangeListener(this._listener);
            }
            this.getNodeComponent().setNode(node);
            Dimension d = this.getComponent().getPreferredSize();
            this.__setItemSize(d.width, d.height);
        }
    }

    public Node getNode() {
        return this.getNodeComponent().getNode();
    }

    public NodeComponent getNodeComponent() {
        return (NodeComponent)((Object)this.getContent());
    }

    public Port getPort(double x, double y) {
        Dimension2D size = this.getItemSize();
        Insets i = this.__getBorderInsets();
        if (x < (double)i.left || x >= size.getWidth() - (double)i.right || y < (double)i.top || y >= size.getHeight() - (double)i.bottom || this.isMinimized()) {
            return null;
        }
        Rectangle titleBarBounds = this.__getTitleBarBounds();
        if (y < (double)(titleBarBounds.y + titleBarBounds.height)) {
            return this.getNode();
        }
        Point p = this.__getContentLocation();
        int origin = (int)y - p.y;
        return this.getNodeComponent().getPortAt(origin);
    }

    public void setMinimized(boolean minimized) {
        super.setMinimized(minimized);
        if (minimized && !this._added && this.__getMinimizedComponent() != null) {
            this._addMouseListener(this.__getMinimizedComponent(), this._listener);
            this._added = true;
        }
    }

    public void setContent(Component content) {
        if (!(content instanceof NodeComponent)) {
            throw new IllegalArgumentException("JLENodeWindow only displays NodeComponents");
        }
        super.setContent(content);
    }

    protected NodeComponent createNodeComponent() {
        return new NodeComponent();
    }

    void __updateSize() {
        this.repaintItem();
        Dimension d = this.getComponent().getPreferredSize();
        this.setItemSize(d.width, d.height);
        this.repaintItem();
    }

    private void _addMouseListener(Component c, MouseListener listener) {
        c.addMouseListener(listener);
        if (c instanceof Container) {
            Container cont = (Container)c;
            int count = cont.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this._addMouseListener(cont.getComponent(i), listener);
            }
        }
    }

    private void _unregisterComponents(Component c) {
        if (c instanceof JComponent) {
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)c);
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this._unregisterComponents(cont.getComponent(i));
            }
        }
    }

    private class Listener
    extends KeyAdapter
    implements PropertyChangeListener,
    MouseListener {
        private boolean _pressConsumed = false;

        private Listener() {
        }

        public void mousePressed(MouseEvent e) {
            if (GraphCanvas.__isPopupTrigger(e)) {
                this._pressConsumed = true;
                e.consume();
            } else if (this._pressConsumed) {
                e.consume();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (GraphCanvas.__isPopupTrigger(e)) {
                JLECanvas canvas = JLENodeWindow.this.getCanvas();
                if (canvas instanceof GraphCanvas) {
                    ((GraphCanvas)canvas).__showMenuForNode(JLENodeWindow.this.getNode(), e.getComponent(), e.getX(), e.getY(), JLENodeWindow.this.isMinimized());
                    e.consume();
                }
            } else if (this._pressConsumed) {
                e.consume();
                this._pressConsumed = false;
            }
        }

        public void mouseClicked(MouseEvent e) {
            String command = null;
            if (e.getClickCount() == 1) {
                command = "GraphCanvas.nodeSingleClick";
            } else if (e.getClickCount() % 2 == 0) {
                command = "GraphCanvas.nodeDoubleClick";
            }
            JLECanvas canvas = JLENodeWindow.this.getCanvas();
            if (canvas instanceof GraphCanvas) {
                ((GraphCanvas)canvas).__fireActionEvent(JLENodeWindow.this.getNode(), command, e.getModifiers());
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("nodeExpanded".equals(name)) {
                JLENodeWindow.this.__updateSize();
            } else if ("portSelectionCount".equals(name)) {
                JLECanvas canvas = JLENodeWindow.this.getCanvas();
                if (canvas instanceof GraphCanvas) {
                    ((GraphCanvas)canvas).firePropertyChange("portSelectionCount", e.getOldValue(), e.getNewValue());
                }
            } else if ("displayName".equals(name)) {
                Locale l = LocaleUtils.getDefaultableLocale((Component)JLENodeWindow.this.getContent());
                JLENodeWindow.this.setTitle(JLENodeWindow.this.getNode().getDisplayName(l));
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.getComponent() == JLENodeWindow.this.getComponent() && e.getKeyCode() == 121 && e.isShiftDown()) {
                JLECanvas canvas = JLENodeWindow.this.getCanvas();
                if (canvas instanceof GraphCanvas) {
                    ((GraphCanvas)canvas).__showMenuForNode(JLENodeWindow.this.getNode(), JLENodeWindow.this.__getTitleBar(), 0, 0, JLENodeWindow.this.isMinimized());
                }
                return;
            }
        }
    }
}

