/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.SwingUtilities;

class AccessibleComponentImpl
extends AccessibleContext
implements AccessibleComponent {
    private Component _component;
    private ContainerListener _accessibleContainerHandler;

    public AccessibleComponentImpl(Component component) {
        this._component = component;
        if (this._component instanceof Container) {
            this._accessibleContainerHandler = new AccessibleContainerHandler();
            ((Container)this._component).addContainerListener(this._accessibleContainerHandler);
        }
    }

    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.AWT_COMPONENT;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        return SwingUtilities.getAccessibleStateSet(this.getComponent());
    }

    public Accessible getAccessibleParent() {
        if (this.accessibleParent != null) {
            return this.accessibleParent;
        }
        Container parent = this._component.getParent();
        if (parent instanceof Accessible) {
            return (Accessible)((Object)parent);
        }
        return null;
    }

    public int getAccessibleIndexInParent() {
        return SwingUtilities.getAccessibleIndexInParent(this.getComponent());
    }

    public int getAccessibleChildrenCount() {
        return SwingUtilities.getAccessibleChildrenCount(this.getComponent());
    }

    public Accessible getAccessibleChild(int i) {
        return SwingUtilities.getAccessibleChild(this.getComponent(), i);
    }

    public Locale getLocale() {
        return this._component.getLocale();
    }

    public AccessibleComponent getAccessibleComponent() {
        return this;
    }

    public Color getBackground() {
        return this._component.getBackground();
    }

    public void setBackground(Color c) {
        this._component.setBackground(c);
    }

    public Color getForeground() {
        return this._component.getForeground();
    }

    public void setForeground(Color c) {
        this._component.setForeground(c);
    }

    public Cursor getCursor() {
        Cursor cursor = this._component.getCursor();
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        return cursor;
    }

    public void setCursor(Cursor cursor) {
        this._component.setCursor(cursor);
    }

    public Font getFont() {
        return this._component.getFont();
    }

    public void setFont(Font f) {
        this._component.setFont(f);
    }

    public FontMetrics getFontMetrics(Font f) {
        return this._component.getFontMetrics(f);
    }

    public boolean isEnabled() {
        return this._component.isEnabled();
    }

    public void setEnabled(boolean b) {
        boolean old = this.isEnabled();
        this._component.setEnabled(b);
        if (b != old) {
            this._firePropertyChange(b, AccessibleState.ENABLED);
        }
    }

    public boolean isVisible() {
        return this._component.isVisible();
    }

    public void setVisible(boolean b) {
        boolean old = this.isVisible();
        this._component.setVisible(b);
        if (b != old) {
            this._firePropertyChange(b, AccessibleState.VISIBLE);
        }
    }

    public boolean isShowing() {
        return this._component.isShowing();
    }

    public boolean contains(Point p) {
        return this._component.contains(p);
    }

    public Point getLocationOnScreen() {
        if (this._component.isShowing()) {
            return this._component.getLocationOnScreen();
        }
        return null;
    }

    public Point getLocation() {
        return this._component.getLocation();
    }

    public void setLocation(Point p) {
        this._component.setLocation(p);
    }

    public Rectangle getBounds() {
        return this._component.getBounds();
    }

    public void setBounds(Rectangle r) {
        this._component.setBounds(r);
    }

    public Dimension getSize() {
        return this._component.getSize();
    }

    public void setSize(Dimension d) {
        this._component.setSize(d);
    }

    public Accessible getAccessibleAt(Point p) {
        return SwingUtilities.getAccessibleAt(this.getComponent(), p);
    }

    public boolean isFocusTraversable() {
        return this._component.isFocusTraversable();
    }

    public void requestFocus() {
        this._component.requestFocus();
    }

    public void addFocusListener(FocusListener l) {
        this._component.addFocusListener(l);
    }

    public void removeFocusListener(FocusListener l) {
        this._component.removeFocusListener(l);
    }

    protected Component getComponent() {
        return this._component;
    }

    private void _firePropertyChange(boolean on, Object state) {
        this.firePropertyChange("AccessibleState", on ? null : state, on ? state : null);
    }

    private class AccessibleContainerHandler
    implements ContainerListener {
        private AccessibleContainerHandler() {
        }

        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof Accessible) {
                AccessibleComponentImpl.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)c)).getAccessibleContext());
            }
        }

        public void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof Accessible) {
                AccessibleComponentImpl.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)c)).getAccessibleContext(), null);
            }
        }
    }
}

