/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.db.impl;

import java.util.Locale;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DynamicRelationship;
import oracle.bali.share.util.IntegerUtils;

public final class DynamicRelationshipImpl
extends DynamicRelationship {
    private Column[] _children;
    private Column[] _referenced;
    private String _name;
    private int _type;

    public DynamicRelationshipImpl(Column child, Column referenced, String name) {
        this(child, referenced, name, 0);
    }

    public DynamicRelationshipImpl(Column child, Column referenced, String name, int type) {
        this.setRelationshipType(type);
        this._children = new Column[1];
        this._children[0] = child;
        this._referenced = new Column[1];
        this._referenced[0] = referenced;
        this._name = name;
    }

    public DynamicRelationshipImpl(Column[] children, Column[] referenced, String name) {
        this(children, referenced, name, 0);
    }

    public DynamicRelationshipImpl(Column[] children, Column[] referenced, String name, int type) {
        if (children == null || children.length == 0) {
            throw new IllegalArgumentException("children is empty");
        }
        if (referenced == null || referenced.length == 0) {
            throw new IllegalArgumentException("referenced is empty");
        }
        this.setRelationshipType(type);
        this._children = new Column[children.length];
        System.arraycopy(children, 0, this._children, 0, children.length);
        this._referenced = new Column[referenced.length];
        System.arraycopy(referenced, 0, this._referenced, 0, referenced.length);
        this._name = name;
    }

    public int getColumnCount() {
        return this._children.length;
    }

    public Column getColumn(int index) {
        return this._children[index];
    }

    public Column getReferencedColumn(int index) {
        return this._referenced[index];
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getRelationshipType() {
        return this._type;
    }

    public void setRelationshipType(int type) {
        if (type < 0 || type > 5) {
            throw new IllegalArgumentException("type is incorrect");
        }
        if (this._type != type) {
            Integer old = IntegerUtils.getInteger((int)this._type);
            this._type = type;
            this.firePropertyChange("relationshipType", old, IntegerUtils.getInteger((int)this._type));
        }
    }

    public void addColumn(Column childColumn, Column parentColumn, int index) {
        if (childColumn == null || parentColumn == null) {
            throw new IllegalArgumentException();
        }
        int count = this.getColumnCount();
        if (index < 0 || index >= count) {
            index = count;
        }
        Column[] children = new Column[count + 1];
        Column[] parents = new Column[count + 1];
        if (index != 0) {
            System.arraycopy(this._children, 0, children, 0, index);
            System.arraycopy(this._referenced, 0, parents, 0, index);
        }
        if (index != count) {
            System.arraycopy(this._children, index, children, index + 1, count - index + 1);
            System.arraycopy(this._referenced, index, parents, index + 1, count - index + 1);
        }
        this._children = children;
        this._referenced = parents;
        this._children[index] = childColumn;
        this._referenced[index] = parentColumn;
        this.fireRelationshipEvent(100, childColumn, parentColumn, index);
    }

    public void removeColumn(Column childColumn, Column parentColumn) {
        int index = -1;
        int count = this.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (this.getColumn(i) != childColumn || this.getReferencedColumn(i) != parentColumn) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("columns not found");
        }
        Column[] children = new Column[count - 1];
        Column[] parents = new Column[count - 1];
        if (index != 0) {
            System.arraycopy(this._children, 0, children, 0, index);
            System.arraycopy(this._referenced, 0, parents, 0, index);
        }
        if (index != count - 1) {
            System.arraycopy(this._children, index + 1, children, index, count - index - 1);
            System.arraycopy(this._referenced, index + 1, parents, index, count - index - 1);
        }
        this._children = children;
        this._referenced = parents;
        this.fireRelationshipEvent(101, childColumn, parentColumn, index);
    }

    public String toString() {
        return "DynamicRelationshipImpl: " + this.getName();
    }
}

