/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.db;

import java.util.Locale;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DynamicTable;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.impl.ColumnImpl;

public class TableAlias
extends Table {
    private Table _table;
    private String _displayName;
    private String _name;
    private Column[] _columns;

    public TableAlias(Table table, String name, String displayName) {
        if (table == null || table instanceof DynamicTable) {
            throw new IllegalArgumentException();
        }
        this._table = table;
        this._name = name;
        this._displayName = displayName;
    }

    public Table getTable() {
        return this._table;
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName(Locale locale) {
        return this._displayName;
    }

    public Schema getSchema() {
        return this.getTable().getSchema();
    }

    public int getColumnCount() {
        return this.getTable().getColumnCount();
    }

    public Column getColumn(int index) {
        Column c = this.getTable().getColumn(index);
        if (this._columns == null) {
            this._columns = new Column[this.getColumnCount()];
        }
        if (this._columns[index] == null) {
            this._columns[index] = new ColumnImpl(c.getName(), c.getDisplayName(Locale.getDefault()), c.getDataType(), c.isNullAllowed(), c.getDefaultValue(), this);
        }
        return this._columns[index];
    }

    public int getPrimaryKeyCount() {
        return this.getTable().getPrimaryKeyCount();
    }

    public Column getPrimaryKey(int primaryKeyIndex) {
        return this.getTable().getPrimaryKey(primaryKeyIndex);
    }

    public int getUniqueKeyCount() {
        return this.getTable().getUniqueKeyCount();
    }

    public Column getUniqueKey(int uniqueKeyIndex) {
        return this.getTable().getUniqueKey(uniqueKeyIndex);
    }

    public int getForeignKeyCount() {
        return this.getTable().getForeignKeyCount();
    }

    public Relationship getForeignKey(int foreignKeyIndex) {
        return this.getTable().getForeignKey(foreignKeyIndex);
    }

    public int getExportedKeyCount() {
        return this.getTable().getExportedKeyCount();
    }

    public Relationship getExportedKey(int exportedKeyIndex) {
        return this.getTable().getExportedKey(exportedKeyIndex);
    }
}

