/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintBuilder.AndOrComponent;
import oracle.bali.dbUI.constraintBuilder.CBCompArray;
import oracle.bali.dbUI.constraintBuilder.CBCompComparator;
import oracle.bali.dbUI.constraintBuilder.CBCompTransfer;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderCustomizer;
import oracle.bali.dbUI.constraintBuilder.DragComponent;
import oracle.bali.dbUI.constraintBuilder.ParentComponent;
import oracle.bali.dbUI.constraintBuilder.RootComponent;
import oracle.bali.dbUI.constraintBuilder.TransparentGrayFilter;
import oracle.bali.dbUI.constraintBuilder.TruncateFilter;
import oracle.bali.dbUI.constraintComponent.ConstraintCompFactory;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.util.IntegerUtils;

public class ConstraintBuilder
extends LWComponent
implements Accessible {
    public static final String PROPERTY_SELECTION_COUNT = "selectionCount";
    public static final String PROPERTY_GROUP_DEPTH = "groupDepth";
    public static final String PROPERTY_LEAF_COUNT = "leafCount";
    public static final int DROP_MODE_REPLACE = 1;
    public static final int DROP_MODE_SWAP = 2;
    public Color SELECTION_COLOR = UIManager.getColor("textHighlight");
    public Color DROP_FEEDBACK_COLOR = UIManager.getColor("normalIntensity");
    public final Color DROP_REPLACE_FEEDBACK_COLOR = Color.darkGray;
    protected static final int GROUP_LINE_OFFSET = -1;
    protected static final int GROUP_LINE_DASH_GAP = 1;
    private static final int _MIN_WIDTH = 100;
    private static final int _MIN_HEIGHT = 50;
    static final String _CREATE_AND_COMMAND = "CREATE_AND";
    static final String _CREATE_OR_COMMAND = "CREATE_OR";
    static final String _CREATE_NOT_COMMAND = "CREATE_NOT";
    static final String _CHANGE_TO_AND_COMMAND = "CHANGE_TO_AND";
    static final String _CHANGE_TO_OR_COMMAND = "CHANGE_TO_OR";
    static final String _DELETE_COMMAND = "DELETE";
    static final String _INSERT_COMMAND = "INSERT";
    static final String _ADD_COMMAND = "ADD";
    static final String _SIMPLIFY_COMMAND = "SIMPLIFY";
    static final String _EXPAND_COMMAND = "EXPAND";
    static final String _COLLAPSE_COMMAND = "COLLAPSE";
    static final String _REMOVE_AND_COMMAND = "REMOVE_AND";
    static final String _REMOVE_OR_COMMAND = "REMOVE_OR";
    static final String _REMOVE_NOT_COMMAND = "REMOVE_NOT";
    private static final String _CREATE_AND_KEY = "CREATE_AND";
    private static final String _CREATE_OR_KEY = "CREATE_OR";
    private static final String _CREATE_NOT_KEY = "CREATE_NOT";
    private static final String _CHANGE_TO_AND_KEY = "CHANGE_TO_AND";
    private static final String _CHANGE_TO_OR_KEY = "CHANGE_TO_OR";
    private static final String _SIMPLIFY_KEY = "SIMPLIFY";
    private static final String _ADD_CONSTRAINT_KEY = "ADD_CONSTRAINT";
    private static final String _EXPAND_KEY = "EXPAND";
    private static final String _COLLAPSE_KEY = "COLLAPSE";
    private static final String _DELETE_KEY = "DELETE";
    private static final String _REMOVE_AND_KEY = "REMOVE_AND";
    private static final String _REMOVE_OR_KEY = "REMOVE_OR";
    private static final int _MAX_IMAGE_WIDTH = 150;
    private static final int _VOFFSET = 5;
    private boolean _linesVisible;
    private boolean _alignLeaves;
    private boolean _collapseAllowed;
    private int _x1;
    private int _x2;
    private int _y1;
    private int _y2;
    private int _startCount;
    private int _anchorIndex;
    private DataConstraint _oldConstraint;
    private EWTScrollPane _scrollBox;
    private RootComponent _parent;
    private PropertyChangeListener _listener = new Listen();
    private boolean _autoSimplify;
    private boolean _isDragging;
    private DragComponent _draggingComponent;
    private Vector _selection;
    private ConstraintBuilderComp[] _orderedSelection;
    private boolean _orderedSelectionDirty;
    private ConstraintCompFactory _factory;
    private DataDescriptorProvider _provider;
    private JPopupMenu _menu;
    private ConstraintBuilderCustomizer _customizer;
    private ConstraintBuilderComp _menuComponent;
    private ActionListener _menuListener;
    private int _groupWidth;
    private boolean _groupWidthValid;
    private Vector _leaves;
    private boolean _leafWidthValid;
    private int _leafWidth;
    private int _groupDepth;
    private int _dropMode = 1;
    private boolean _jdkDnD;

    public ConstraintBuilder() {
        this(null);
    }

    public ConstraintBuilder(DataConstraint d) {
        super.setLayout((LayoutManager)new BorderLayout());
        this.setBackground(Color.white);
        this.setOpaque(false);
        this._autoSimplify = false;
        this._parent = this.createRootComponent();
        this._parent.setConstraintBuilder(this);
        this._scrollBox = new EWTScrollPane((Component)((Object)this._parent));
        this.add("Center", (Component)this._scrollBox);
        this._selection = new Vector();
        this._anchorIndex = -1;
        this._x1 = -1;
        this._linesVisible = true;
        this._alignLeaves = true;
        this._leaves = new Vector();
        this.setDataConstraint(d);
        this.registerKeyboardActions();
    }

    public void enableJDKDnD() {
        if (!this._jdkDnD) {
            this._jdkDnD = true;
            this._parent.enableJDKDnD();
            this._enableJDKDnD(this._parent);
        }
    }

    public DataConstraint getDataConstraint() {
        return this._parent.getDataConstraint();
    }

    public void setDataConstraint(DataConstraint constraint) {
        int count = this.getSelectionCount();
        this.clearSelection(false);
        this._oldConstraint = null;
        this.removeAllLeaves();
        this._parent.setDataConstraint(constraint);
        this.tryInvalidateLeafLocation();
        this.trySimplify();
        this._layoutConstraintBuilder();
        this.repaint();
        this._fireSelectionEvent(count, 0);
    }

    public void setConstraintCompFactory(ConstraintCompFactory factory) {
        this._factory = factory;
    }

    public ConstraintCompFactory getConstraintCompFactory() {
        if (this._factory == null) {
            this._factory = ConstraintCompFactory.getConstraintCompFactory();
        }
        return this._factory;
    }

    public void setDataDescriptorProvider(DataDescriptorProvider provider) {
        if (this._provider != provider) {
            this._provider = provider;
        }
    }

    public DataDescriptorProvider getDataDescriptorProvider() {
        return this._provider;
    }

    public ConstraintBuilderCustomizer getCustomizer() {
        return this._customizer;
    }

    public void setCustomizer(ConstraintBuilderCustomizer customizer) {
        if (this._customizer != customizer) {
            this._customizer = customizer;
        }
    }

    public void addConstraintComponent(ConstraintComponent toAdd) {
        this.addLeaf(toAdd);
        DragComponent drag = this.createDragComponent(toAdd);
        drag.setConstraintBuilder(this);
        this._addConstraintBuilderComp(drag, this._parent);
        this.setSelection(drag);
        this.fireDataConstraintChanged();
    }

    public final int getSelectionCount() {
        return this._selection.size();
    }

    public void deleteSelectedComponents() {
        ConstraintBuilderComp[] comps = this.getSelectedComponents();
        int count = comps.length;
        this.freezeRepaints();
        for (int i = 0; i < count; ++i) {
            this.removeConstraintBuilderComp(comps[i]);
        }
        this.trySimplify();
        this._layoutConstraintBuilder();
        this.repaint();
        this.unfreezeRepaints();
        this.fireDataConstraintChanged();
    }

    public final void replaceSelectedComponent(ConstraintComponent component) {
        if (this.getSelectionCount() != 0) {
            ConstraintBuilderComp toReplace = (ConstraintBuilderComp)this._selection.elementAt(0);
            this.replaceConstraintBuilderComp(component, toReplace);
        }
    }

    public final void createAndOrOnSelection(boolean and) {
        this.performCreateAndOr(and, false);
    }

    public final void createNotOnSelection() {
        int count = this._selection.size();
        if (count == 0) {
            return;
        }
        Object[] comps = new ConstraintBuilderComp[count];
        this._selection.copyInto(comps);
        for (int i = 0; i < count; ++i) {
            Object comp = comps[i];
            ((ConstraintBuilderComp)comp).performNot();
        }
        this.trySimplify();
        this._layoutConstraintBuilder();
        this.repaint();
        this.fireDataConstraintChanged();
        ((ConstraintBuilderComp)comps[0]).requestDBUIFocus(false);
    }

    public boolean isAutoSimplifyEnabled() {
        return this._autoSimplify;
    }

    public void setAutoSimplifyEnabled(boolean autoSimplify) {
        if (this._autoSimplify != autoSimplify) {
            this._autoSimplify = autoSimplify;
            if (this._autoSimplify) {
                this.simplifyLayout();
                this.repaint();
            }
        }
    }

    public void simplifyLayout() {
        Component focusedComp = SwingUtilities.findFocusOwner((Component)((Object)this));
        this._simplifyParent(this._parent);
        this._updateIndicies();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        this.repaint();
        this.fireDataConstraintChanged();
        if (focusedComp != null && focusedComp.getPeer() != null) {
            focusedComp.requestFocus();
        }
    }

    public void setGroupLinesVisible(boolean visible) {
        if (this._linesVisible != visible) {
            this._linesVisible = visible;
            this.repaint();
        }
    }

    public boolean isGroupLinesVisible() {
        return this._linesVisible;
    }

    public boolean isAlignLeaves() {
        return this._alignLeaves;
    }

    public void setAlignLeaves(boolean alignLeaves) {
        if (this._alignLeaves != alignLeaves) {
            this._alignLeaves = alignLeaves;
            this._parent.setLeafLocationValid(false);
            this._layoutConstraintBuilder();
            this.repaint();
        }
    }

    public boolean isCollapseAllowed() {
        return this._collapseAllowed;
    }

    public void setCollapseAllowed(boolean collapseAllowed) {
        if (this._collapseAllowed != collapseAllowed) {
            this._collapseAllowed = collapseAllowed;
            if (!this._collapseAllowed) {
                this._setExpanded(this._parent, true);
                this._layoutConstraintBuilder();
                this.repaint();
            }
        }
    }

    public int getDropMode() {
        return this._dropMode;
    }

    public void setDropMode(int mode) {
        if (mode != 2 && mode != 1) {
            throw new IllegalArgumentException("Not a valid argument for drop mode");
        }
        this._dropMode = mode;
    }

    public void replaceConstraintBuilderComp(ConstraintBuilderComp[] items, ConstraintBuilderComp toReplace) {
        ConstraintBuilderComp toDrop = items[0];
        ParentComponent replaceParent = toReplace.getParentComponent();
        ParentComponent dropParent = toDrop.getParentComponent();
        this.freezeRepaints();
        int index = replaceParent.getIndex(toReplace);
        ParentComponent dropSourceParent = dropParent;
        int dropSourceIndex = dropSourceParent.getIndex(toDrop);
        if (this.getDropMode() == 2) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].getConstraintBuilder() == this) continue;
                throw new IllegalArgumentException("Swap not possible: ConstraintBuilderComp does notbelong to this ConstraintBuilder");
            }
        }
        int oldCount = this._selection.size();
        this.clearSelection(false);
        for (int i = 0; i < items.length; ++i) {
            toDrop = items[i];
            dropParent = toDrop.getParentComponent();
            dropParent.removeChild(toDrop);
            replaceParent.addChild(toDrop, index + i);
            this.addToSelection(toDrop, false);
            if (dropParent.getChildCount() != 0 || this.getDropMode() != 1 && (this.getDropMode() != 2 || dropParent == dropSourceParent)) continue;
            this.removeConstraintBuilderComp(dropParent);
        }
        replaceParent.removeChild(toReplace);
        if (this.getDropMode() == 2) {
            dropSourceParent.addChild(toReplace, dropSourceIndex);
        } else {
            this.removeLeaf(((DragComponent)toReplace).getConstraintComponent());
        }
        this.tryInvalidateLeafLocation();
        this.trySimplify();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        this.repaint();
        this._fireSelectionEvent(oldCount, this._selection.size());
        this.fireDataConstraintChanged();
        items[0].requestDBUIFocus(false);
    }

    public void replaceConstraintBuilderComp(ConstraintComponent toDrop, ConstraintBuilderComp toReplace) {
        ParentComponent parent = toReplace.getParentComponent();
        if (parent == null) {
            return;
        }
        this.freezeRepaints();
        this.addLeaf(toDrop);
        DragComponent drag = this.createDragComponent(toDrop);
        drag.setConstraintBuilder(this);
        int index = parent.getIndex(toReplace);
        parent.removeChild(toReplace);
        parent.addChild(drag, index);
        this.removeLeaf(((DragComponent)toReplace).getConstraintComponent());
        this.setSelection(drag);
        this.trySimplify();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        this.repaint();
        this.fireDataConstraintChanged();
        drag.requestDBUIFocus(false);
    }

    public void dropConstraintComponent(ConstraintComponent toDrop, ParentComponent newParent, int index) {
        this.freezeRepaints();
        this.addLeaf(toDrop);
        DragComponent drag = this.createDragComponent(toDrop);
        drag.setConstraintBuilder(this);
        newParent.addChild(drag, index);
        this.setSelection(drag);
        this.trySimplify();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        this.repaint();
        this.fireDataConstraintChanged();
        drag.requestDBUIFocus(false);
    }

    public void dropConstraintBuilderComp(ConstraintBuilderComp[] items, ParentComponent newParent, int index) {
        ConstraintBuilderComp toDrop = items[0];
        ParentComponent parent = toDrop.getParentComponent();
        this.freezeRepaints();
        for (int i = 0; i < items.length; ++i) {
            int dropIndex = index + i;
            toDrop = items[i];
            parent = toDrop.getParentComponent();
            parent.removeChild(toDrop);
            newParent.addChild(toDrop, dropIndex);
            if (parent.getChildCount() != 0) continue;
            this.removeConstraintBuilderComp(parent);
        }
        int oldCount = this._selection.size();
        this.clearSelection(false);
        for (int i = 0; i < items.length; ++i) {
            this.addToSelection(items[i], false);
        }
        this.trySimplify();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        this.repaint();
        this.fireDataConstraintChanged();
        this._fireSelectionEvent(oldCount, this._selection.size());
        items[0].requestDBUIFocus(false);
    }

    public void setSelection(ConstraintBuilderComp comp) {
        this.setSelection(comp, true);
        this._anchorIndex = comp.getIndex();
    }

    public ConstraintBuilderComp parseConstraint(DataConstraint dc) {
        ConstraintBuilderComp comp;
        if (dc instanceof DCBooleanExpression) {
            AndOrComponent andOr = this.createAndOrComponent(true);
            andOr.setConstraintBuilder(this);
            andOr.setDataConstraint(dc);
            comp = andOr;
        } else if (dc instanceof DCUnaryExpression) {
            AndOrComponent andOr = this.createAndOrComponent(true);
            andOr.setConstraintBuilder(this);
            andOr.setDataConstraint(dc);
            comp = andOr;
        } else {
            ConstraintComponent newComp = this.createConstraintComponent(dc);
            this.addLeaf(newComp);
            DragComponent drag = this.createDragComponent(newComp);
            drag.setConstraintBuilder(this);
            comp = drag;
        }
        return comp;
    }

    public int getGroupWidth() {
        if (!this._groupWidthValid) {
            this._groupWidth = this._computeGroupWidth();
            this._groupWidthValid = this._groupWidth != -1;
        }
        return this._groupWidth;
    }

    public void replaceConstraintComponent(ConstraintBuilderComp toAdd, ConstraintComponent toReplace) {
        ConstraintBuilderComp replaceComp = null;
        Container temp = toReplace.getComponent().getParent();
        if (temp == null || !(temp instanceof ConstraintBuilderComp)) {
            return;
        }
        replaceComp = (ConstraintBuilderComp)((Object)temp);
        ParentComponent parent = replaceComp.getParentComponent();
        if (parent == null) {
            return;
        }
        this.freezeRepaints();
        toAdd.setConstraintBuilder(this);
        int index = parent.getIndex(replaceComp);
        parent.removeChild(replaceComp);
        parent.addChild(toAdd, index);
        this.removeLeaf(((DragComponent)replaceComp).getConstraintComponent());
        this.setSelection(toAdd);
        this.trySimplify();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        this.repaint();
        this.fireDataConstraintChanged();
        toAdd.requestDBUIFocus(false);
    }

    public void selectAll() {
        this.freezeRepaints();
        ConstraintBuilderComp[] rootChildren = this._parent.getChildren();
        for (int i = 0; i < rootChildren.length; ++i) {
            this.setSelection(rootChildren[i], i == rootChildren.length - 1);
        }
        this.unfreezeRepaints();
    }

    public void setUI(ComponentUI ui) {
        super.setUI(ui);
        this.SELECTION_COLOR = UIManager.getColor("textHighlight");
        Color drop = UIManager.getColor("normalIntensity");
        if (drop == null) {
            drop = Color.lightGray;
        }
        this.DROP_FEEDBACK_COLOR = drop;
    }

    public void removeAll() {
        this._parent.removeAll();
        this.fireDataConstraintChanged();
        this.invalidate();
    }

    public Dimension getMaximumSize() {
        return this._parent.getMaximumSize();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._parent.setEnabled(enabled);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._groupWidthValid = false;
    }

    protected void paintOverChildren(Graphics g) {
        this._paintSelection(g);
    }

    protected JPopupMenu getMenuForAndOrComponent(boolean andComponent, int childCount, boolean root, boolean isNot, boolean expanded) {
        JPopupMenu menu = this._getEmptyMenu();
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        JMenuItem item = new JMenuItem(b.getString("CREATE_AND"));
        item.setActionCommand("CREATE_AND");
        item.addActionListener(this._menuListener);
        menu.add(item);
        item = new JMenuItem(b.getString("CREATE_OR"));
        item.setActionCommand("CREATE_OR");
        item.addActionListener(this._menuListener);
        menu.add(item);
        item = new JMenuItem(b.getString("CREATE_NOT"));
        item.setActionCommand("CREATE_NOT");
        item.addActionListener(this._menuListener);
        menu.add(item);
        if (!root || root && childCount == 1) {
            if (andComponent) {
                item = new JMenuItem(b.getString("REMOVE_AND"));
                item.setActionCommand("REMOVE_AND");
            } else {
                item = new JMenuItem(b.getString("REMOVE_OR"));
                item.setActionCommand("REMOVE_OR");
            }
            item.addActionListener(this._menuListener);
            menu.add(item);
        }
        item = new JMenuItem(b.getString("DELETE"));
        item.setActionCommand("DELETE");
        item.addActionListener(this._menuListener);
        menu.add(item);
        menu.addSeparator();
        if (andComponent) {
            item = new JMenuItem(b.getString("CHANGE_TO_OR"));
            item.setActionCommand("CHANGE_TO_OR");
            item.addActionListener(this._menuListener);
            menu.add(item);
        } else {
            item = new JMenuItem(b.getString("CHANGE_TO_AND"));
            item.setActionCommand("CHANGE_TO_AND");
            item.addActionListener(this._menuListener);
            menu.add(item);
        }
        item = new JMenuItem(b.getString("SIMPLIFY"));
        item.setActionCommand("SIMPLIFY");
        item.addActionListener(this._menuListener);
        menu.add(item);
        item = new JMenuItem(b.getString(_ADD_CONSTRAINT_KEY));
        item.setActionCommand(_ADD_COMMAND);
        item.addActionListener(this._menuListener);
        menu.add(item);
        if (this.isCollapseAllowed()) {
            if (expanded) {
                item = new JMenuItem(b.getString("COLLAPSE"));
                item.setActionCommand("COLLAPSE");
                item.addActionListener(this._menuListener);
                menu.add(item);
            } else {
                item = new JMenuItem(b.getString("EXPAND"));
                item.setActionCommand("EXPAND");
                item.addActionListener(this._menuListener);
                menu.add(item);
            }
        }
        return menu;
    }

    protected JPopupMenu getMenuForSingleComponent(ConstraintComponent comp, boolean isNot) {
        JPopupMenu menu = this._getEmptyMenu();
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        JMenuItem item = new JMenuItem(b.getString("CREATE_AND"));
        item.setActionCommand("CREATE_AND");
        item.addActionListener(this._menuListener);
        menu.add(item);
        item = new JMenuItem(b.getString("CREATE_OR"));
        item.setActionCommand("CREATE_OR");
        item.addActionListener(this._menuListener);
        menu.add(item);
        item = new JMenuItem(b.getString("CREATE_NOT"));
        item.setActionCommand("CREATE_NOT");
        item.addActionListener(this._menuListener);
        menu.add(item);
        item = new JMenuItem(b.getString("DELETE"));
        item.setActionCommand("DELETE");
        item.addActionListener(this._menuListener);
        menu.add(item);
        return menu;
    }

    protected JPopupMenu getMenuForMultipleSelection(int selectionCount) {
        JPopupMenu menu = this._getEmptyMenu();
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        JMenuItem item = new JMenuItem(b.getString("CREATE_AND"));
        item.setActionCommand("CREATE_AND");
        item.addActionListener(this._menuListener);
        menu.add(item);
        item = new JMenuItem(b.getString("CREATE_OR"));
        item.setActionCommand("CREATE_OR");
        item.addActionListener(this._menuListener);
        menu.add(item);
        item = new JMenuItem(b.getString("CREATE_NOT"));
        item.setActionCommand("CREATE_NOT");
        item.addActionListener(this._menuListener);
        menu.add(item);
        item = new JMenuItem(b.getString("DELETE"));
        item.setActionCommand("DELETE");
        item.addActionListener(this._menuListener);
        menu.add(item);
        return menu;
    }

    protected JPopupMenu getMenuForConstraintBuilder() {
        JPopupMenu menu = this._getEmptyMenu();
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        JMenuItem item = new JMenuItem(b.getString("SIMPLIFY"));
        item.setActionCommand("SIMPLIFY");
        item.addActionListener(this._menuListener);
        item.setEnabled(this._parent.getChildCount() != 0);
        menu.add(item);
        item = new JMenuItem(b.getString(_ADD_CONSTRAINT_KEY));
        item.setActionCommand(_ADD_COMMAND);
        item.addActionListener(this._menuListener);
        menu.add(item);
        return menu;
    }

    protected void layoutChildren() {
        this._parent.layoutChildren();
    }

    protected void paintGroupLines(Graphics g) {
        int count;
        if (this.isGroupLinesVisible() && (count = this.getGroupDepth()) != 0) {
            int x = 0;
            int y = this.getScrollPane().getViewport().getViewPosition().y;
            ImmInsets insets = this.getBorderInsets();
            int height = this.getHeight() + y;
            g.setColor(Color.black);
            for (int i = 0; i < count; ++i) {
                int temp = (x += this.getGroupWidth(i)) + -1;
                for (int j = y; j < height; j += 2) {
                    g.drawLine(temp, j, temp, j);
                }
            }
        }
    }

    protected final int getGroupDepth() {
        return this._groupDepth;
    }

    public final int getLeafCount() {
        return this._leaves.size();
    }

    public final ConstraintComponent[] getLeaves() {
        Object[] leaves = null;
        int count = this._leaves.size();
        if (count > 0) {
            leaves = new ConstraintComponent[count];
            this._leaves.copyInto(leaves);
        }
        return leaves;
    }

    protected final int getGroupWidth(int group) {
        return this._parent.getGroupWidth(group);
    }

    protected final EWTScrollPane getScrollPane() {
        return this._scrollBox;
    }

    protected void leafChanged(ConstraintComponent leaf) {
        if (!leaf.getComponent().isValid()) {
            this._leafWidthValid = false;
            this._layoutConstraintBuilder();
        }
    }

    protected void removeConstraintBuilderComp(ConstraintBuilderComp toRemove) {
        ParentComponent parent = toRemove.getParentComponent();
        if (parent == null) {
            throw new IllegalArgumentException("toRemove not found");
        }
        Component focusedComp = SwingUtilities.findFocusOwner((Component)((Object)this));
        this.removeFromSelection(toRemove);
        parent.removeChild(toRemove);
        toRemove.setConstraintBuilder(null);
        if (toRemove instanceof ParentComponent) {
            this._removeLeaves(((ParentComponent)toRemove).getLeaves());
            toRemove.removeAll();
            this.tryInvalidateLeafLocation();
        } else {
            this.removeLeaf(((DragComponent)toRemove).getConstraintComponent());
        }
        if (parent.getChildCount() == 0 && parent != this._parent) {
            this.removeConstraintBuilderComp(parent);
        }
        if (focusedComp != null && focusedComp.getPeer() != null) {
            focusedComp.requestFocus();
        }
    }

    protected void clearSelection() {
        this.clearSelection(true);
    }

    protected void fireDataConstraintChanged() {
        DataConstraint currentConstraint = this._parent.getDataConstraint();
        this.firePropertyChange("dataConstraint", this._oldConstraint, currentConstraint);
        this._oldConstraint = currentConstraint;
    }

    protected void performCreateAndOr(boolean and, boolean menu) {
        int size = this._selection.size();
        if (size > 1) {
            ConstraintBuilderComp lead = menu ? this._menuComponent : (ConstraintBuilderComp)this._selection.lastElement();
            this._performAndOrOnSelection(lead, and);
        } else if (size == 1) {
            ConstraintBuilderComp comp = (ConstraintBuilderComp)this._selection.firstElement();
            this._createConstraintGroup(comp, and);
        }
    }

    protected void performRemoveParent() {
        int i;
        ParentComponent comp = (ParentComponent)this._selection.firstElement();
        ParentComponent parent = comp.getParentComponent();
        int index = parent.getIndex(comp);
        parent.removeChild(comp);
        ConstraintBuilderComp[] children = comp.getChildren();
        comp.removeAll();
        for (i = 0; i < children.length; ++i) {
            parent.addChild(children[i], index + i);
        }
        this.clearSelection(false);
        for (i = 0; i < children.length; ++i) {
            this.addToSelection(children[i]);
        }
        this.trySimplify();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        this.repaint();
        this.fireDataConstraintChanged();
        children[0].requestDBUIFocus(false);
    }

    protected void performAdd() {
        DragComponent drag = this.createNewComponent();
        ParentComponent comp = this._selection.size() == 0 ? this._parent : (ParentComponent)this._selection.firstElement();
        this._addConstraintBuilderComp(drag, comp);
        this.fireDataConstraintChanged();
    }

    protected void addLeaf(ConstraintComponent comp) {
        int oldCount = this._leaves.size();
        this._leaves.addElement(comp);
        comp.addPropertyChangeListener(this._listener);
        this._leafWidthValid = false;
        this._fireIntegerEvent(PROPERTY_LEAF_COUNT, oldCount, this._leaves.size());
    }

    protected void removeLeaf(ConstraintComponent comp) {
        int oldCount = this._leaves.size();
        this._leaves.removeElement(comp);
        comp.removePropertyChangeListener(this._listener);
        this._leafWidthValid = false;
        this._fireIntegerEvent(PROPERTY_LEAF_COUNT, oldCount, this._leaves.size());
    }

    protected void removeAllLeaves() {
        int count = this._leaves.size();
        if (count > 0) {
            Object[] leaves = new ConstraintComponent[count];
            this._leaves.copyInto(leaves);
            this._removeLeaves((ConstraintComponent[])leaves);
        }
    }

    protected void registerKeyboardActions() {
        Key listener = new Key();
        KeyStroke key = KeyStroke.getKeyStroke(8, 0);
        this.registerKeyboardAction(listener, "DELETE", key, 1);
        key = KeyStroke.getKeyStroke(127, 0);
        this.registerKeyboardAction(listener, "DELETE", key, 1);
        key = KeyStroke.getKeyStroke(155, 0);
        this.registerKeyboardAction(listener, _INSERT_COMMAND, key, 1);
    }

    protected DragComponent createDragComponent(ConstraintComponent dragged) {
        DragComponent drag = new DragComponent(dragged);
        if (this._jdkDnD) {
            drag.enableJDKDnD();
        }
        return drag;
    }

    protected AndOrComponent createAndOrComponent(boolean isAnd) {
        AndOrComponent andOr = new AndOrComponent(isAnd);
        if (this._jdkDnD) {
            andOr.enableJDKDnD();
        }
        return andOr;
    }

    protected DragComponent createDragComponent(ParentComponent parent, LWComponent child) {
        DragComponent drag = new DragComponent(parent, child);
        if (this._jdkDnD) {
            drag.enableJDKDnD();
        }
        return drag;
    }

    protected RootComponent createRootComponent() {
        RootComponent root = new RootComponent();
        return root;
    }

    protected final ConstraintBuilderComp[] getSelectedComponents() {
        int count = this._selection.size();
        Object[] comps = new ConstraintBuilderComp[count];
        this._selection.copyInto(comps);
        return comps;
    }

    protected final ParentComponent getRootComponent() {
        return this._parent;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleConstraintBuilder();
        }
        return this.accessibleContext;
    }

    ConstraintComponent createConstraintComponent(DataConstraint constraint) {
        DataDescriptorProvider provider = this.getDataDescriptorProvider();
        ConstraintCompFactory factory = this.getConstraintCompFactory();
        return factory.createConstraintComponent(provider, null, constraint);
    }

    ConstraintComponent createConstraintComponent(DataDescriptor descriptor) {
        DataDescriptorProvider provider = this.getDataDescriptorProvider();
        ConstraintCompFactory factory = this.getConstraintCompFactory();
        return factory.createConstraintComponent(provider, descriptor, null);
    }

    void tryRequestFocus() {
        if (!this.isAncestorOf(SwingUtilities.findFocusOwner((Component)((Object)this)))) {
            this._parent.requestDBUIFocus(false);
        }
    }

    void startDragSelection(ParentComponent parent, int x, int y) {
        Point offset = this._getOffset((Component)((Object)parent));
        this._x1 = x + offset.x;
        this._y1 = y + offset.y;
        this._x2 = -1;
        this._y2 = -1;
        this._startCount = this._selection.size();
    }

    void continueDragSelection(ParentComponent parent, int x, int y) {
        Point offset = this._getOffset((Component)((Object)parent));
        this._x2 = x + offset.x;
        this._y2 = y + offset.y;
        this._parent.freezeRepaints();
        this._updateSelection();
        this.repaint();
        this._parent.unfreezeRepaints();
    }

    void finishDragSelection(ParentComponent parent, int x, int y) {
        this._parent.freezeRepaints();
        this._updateSelection();
        this._x1 = -1;
        this.repaint();
        this._parent.unfreezeRepaints();
        int finishCount = this._selection.size();
        this._fireSelectionEvent(this._startCount, finishCount);
    }

    void addToSelection(ConstraintBuilderComp comp) {
        if (this._anchorIndex == -1) {
            this._anchorIndex = comp.getIndex();
            this.addToSelection(comp, true);
        } else {
            this._setSelection(comp.getIndex(), this._anchorIndex);
        }
    }

    void addToSelection(ConstraintBuilderComp comp, boolean sendEvent) {
        if (this._selection.indexOf(comp) == -1 && comp.isEnabled() && !comp.isSelected()) {
            this._orderedSelectionDirty = true;
            int oldCount = this._selection.size();
            this._selection.addElement(comp);
            comp.setSelected(true);
            int newCount = this._selection.size();
            if (sendEvent) {
                this._fireSelectionEvent(oldCount, newCount);
            }
        }
    }

    void removeFromSelection(ConstraintBuilderComp comp) {
        this.removeFromSelection(comp, false);
    }

    void removeFromSelection(ConstraintBuilderComp comp, boolean sendEvent) {
        if (this._selection.indexOf(comp) != -1) {
            this._orderedSelectionDirty = true;
            int oldValue = this._selection.size();
            this._selection.removeElement(comp);
            comp.setSelected(false);
            int newValue = this._selection.size();
            if (sendEvent) {
                this._fireSelectionEvent(oldValue, newValue);
            }
        }
    }

    void toggleSelection(ConstraintBuilderComp comp) {
        if (!comp.isEnabled()) {
            return;
        }
        this._anchorIndex = comp.getIndex();
        int index = this._selection.indexOf(comp);
        boolean selected = comp.isSelected();
        if (selected && index == -1) {
            return;
        }
        int oldCount = this._selection.size();
        if (index == -1) {
            this._selection.addElement(comp);
            selected = true;
        } else {
            this._selection.removeElementAt(index);
            selected = false;
        }
        this._orderedSelectionDirty = true;
        comp.setSelected(selected);
        int newCount = this._selection.size();
        this._fireSelectionEvent(oldCount, newCount);
    }

    boolean isSelected(ConstraintBuilderComp c) {
        for (int i = 0; i < this._selection.size(); ++i) {
            if (c != this._selection.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    void clearSelection(boolean sendEvent) {
        this.setSelection(null, sendEvent);
        this._anchorIndex = -1;
    }

    void setSelection(ConstraintBuilderComp comp, boolean sendEvent) {
        int oldCount = this._selection.size();
        for (int i = 0; i < this._selection.size(); ++i) {
            ConstraintBuilderComp temp = (ConstraintBuilderComp)this._selection.elementAt(i);
            if (temp == comp) continue;
            temp.setSelected(false);
        }
        this._selection.removeAllElements();
        if (comp != null && comp.isEnabled()) {
            this._selection.addElement(comp);
            comp.setSelected(true);
        }
        this._orderedSelectionDirty = true;
        int newCount = this._selection.size();
        if (sendEvent) {
            this._fireSelectionEvent(oldCount, newCount);
        }
    }

    boolean canDrag(ConstraintBuilderComp comp) {
        return this._parent.getChildCount() == 1 && this._parent.getChild(0) != comp;
    }

    void showMenu(ParentComponent parent, boolean drag, int x, int y) {
        JPopupMenu menu = null;
        if (!drag) {
            this._menuComponent = null;
            this.clearSelection();
            this.paintImmediateInterior();
            menu = this._getMenuForConstraintBuilder();
        } else {
            int count = this.getSelectionCount();
            if (count > 1) {
                menu = this._getMenuForMultipleSelection(count);
                this._menuComponent = (ConstraintBuilderComp)this._selection.elementAt(0);
            } else if (count == 1) {
                ParentComponent p;
                ConstraintBuilderComp comp;
                this._menuComponent = comp = (ConstraintBuilderComp)this._selection.elementAt(0);
                if (comp instanceof DragComponent) {
                    DragComponent d = (DragComponent)comp;
                    ConstraintComponent c = d.getConstraintComponent();
                    menu = this._getMenuForSingleComponent(c, false);
                } else if (comp instanceof ParentComponent && (p = (ParentComponent)comp) instanceof AndOrComponent) {
                    AndOrComponent andOr = (AndOrComponent)p;
                    ParentComponent temp = andOr.getParentComponent();
                    boolean root = temp == this._parent;
                    boolean not = andOr.isNot();
                    menu = this._getMenuForAndOrComponent(andOr.isAnd(), andOr.getChildCount(), root, not, andOr.isExpanded());
                }
            }
        }
        if (menu != null) {
            Point p = this._getOffset((Component)((Object)parent));
            DBUILookAndFeel.getLookAndFeel().popupMenu((Component)((Object)this), menu, x + p.x, y + p.y);
        }
    }

    void showMenu(ConstraintBuilderComp comp, int x, int y) {
        if (!this.isSelected(comp) && !(comp instanceof RootComponent)) {
            this.setSelection(comp);
        }
        comp.requestDBUIFocus(false);
        this._menuComponent = comp;
        this.paintImmediateInterior();
        JPopupMenu menu = this._getMenuForComponent(comp);
        if (menu != null) {
            Point p = this._getOffset((Component)((Object)comp));
            DBUILookAndFeel.getLookAndFeel().popupMenu((Component)((Object)this), menu, x + p.x, y + p.y);
        }
    }

    void performAndOr(boolean and) {
        ConstraintBuilderComp comp = (ConstraintBuilderComp)this._selection.firstElement();
        if (comp instanceof AndOrComponent) {
            AndOrComponent andOr;
            andOr.setAnd(!(andOr = (AndOrComponent)comp).isAnd());
            this.paintImmediateInterior();
            this.trySimplify();
            this._layoutConstraintBuilder();
            this.repaint();
        }
        this.fireDataConstraintChanged();
    }

    void performSimplify() {
        int count = this._selection.size();
        Component focusedComp = SwingUtilities.findFocusOwner((Component)((Object)this));
        if (count == 0) {
            this._simplifyParent(this._parent);
        } else {
            ParentComponent comp = (ParentComponent)this._selection.firstElement();
            this._simplifyParent(comp);
        }
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        this.repaint();
        this.fireDataConstraintChanged();
        if (focusedComp != null && focusedComp.getPeer() != null) {
            focusedComp.requestFocus();
        }
    }

    void performExpand(boolean expand) {
        ParentComponent comp = (ParentComponent)this._selection.firstElement();
        comp.setExpanded(expand);
    }

    void trySimplify() {
        if (this.isAutoSimplifyEnabled()) {
            this.simplifyLayout();
        } else {
            this._updateIndicies();
        }
    }

    DragComponent createNewComponent() {
        ConstraintComponent newComp = this.createConstraintComponent((DataConstraint)null);
        this.addLeaf(newComp);
        DragComponent drag = this.createDragComponent(newComp);
        drag.setConstraintBuilder(this);
        return drag;
    }

    void setDragging(DragComponent comp, boolean isDragging) {
        this._isDragging = isDragging;
        this._draggingComponent = comp;
    }

    boolean isDragging() {
        return this._isDragging;
    }

    Image getDragImage() {
        Image image;
        int width = 0;
        int height = 0;
        Dimension size = null;
        if (this._orderedSelectionDirty) {
            this._orderSelection();
        }
        int count = this._orderedSelection.length;
        for (int i = 0; i < count; ++i) {
            size = this._orderedSelection[i].getSize();
            if (size.width > width) {
                width = size.width;
            }
            height += size.height + 5;
        }
        height -= 5;
        if (width > 150) {
            width = 150;
        }
        if ((image = this.createImage(width, height)) != null) {
            Graphics g = image.getGraphics();
            g.setColor(this._parent.getBackground());
            g.fillRect(0, 0, width, height);
            for (int i = 0; i < count; ++i) {
                ConstraintBuilderComp content = this._orderedSelection[i];
                size = ((Component)((Object)content)).getSize();
                g.setClip(0, 0, width, size.height);
                g.setColor(((Component)((Object)content)).getBackground());
                g.fillRect(0, 0, width, size.height);
                g.setColor(((Component)((Object)content)).getForeground());
                g.setFont(((Component)((Object)content)).getFont());
                ((Component)((Object)content)).paint(g);
                g.translate(0, size.height + 5);
            }
            TruncateFilter f1 = new TruncateFilter(width, height);
            image = DBUILookAndFeel.createFilteredImage(image, f1);
            TransparentGrayFilter f2 = new TransparentGrayFilter(this._parent.getBackground(), true);
            image = DBUILookAndFeel.createFilteredImage(image, f2);
        }
        return image;
    }

    Transferable getDragTransferable() {
        if (this._orderedSelectionDirty) {
            this._orderSelection();
        }
        int count = this._orderedSelection.length;
        ConstraintBuilderComp[] array = new ConstraintBuilderComp[count];
        for (int i = 0; i < count; ++i) {
            array[i] = this._orderedSelection[i];
        }
        return new CBCompTransfer(new CBCompArray(array));
    }

    final int getLeafWidth() {
        if (!this._leafWidthValid) {
            this._leafWidth = this._computeLeafWidth();
            this._leafWidthValid = true;
        }
        return this._leafWidth;
    }

    private final int _computeGroupWidth() {
        return DragComponent.getGroupWidth(this.getPaintContext());
    }

    private final int _computeLeafWidth() {
        int max = 0;
        int count = this._leaves.size();
        for (int i = 0; i < count; ++i) {
            ConstraintComponent comp = (ConstraintComponent)this._leaves.elementAt(i);
            int temp = comp.getComponent().getPreferredSize().width;
            if (temp <= max) continue;
            max = temp;
        }
        return max;
    }

    private void _removeLeaves(ConstraintComponent[] comps) {
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                this.removeLeaf(comps[i]);
            }
        }
    }

    private JPopupMenu _getMenuForAndOrComponent(boolean andComponent, int childCount, boolean root, boolean isParentNot, boolean expanded) {
        ConstraintBuilderCustomizer c;
        JPopupMenu menu = this.getMenuForAndOrComponent(andComponent, childCount, root, isParentNot, expanded);
        if (menu != null && (c = this.getCustomizer()) != null) {
            Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
            c.customizeMenuForAndOrComponent(menu, locale, andComponent, childCount, root, isParentNot, expanded);
            if (menu.getComponentCount() == 0) {
                menu = null;
            }
        }
        return menu;
    }

    private JPopupMenu _getMenuForSingleComponent(ConstraintComponent comp, boolean parentNot) {
        ConstraintBuilderCustomizer c;
        JPopupMenu menu = this.getMenuForSingleComponent(comp, parentNot);
        if (menu != null && (c = this.getCustomizer()) != null) {
            Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
            c.customizeMenuForSingleComponent(menu, locale, comp, parentNot);
            if (menu.getComponentCount() == 0) {
                menu = null;
            }
        }
        return menu;
    }

    private JPopupMenu _getMenuForMultipleSelection(int selectionCount) {
        ConstraintBuilderCustomizer c;
        JPopupMenu menu = this.getMenuForMultipleSelection(selectionCount);
        if (menu != null && (c = this.getCustomizer()) != null) {
            Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
            c.customizeMenuForMultipleSelection(menu, locale, selectionCount);
            if (menu.getComponentCount() == 0) {
                menu = null;
            }
        }
        return menu;
    }

    private JPopupMenu _getMenuForConstraintBuilder() {
        ConstraintBuilderCustomizer c;
        JPopupMenu menu = this.getMenuForConstraintBuilder();
        if (menu != null && (c = this.getCustomizer()) != null) {
            Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
            c.customizeMenuForConstraintBuilder(menu, locale);
            if (menu.getComponentCount() == 0) {
                menu = null;
            }
        }
        return menu;
    }

    private void _setSelection(int index1, int index2) {
        ConstraintBuilderComp temp;
        int i;
        int end;
        int start;
        if (index1 < index2) {
            start = index1;
            end = index2;
        } else {
            start = index2;
            end = index1;
        }
        this._orderedSelectionDirty = true;
        int oldCount = this._selection.size();
        for (i = 0; i < oldCount; ++i) {
            temp = (ConstraintBuilderComp)this._selection.elementAt(i);
            int tempIndex = temp.getIndex();
            if (tempIndex >= start && tempIndex <= end) continue;
            temp.setSelected(false);
        }
        this._selection.removeAllElements();
        for (i = start; i <= end; ++i) {
            temp = this._getComponent(i);
            temp.setSelected(true);
            this._selection.addElement(temp);
        }
        int newCount = this._selection.size();
        this._fireSelectionEvent(oldCount, newCount);
    }

    private void _fireSelectionEvent(int oldCount, int newCount) {
        this._fireIntegerEvent(PROPERTY_SELECTION_COUNT, oldCount, newCount);
    }

    private void _fireIntegerEvent(String event, int oldCount, int newCount) {
        if (oldCount != newCount) {
            Integer old = IntegerUtils.getInteger((int)oldCount);
            Integer newVal = IntegerUtils.getInteger((int)newCount);
            this.firePropertyChange(event, old, newVal);
        }
    }

    private ConstraintBuilderComp _getComponent(int index) {
        return this._getComponent(this._parent, index);
    }

    private ConstraintBuilderComp _getComponent(ConstraintBuilderComp comp, int index) {
        if (comp.getIndex() == index) {
            return comp;
        }
        if (comp instanceof ParentComponent) {
            ParentComponent parent = (ParentComponent)comp;
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                comp = this._getComponent(parent.getChild(i), index);
                if (comp == null) continue;
                return comp;
            }
        }
        return null;
    }

    private void _orderSelection() {
        int count = this._selection.size();
        this._orderedSelection = new ConstraintBuilderComp[count];
        this._selection.copyInto(this._orderedSelection);
        Sort.qSort((Object[])this._orderedSelection, (int)count, (Comparator)CBCompComparator.getComparator());
        this._orderedSelectionDirty = false;
    }

    private void _updateIndicies() {
        int dummy = this._updateIndex(this._parent, 0);
        this._anchorIndex = -1;
    }

    private int _updateIndex(ConstraintBuilderComp comp, int index) {
        comp.setIndex(index);
        if (comp instanceof ParentComponent) {
            ParentComponent parent = (ParentComponent)comp;
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                index = this._updateIndex(parent.getChild(i), index + 1);
            }
        }
        return index;
    }

    private void _updateSelection() {
        int bottom;
        int top;
        int right;
        int left;
        if (this._x2 == -1) {
            return;
        }
        if (this._x2 < this._x1) {
            left = this._x2;
            right = this._x1;
        } else {
            left = this._x1;
            right = this._x2;
        }
        if (this._y2 < this._y1) {
            top = this._y2;
            bottom = this._y1;
        } else {
            top = this._y1;
            bottom = this._y2;
        }
        int width = right - left + 1;
        int height = bottom - top + 1;
        this.freezeRepaints();
        this._parent.updateSelection(left, top, width, height);
        this.unfreezeRepaints();
        this.paintImmediateInterior();
    }

    private void _paintSelection(Graphics g) {
        if (this._x1 == -1 || this._x2 == -1) {
            return;
        }
        g.setColor(this.getForeground());
        g.setXORMode(this.getBackground());
        g.drawLine(this._x1, this._y1, this._x1, this._y2);
        g.drawLine(this._x1, this._y2, this._x2, this._y2);
        g.drawLine(this._x2, this._y2, this._x2, this._y1);
        g.drawLine(this._x2, this._y1, this._x1, this._y1);
        g.setPaintMode();
    }

    private void _createConstraintGroup(ConstraintBuilderComp child, boolean andGroup) {
        ParentComponent parent = child.getParentComponent();
        if (parent == null) {
            throw new IllegalArgumentException("parent not found.");
        }
        Component focusedComp = SwingUtilities.findFocusOwner((Component)((Object)this));
        DragComponent drag = this.createNewComponent();
        int index = parent.getIndex(child);
        parent.removeChild(child);
        AndOrComponent andOrChild = this.createAndOrComponent(andGroup);
        andOrChild.setConstraintBuilder(this);
        andOrChild.addChild(child);
        andOrChild.addChild(drag);
        parent.addChild(andOrChild, index);
        this.setSelection(andOrChild);
        this.trySimplify();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        this.validate();
        parent.scrollRectToVisible(andOrChild.getBounds());
        this.fireDataConstraintChanged();
        if (focusedComp != null) {
            focusedComp.requestFocus();
        }
    }

    private void _addConstraintBuilderComp(ConstraintBuilderComp toAdd, ParentComponent parent) {
        parent.addChild(toAdd);
        this.trySimplify();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        this.validate();
        parent.scrollRectToVisible(toAdd.getBounds());
    }

    private void _enableJDKDnD(ParentComponent parent) {
        int childCount = parent.getChildCount();
        ConstraintBuilderComp[] children = parent.getChildren();
        for (int i = 0; i < childCount; ++i) {
            ConstraintBuilderComp child = children[i];
            if (child instanceof ParentComponent) {
                this._enableJDKDnD((ParentComponent)child);
                ((ParentComponent)child).enableJDKDnD();
                continue;
            }
            if (!(child instanceof DragComponent)) continue;
            ((DragComponent)child).enableJDKDnD();
        }
    }

    private void _simplifyParent(ParentComponent parent) {
        ConstraintBuilderComp child;
        if (parent == null) {
            return;
        }
        this.freezeRepaints();
        int childCount = parent.getChildCount();
        ConstraintBuilderComp[] children = parent.getChildren();
        for (int i = 0; i < childCount; ++i) {
            child = children[i];
            if (!(child instanceof ParentComponent)) continue;
            this._simplifyParent((ParentComponent)child);
        }
        if (!(parent instanceof RootComponent) && parent instanceof AndOrComponent) {
            AndOrComponent andOrParent = (AndOrComponent)parent;
            int count = andOrParent.getChildCount();
            ParentComponent tempParent = andOrParent.getParentComponent();
            switch (count) {
                case 0: {
                    tempParent.removeChild(andOrParent);
                    break;
                }
                case 1: {
                    int index = tempParent.getIndex(andOrParent);
                    tempParent.removeChild(andOrParent);
                    child = andOrParent.getChild(0);
                    andOrParent.removeChild(child);
                    tempParent.addChild(child);
                    break;
                }
                default: {
                    children = andOrParent.getChildren();
                    for (int i = 0; i < children.length; ++i) {
                        child = children[i];
                        if (!(child instanceof AndOrComponent)) continue;
                        AndOrComponent andOrChild = (AndOrComponent)child;
                        if (andOrParent.isAnd() != andOrChild.isAnd() || andOrParent.isNot() != andOrChild.isNot()) continue;
                        ConstraintBuilderComp[] newChildren = andOrChild.getChildren();
                        int index = andOrParent.getIndex(andOrChild);
                        andOrChild.removeAll();
                        andOrParent.removeChild(andOrChild);
                        boolean removeSelected = this.isSelected(andOrChild);
                        int oldValue = this._selection.size();
                        if (removeSelected) {
                            this.removeFromSelection(andOrChild, false);
                        }
                        for (int j = 0; j < newChildren.length; ++j) {
                            andOrParent.addChild(newChildren[j], index + j);
                            if (!removeSelected) continue;
                            this.addToSelection(newChildren[j], false);
                        }
                        if (!removeSelected) continue;
                        this._fireSelectionEvent(oldValue, this._selection.size());
                    }
                }
            }
        }
        this.unfreezeRepaints();
    }

    private JPopupMenu _getEmptyMenu() {
        if (this._menuListener == null) {
            this._menuListener = new Menus();
        }
        this._menu = new JPopupMenu();
        return this._menu;
    }

    private JPopupMenu _getMenuForComponent(ConstraintBuilderComp component) {
        boolean multiSelect;
        JPopupMenu menu = null;
        int selectionCount = this._selection.size();
        boolean bl = multiSelect = selectionCount > 1;
        if (multiSelect) {
            menu = this._getMenuForMultipleSelection(selectionCount);
        } else if (component instanceof ParentComponent) {
            ParentComponent parent = (ParentComponent)component;
            if (parent instanceof AndOrComponent) {
                AndOrComponent andOr = (AndOrComponent)component;
                ParentComponent temp = andOr.getParentComponent();
                boolean root = temp == this._parent;
                boolean not = andOr.isNot();
                menu = this._getMenuForAndOrComponent(andOr.isAnd(), andOr.getChildCount(), root, not, andOr.isExpanded());
            } else if (parent instanceof RootComponent) {
                menu = this._getMenuForConstraintBuilder();
            }
        } else if (component instanceof DragComponent) {
            DragComponent d = (DragComponent)component;
            boolean parentNot = d.getParentComponent() instanceof AndOrComponent ? ((AndOrComponent)d.getParentComponent()).isNot() : false;
            menu = this._getMenuForSingleComponent(d.getConstraintComponent(), parentNot);
        }
        return menu;
    }

    private Point _getOffset(Component comp) {
        int offsetX = 0;
        int offsetY = 0;
        for (Component parent = comp; parent != null && parent != this; parent = parent.getParent()) {
            Point p = parent.getLocation();
            offsetX += p.x;
            offsetY += p.y;
        }
        return new Point(offsetX, offsetY);
    }

    private void _performAndOrOnSelection(ConstraintBuilderComp leadChild, boolean and) {
        int count = this._selection.size();
        if (leadChild == null || count == 0) {
            return;
        }
        Component focusedComp = SwingUtilities.findFocusOwner((Component)((Object)this));
        ParentComponent parent = leadChild.getParentComponent();
        Object[] comps = new ConstraintBuilderComp[count];
        this._selection.copyInto(comps);
        this.freezeRepaints();
        for (int i = 0; i < count; ++i) {
            ParentComponent parentComp;
            if (comps[i] == leadChild || (parentComp = ((ConstraintBuilderComp)comps[i]).getParentComponent()) == null) continue;
            parentComp.removeChild((ConstraintBuilderComp)comps[i]);
        }
        int index = parent.getIndex(leadChild);
        parent.removeChild(leadChild);
        AndOrComponent andOr = this.createAndOrComponent(and);
        andOr.setConstraintBuilder(this);
        for (int i = 0; i < count; ++i) {
            andOr.addChild((ConstraintBuilderComp)comps[i]);
        }
        parent.addChild(andOr, index);
        this.setSelection(andOr);
        this.trySimplify();
        this.tryInvalidateLeafLocation();
        this._layoutConstraintBuilder();
        this.unfreezeRepaints();
        this.validate();
        parent.scrollRectToVisible(andOr.getBounds());
        this.fireDataConstraintChanged();
        if (focusedComp != null) {
            focusedComp.requestFocus();
        }
    }

    private void _layoutConstraintBuilder() {
        this._parent.revalidate();
        this._scrollBox.revalidate();
    }

    void tryInvalidateLeafLocation() {
        int count = this._parent.getGroupDepth();
        if (this._groupDepth != count) {
            int oldCount = this._groupDepth;
            this._groupDepth = count;
            this._fireIntegerEvent(PROPERTY_GROUP_DEPTH, oldCount, this._groupDepth);
        }
        this._parent.setLeafLocationValid(false);
    }

    private void _setExpanded(ParentComponent parent, boolean expanded) {
        parent.setExpanded(expanded);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            ConstraintBuilderComp child = parent.getChild(i);
            if (!(child instanceof ParentComponent)) continue;
            this._setExpanded((ParentComponent)child, expanded);
        }
    }

    private class AccessibleConstraintBuilder
    extends JComponent.AccessibleJComponent {
        public AccessibleConstraintBuilder() {
            super((JComponent)((Object)ConstraintBuilder.this));
            ConstraintBuilder.this._parent.getAccessibleContext().setAccessibleParent(ConstraintBuilder.this);
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return ConstraintBuilder.this._parent;
        }
    }

    protected class Key
    implements ActionListener {
        protected Key() {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if ("DELETE".equals(cmd)) {
                ConstraintBuilder.this.deleteSelectedComponents();
            } else if (ConstraintBuilder._INSERT_COMMAND.equals(cmd)) {
                ConstraintComponent component = ConstraintBuilder.this.createConstraintComponent((DataConstraint)null);
                ConstraintBuilder.this.addConstraintComponent(component);
            }
        }
    }

    private class Listen
    implements PropertyChangeListener {
        private Listen() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            ConstraintBuilder.this.fireDataConstraintChanged();
            ConstraintBuilder.this.leafChanged((ConstraintComponent)e.getSource());
            ConstraintBuilder.this.repaint();
        }
    }

    private class Menus
    implements ActionListener {
        private Menus() {
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if ("CHANGE_TO_AND".equals(cmd)) {
                ConstraintBuilder.this.performAndOr(true);
            } else if ("CHANGE_TO_OR".equals(cmd)) {
                ConstraintBuilder.this.performAndOr(false);
            } else if ("CREATE_AND".equals(cmd)) {
                ConstraintBuilder.this.performCreateAndOr(true, true);
            } else if ("CREATE_OR".equals(cmd)) {
                ConstraintBuilder.this.performCreateAndOr(false, true);
            } else if ("CREATE_NOT".equals(cmd)) {
                ConstraintBuilder.this.createNotOnSelection();
            } else if ("DELETE".equals(cmd)) {
                ConstraintBuilder.this.deleteSelectedComponents();
            } else if (ConstraintBuilder._ADD_COMMAND.equals(cmd)) {
                ConstraintBuilder.this.performAdd();
            } else if ("SIMPLIFY".equals(cmd)) {
                ConstraintBuilder.this.performSimplify();
            } else if ("EXPAND".equals(cmd)) {
                ConstraintBuilder.this.performExpand(true);
            } else if ("COLLAPSE".equals(cmd)) {
                ConstraintBuilder.this.performExpand(false);
            } else if ("REMOVE_AND".equals(cmd)) {
                ConstraintBuilder.this.performRemoveParent();
            } else if ("REMOVE_OR".equals(cmd)) {
                ConstraintBuilder.this.performRemoveParent();
            } else if (ConstraintBuilder._REMOVE_NOT_COMMAND.equals(cmd)) {
                ConstraintBuilder.this.performRemoveParent();
            }
        }
    }
}

