/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.plugin;

import antlr.CommonAST;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TreeParser;
import antlr.collections.AST;
import antlr.collections.impl.BitSet;
import antlr.debug.misc.ASTFrame;
import java.io.CharArrayReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.parser.Messages;
import oracle.dbtools.migration.parser.analysis.TranslationAnalysisResult;
import oracle.dbtools.migration.parser.defaults.DefaultVariabletNameTranslator;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.ext.ExtAutoIndentWriter;
import oracle.dbtools.migration.parser.ext.ExtStringTemplate;
import oracle.dbtools.migration.parser.ext.ExtTreeParser;
import oracle.dbtools.migration.parser.ext.RosettaLexer;
import oracle.dbtools.migration.parser.ext.RosettaRecognizer;
import oracle.dbtools.migration.parser.filter.FaultTolleranceFilter;
import oracle.dbtools.migration.parser.filter.KeywordCaseConversionFilter;
import oracle.dbtools.migration.parser.filter.comments.Comment;
import oracle.dbtools.migration.parser.filter.comments.CommentHelper;
import oracle.dbtools.migration.parser.filter.comments.CommentTokenFilter;
import oracle.dbtools.migration.parser.filter.highlighting.HighLightingBlock;
import oracle.dbtools.migration.parser.filter.highlighting.HighlightingBlockFilter;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.parser.internalapi.IFoldingBlock;
import oracle.dbtools.migration.parser.internalapi.ISyntaxHighlightingBlock;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.parser.internalapi.ITranslationAnalysisResult;
import oracle.dbtools.migration.parser.internalapi.ITranslationDiffBlock;
import oracle.dbtools.migration.parser.internalapi.IVisitor;
import oracle.dbtools.migration.parser.internalapi.IVisitorResult;
import oracle.dbtools.migration.parser.internalapi.TranslateResultWithASTs;
import oracle.dbtools.migration.parser.log.TranslationMessages;
import oracle.dbtools.migration.parser.plugin.Fingerprint;
import oracle.dbtools.migration.parser.plugin.IVariableNameTranslator;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.ITranslationLogging;
import oracle.dbtools.migration.translation.api.ITranslationManager;
import oracle.dbtools.migration.translation.api.TranslationResult;
import oracle.dbtools.migration.translation.api.TranslationSession;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;
import oracle.dbtools.migration.translation.util.ASTUtil;
import oracle.dbtools.migration.translation.util.TranslationUtil;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class AbstractParserMain
implements ITranslationAll {
    Logger LOGGER = Logger.getLogger(AbstractParserMain.class.getName());
    FaultTolleranceFilter m_faultTolleranceFilter = null;
    protected static final String TARGET_GENERATION = "TargetGeneration";
    protected static final String EXTENDED_TOKEN_CLASS_NAME = "oracle.dbtools.migration.parser.ext.ExtToken";
    protected static final String EXTENDED_AST_CLASS_NAME = "oracle.dbtools.migration.parser.ext.ExtAST";
    protected static final String STRINGTEMPLATE_DIR = "templates";
    protected static final String DEFAULT_TEMPLATE_GROUP_FILE = "generic";
    protected static final String LEXER = "lexer";
    protected boolean m_astTreeVisibility;
    protected int m_keywordTokenType;
    protected CommentHelper m_commentHelper;
    protected String m_templateGroupName;
    protected StringTemplateGroup m_templateGroup;
    protected CommonAST m_outputAST;
    protected RosettaRecognizer m_recognizer;
    protected HashMap<TreeWalkerType, TreeParser> m_treeWalkerMap;
    protected TreeParser m_outputGenerator;
    protected HighlightingBlockFilter m_highlightingFilter;
    protected RosettaLexer m_lexer;
    private ArrayList<HighLightingBlock> m_hlb = null;
    private HashMap<String, AST> m_astHashMap = new HashMap();
    protected TranslationHelper m_helper = null;
    private TranslationPreferences m_prefs = null;
    private ITranslationLogging m_logging = null;

    protected AbstractParserMain() {
        this.cleanUp();
    }

    protected void cleanUp() {
        this.m_keywordTokenType = 0;
        this.m_commentHelper = new CommentHelper();
        this.m_templateGroupName = DEFAULT_TEMPLATE_GROUP_FILE;
        this.m_treeWalkerMap = new HashMap();
        this.m_outputGenerator = null;
        this.m_highlightingFilter = null;
        this.m_astHashMap = new HashMap();
        this.m_helper = null;
        this.m_templateGroup = null;
        this.m_outputAST = null;
        this.m_recognizer = null;
        this.m_hlb = null;
    }

    private String getObjectNameNotNull() {
        String string = "Unknown Object";
        if (this.m_helper != null && this.m_helper.getSourceDBObject() != null && this.m_helper.getSourceDBObject().getFullName() != null) {
            string = this.m_helper.getSourceDBObject().getFullName();
        }
        return string;
    }

    protected String translateStr(String string, TranslationHelper translationHelper) throws TranslationException {
        if (string == null) {
            return null;
        }
        if (string.trim().equals("")) {
            return string;
        }
        this.setupTranslator(string, translationHelper, TARGET_GENERATION);
        return this.translate();
    }

    public ITranslationAnalysisResult analyseStr(String string, TranslationHelper translationHelper) throws TranslationException {
        if (string == null) {
            return null;
        }
        if (string.trim().equals("")) {
            return null;
        }
        this.setupTranslator(string, translationHelper, TreeWalkerType.METADATA_ANALYSIS.toString());
        return this.analyse();
    }

    @Override
    public TranslateResultWithASTs translateScript(String string, boolean bl) {
        this.setVerbos(bl);
        boolean bl2 = true;
        TranslateResultWithASTs translateResultWithASTs = new TranslateResultWithASTs("", (HashMap<String, AST>)null);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string;
        TranslateResultWithASTs translateResultWithASTs2 = null;
        while (bl2) {
            try {
                String[] stringArray = this.splitPreComments(string2);
                String string3 = stringArray[0];
                string2 = stringArray[1];
                stringBuffer.append(string3);
                if (string2 != null && !string2.trim().equals("")) {
                    translateResultWithASTs2 = this.translateAndGetASTS(string2);
                    Object object = translateResultWithASTs2.getAst("SOURCE_AST");
                    Integer[] integerArray = this.getLastLineParsed(object);
                    int n = integerArray[0];
                    int n2 = integerArray[1];
                    if (translateResultWithASTs2.getTargetString() == null || translateResultWithASTs2.getTargetString().trim().equals("")) {
                        stringBuffer.append("/**SQLDEV:FAILED TO TRANSLATE\n");
                        if (n != -1) {
                            String string4 = this.getSubStringLines(string2, 0, 0, n, n2);
                            stringBuffer.append(string4);
                        } else {
                            stringBuffer.append("STMT:UNKNOWN");
                        }
                        stringBuffer.append("\n**/\n");
                    } else {
                        stringBuffer.append(translateResultWithASTs2.getTargetString() + "\n");
                    }
                    if (n == 0) {
                        n = 1;
                    }
                    if (n >= this.getAmountOfLines(string2)) {
                        bl2 = false;
                        continue;
                    }
                    string2 = this.getSubStringLines(string2, n - 1);
                    string2 = this.getSubStringIndex(string2, n2);
                    if (object instanceof AST) {
                        string2 = this.eatTopComments(string2);
                        string2 = this.eatGO(string2).trim();
                        string2 = this.eatTopComments(string2);
                    }
                    if (!(string2 = string2.trim()).equals("")) continue;
                    bl2 = false;
                    continue;
                }
                bl2 = false;
            }
            catch (Exception exception) {
                stringBuffer.append("/**SQLDEV:FAILED TO TRANSLATE\n" + this.getSubStringLines(string2, 0, 0, 1, 0) + "\n**/\n");
                if (this.getAmountOfLines(string2) == 1 || string.startsWith("--NORECOVER")) {
                    bl2 = false;
                }
                string2 = this.getSubStringLines(string2, 1);
                string2 = string2.trim();
            }
        }
        translateResultWithASTs.setTargetString(stringBuffer.toString());
        if (translateResultWithASTs2 != null) {
            translateResultWithASTs.setAsts(translateResultWithASTs2.getAsts());
        }
        return translateResultWithASTs;
    }

    protected String eatTopComments(String string) {
        string = string.trim();
        while (string.startsWith("--") || string.startsWith("/*")) {
            int n;
            if (string.startsWith("--")) {
                string = this.getSubStringLines(string, 1).trim();
            }
            if (!string.startsWith("/*") || (n = string.indexOf("*/") + 2) <= 1) continue;
            string = string.substring(n).trim();
        }
        return string;
    }

    protected void setVerbos(boolean bl) {
    }

    private String[] splitPreComments(String string) {
        if ((string = string.trim()).startsWith("--") || string.startsWith("/*")) {
            return this.splitPreCommentsFnc(string);
        }
        return new String[]{"", string};
    }

    private String[] splitPreCommentsFnc(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String[] stringArray = string.split("\\r?\\n");
        String[] stringArray2 = new String[]{"", string};
        String string2 = null;
        try {
            boolean bl = false;
            boolean bl2 = false;
            for (String string3 : stringArray) {
                String string4;
                String string5;
                int n;
                if (string2 != null) {
                    string3 = string2 + string3;
                    string2 = null;
                }
                if (bl && !bl2) {
                    if (string3.indexOf("*/") == -1) {
                        stringBuffer.append(string3 + "\n");
                        continue;
                    }
                    n = string3.indexOf("*/") + 2;
                    string5 = string3.substring(0, n);
                    string4 = string3.substring(n);
                    stringBuffer.append(string5 + "\n");
                    if (string4.trim().length() > 0) {
                        string2 = string4 + "\n";
                    }
                    bl = false;
                    continue;
                }
                if (!bl2 && string3.trim().startsWith("--")) {
                    stringBuffer.append(string3 + "\n");
                    continue;
                }
                if (!bl2 && string3.trim().startsWith("/*")) {
                    if (string3.indexOf("*/") == -1) {
                        stringBuffer.append(string3 + "\n");
                        bl = true;
                        continue;
                    }
                    n = string3.indexOf("*/") + 2;
                    string5 = string3.substring(0, n);
                    string4 = string3.substring(n);
                    stringBuffer.append(string5 + "\n");
                    if (string4.trim().length() > 0) {
                        string2 = string4 + "\n";
                    }
                    bl = false;
                    continue;
                }
                if (!bl2 && string3.trim().equals("")) {
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer2.append(string3 + "\n");
                bl2 = true;
            }
            if (string2 != null) {
                stringBuffer2.append(string2 + "\n");
            }
        }
        catch (Exception exception) {
            return new String[]{"", string};
        }
        stringArray2 = new String[]{stringBuffer.toString(), stringBuffer2.toString()};
        return stringArray2;
    }

    private String eatGO(String string) {
        String string2 = this.getSubStringLines(string.trim(), 0, 0, 1, 0);
        if (string2.trim().equalsIgnoreCase("GO") || string2.trim().equalsIgnoreCase("/")) {
            return this.getSubStringLines(string, 1).trim();
        }
        if (string2.trim().startsWith(";")) {
            return this.getSubStringIndex(string.trim(), 1);
        }
        return string;
    }

    private int getLastComment() {
        Comment comment = this.m_commentHelper.getLastComment();
        if (comment != null) {
            return comment.getLine();
        }
        return -1;
    }

    private String getSubStringLines(String string, int n, int n2, int n3, int n4) {
        if (string == null) {
            return null;
        }
        int n5 = n == 0 ? 0 : this.getIndexForLine(string, n);
        int n6 = this.getIndexForLine(string, n3);
        if (n5 != -1 && n6 != -1) {
            return string.substring(n5 + n2, n6 + n4);
        }
        return string;
    }

    private String getSubStringLines(String string, int n) {
        if (string == null) {
            return null;
        }
        int n2 = this.getIndexForLine(string, n);
        if (n2 != -1) {
            return string.substring(n2);
        }
        return "";
    }

    private String getSubStringIndex(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n != -1) {
            return string.substring(n).trim();
        }
        return "";
    }

    private int getIndexForLine(String string, int n) {
        int n2 = 0;
        for (int i = 1; i <= n; ++i) {
            n2 = string.indexOf("\n", n2 > 0 ? n2 + 1 : n2);
        }
        if (n2 == -1) {
            return -1;
        }
        return n2 + 1;
    }

    private int getAmountOfLines(String string) {
        if (string == null) {
            return 0;
        }
        return string.split("\n").length;
    }

    private Integer[] getLastLineParsed(Object object) {
        if (object instanceof CommonTree) {
            CommonTree commonTree = (CommonTree)object;
            int n = commonTree.getLine();
            int n2 = commonTree.getCharPositionInLine() + 1;
            if (commonTree.getChildCount() > 0) {
                for (Object e : commonTree.getChildren()) {
                    Integer[] integerArray = this.getLastLineParsed((CommonTree)e);
                    int n3 = integerArray[0];
                    int n4 = integerArray[1];
                    if (n3 < n) continue;
                    n = n3;
                    n2 = n4;
                }
            }
            return new Integer[]{n, n2};
        }
        if (object instanceof AST) {
            AST aST = (AST)object;
            int n = aST.getSourceEndLine() + 1;
            int n5 = aST.getSourceEndCol() - 1;
            if (aST.getSourceEndLine() + 1 >= n) {
                n = aST.getSourceEndLine() + 1;
                n5 = aST.getSourceEndCol() - 1;
            }
            AST aST2 = aST.getFirstChild();
            for (int i = 0; i < aST.getNumberOfChildren(); ++i) {
                Integer[] integerArray = this.getLastLineParsed(aST2);
                int n6 = integerArray[0];
                int n7 = integerArray[1];
                if (n6 >= n) {
                    n = n6;
                    n5 = n7;
                }
                aST2 = aST2.getNextSibling();
            }
            return new Integer[]{n, n5};
        }
        return new Integer[]{-1, -1};
    }

    @Override
    public TranslateResultWithASTs translateAndGetASTS(String string) throws TranslationException {
        TranslateResultWithASTs translateResultWithASTs = null;
        String string2 = this.translate(string);
        if (string2.equalsIgnoreCase("")) {
            return null;
        }
        String string3 = TranslationUtil.getFullDdlScript(this.m_helper.getTranslationMetaData().getExtraObjects(), string2);
        translateResultWithASTs = new TranslateResultWithASTs(string3, this.m_astHashMap);
        translateResultWithASTs.setHelper(this.m_helper);
        return translateResultWithASTs;
    }

    @Override
    public TranslateResultWithASTs translateAndGetParseTree(String string) throws TranslationException {
        return this.translateAndGetASTS(string);
    }

    @Override
    public TranslationResult translate(TranslationDBObject translationDBObject, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging, ITranslationManager iTranslationManager, TranslationSession translationSession) throws TranslationException {
        Object object;
        if (translationDBObject.getDdl() == null) {
            TranslationException translationException = new TranslationException(" > " + translationDBObject.getFullName() + Messages.getString("AbstractParserMain.9"));
            throw translationException;
        }
        TranslationMessages.debuginfo(Messages.getString("AbstractParserMain.10") + translationDBObject.getDatabaseName() + "." + translationDBObject.getOwnerName() + "." + translationDBObject.getObjName());
        TranslationDBObject translationDBObject2 = null;
        TranslationResult translationResult = null;
        boolean bl = false;
        if (translationDBObject.getType().equals(TranslationObjectType.CONSTRAINT_TYPE)) {
            if (this.isRule(translationDBObject)) {
                object = iTranslationContext.getInfoKeyValue("CONSTRAINT_COLUMN");
                if (object != null) {
                    this.processRuleDDL(translationDBObject, (String)object);
                } else {
                    this.processRuleDDL(translationDBObject, "columnName");
                }
            }
            if (translationDBObject.getDdl().toUpperCase().indexOf("GETDATE") != -1) {
                bl = true;
                translationDBObject2 = this.getDummyTriggerFromConstraint(translationDBObject);
            } else {
                translationDBObject2 = this.getDummyProcFromConstraint(translationDBObject);
            }
        } else {
            translationDBObject2 = translationDBObject;
        }
        object = new TranslationHelper(translationDBObject2, iTranslationContext, iTranslationLogging, iTranslationManager, translationSession);
        ((TranslationHelper)object).setVariableNameTranslator(this.getVariableNameTranslator());
        String string = null;
        try {
            string = this.translateStr(translationDBObject2.getDdl(), (TranslationHelper)object);
        }
        catch (TranslationException translationException) {
            throw translationException;
        }
        catch (Throwable throwable) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
            throw this.getTranslationException(throwable, this.getObjectNameNotNull(), this.m_helper.getErrors());
        }
        if (translationDBObject.getType().equals(TranslationObjectType.CONSTRAINT_TYPE) && !bl) {
            string = this.getConstraintFromDummyProc(string);
        }
        if (string == null) {
            TranslationException translationException = new TranslationException(" > " + translationDBObject.getFullName() + Messages.getString("AbstractParserMain.19"));
            throw translationException;
        }
        translationResult = this.createTargetObject(this.hackToRemoveTopComments(string = string.replaceFirst("(\\s)+$", "")), translationDBObject, (TranslationHelper)object);
        if (translationResult != null) {
            if (bl) {
                translationResult.getTargetObject().setType(TranslationObjectType.TRIGGER_TYPE);
                translationResult.getTargetObject().setObjName(this.getConstraintTriggerName(translationDBObject.getObjName(), translationDBObject.getPartName()));
            }
            if (this.m_helper != null) {
                translationResult.setExtraObjects(this.m_helper.getTranslationMetaData().getExtraObjects());
            }
        }
        return translationResult;
    }

    private boolean isRule(TranslationDBObject translationDBObject) {
        return translationDBObject.getDdl().toLowerCase().indexOf("create rule") != -1;
    }

    private void processRuleDDL(TranslationDBObject translationDBObject, String string) {
        String string2 = translationDBObject.getDdl();
        int n = string2.toLowerCase().indexOf(" as ") + 4;
        string2 = string2.substring(n);
        String string3 = this.getParamName(string2);
        string2 = string2.replaceAll(string3, string);
        translationDBObject.setDdl(string2);
    }

    private String getParamName(String string) {
        int n = string.indexOf(64);
        if (n == -1) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f!=.()[]{}:;><'\"~#?,+_-*&^%$\u00a3\u00c2\u00ac`");
        return stringTokenizer.nextToken();
    }

    private String hackToRemoveTopComments(String string) {
        if (string == null) {
            return null;
        }
        int n = string.toUpperCase().indexOf("CREATE OR REPLACE");
        int n2 = string.toUpperCase().indexOf("\nBEGIN");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (n == -1) {
            return string;
        }
        if (n != 0 && n2 != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n, n2 + 7);
            string4 = string.substring(n2 + 7);
            string = (string3 != null && !string3.trim().equalsIgnoreCase("") ? string3 + "\n" : "") + (string2 != null && !string2.trim().equalsIgnoreCase("") ? string2 + "\n" : "") + string4;
        }
        return string;
    }

    private TranslationResult createTargetObject(String string, TranslationDBObject translationDBObject, TranslationHelper translationHelper) {
        TranslationResult translationResult = null;
        TranslationDBObjectReference translationDBObjectReference = null;
        try {
            translationDBObjectReference = translationHelper.getTranslationContext().getTargetDBObjectReference(translationDBObject.getDBObjectReference(), translationDBObject.getOMWBObj());
            if (translationDBObjectReference == null) {
                translationDBObjectReference = translationDBObject.getDBObjectReference();
            }
        }
        catch (Exception exception) {
            translationDBObjectReference = translationDBObject.getDBObjectReference();
        }
        if (translationDBObjectReference != null) {
            TranslationDBObject translationDBObject2 = new TranslationDBObject(translationDBObjectReference, string);
            ArrayList<TranslationDBObject> arrayList = null;
            translationResult = new TranslationResult(translationDBObject2, arrayList, translationHelper);
        }
        return translationResult;
    }

    private TranslationDBObject getDummyProcFromConstraint(TranslationDBObject translationDBObject) {
        String string = translationDBObject.getDdl();
        String string2 = translationDBObject.getObjName();
        String string3 = "proc1";
        String string4 = "CREATE PROCEDURE " + string3 + " AS SELECT * FROM [" + string2 + "] WHERE " + string;
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference(translationDBObject.getDBObjectReference());
        translationDBObjectReference.setType(TranslationObjectType.PROCEDURE_TYPE);
        translationDBObjectReference.setObjName(string3);
        TranslationDBObject translationDBObject2 = new TranslationDBObject(translationDBObjectReference, string4);
        return translationDBObject2;
    }

    private TranslationDBObject getDummyTriggerFromConstraint(TranslationDBObject translationDBObject) {
        String string = translationDBObject.getDdl();
        String string2 = translationDBObject.getObjName();
        String string3 = translationDBObject.getPartName();
        String string4 = this.getConstraintTriggerName(string2, string3);
        String string5 = "CREATE TRIGGER " + string4 + " ON [" + string2 + "] FOR INSERT, UPDATE AS \n" + " IF NOT (" + string + ")\n" + " BEGIN \n" + " RAISERROR ('" + string4 + " failed', 1, 1) \n" + " END ";
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference(translationDBObject.getDBObjectReference());
        translationDBObjectReference.setType(TranslationObjectType.TRIGGER_TYPE);
        translationDBObjectReference.setObjName(string4);
        TranslationDBObject translationDBObject2 = new TranslationDBObject(translationDBObjectReference, string5);
        return translationDBObject2;
    }

    private String getConstraintTriggerName(String string, String string2) {
        return this.generateName(string, string2) + "_SYSDTRG";
    }

    private String generateName(String string, String string2) {
        if (string2.length() > 22) {
            return string2.substring(0, 16) + AbstractParserMain.randomChars(6);
        }
        return string2;
    }

    private static String randomChars(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2 = (int)(Math.random() * 26.0);
            boolean bl2 = bl = (int)(Math.random() * 10000.0) % 2 == 0;
            if (bl) {
                stringBuffer.append((char)(65 + n2));
                continue;
            }
            stringBuffer.append((char)(97 + n2));
        }
        return stringBuffer.toString();
    }

    private String getConstraintFromDummyProc(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        string2 = string2.substring(string2.indexOf("WHERE") + 6);
        string2 = string2.substring(0, string2.indexOf(";"));
        return string2;
    }

    public TranslationResult getEmulationPackage(TranslationDBObjectReference translationDBObjectReference, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging, TranslationSession translationSession) throws TranslationException {
        return null;
    }

    @Override
    public String getEmulationPackage() {
        return null;
    }

    @Override
    public TranslationSession startTranslationSession() {
        return new TranslationSession();
    }

    @Override
    public final Reader translate(Reader reader) throws TranslationException {
        char[] cArray = new char[100];
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        try {
            int n;
            while ((n = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            string = this.translate(stringBuffer.toString());
        }
        catch (TranslationException translationException) {
            throw translationException;
        }
        catch (Throwable throwable) {
            throw this.getTranslationException(throwable, this.getObjectNameNotNull(), this.m_helper.getErrors());
        }
        return new CharArrayReader(string.toCharArray());
    }

    @Override
    public String translate(String string) throws TranslationException {
        TranslationHelper translationHelper = new TranslationHelper();
        translationHelper.defaultInit();
        translationHelper.setVariableNameTranslator(this.getVariableNameTranslator());
        translationHelper.getTranslationContext().setPreferences(this.m_prefs);
        if (this.m_logging != null) {
            translationHelper.setLogging(this.m_logging);
        }
        String string2 = this.translateStr(string, translationHelper);
        return string2;
    }

    public void setLoggin(ITranslationLogging iTranslationLogging) {
        this.m_logging = iTranslationLogging;
    }

    public ArrayList<IFoldingBlock> getFoldingBlocks() {
        return null;
    }

    public ArrayList<ISyntaxHighlightingBlock> getSyntaxHighLightingBlocks() {
        return null;
    }

    public ArrayList<ITranslationDiffBlock> getTranslationDiffBlocks() {
        return null;
    }

    public void setupTranslator(String string, TranslationHelper translationHelper, String string2) {
        try {
            this.cleanUp();
            this.m_helper = translationHelper;
            this.m_astHashMap = null;
            this.m_astHashMap = new HashMap();
            string = string.replace('\u0000', ' ');
            translationHelper.setSourceText(string);
            this.m_lexer = this.getLexer(new StringReader(string));
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.m_lexer.setTokenObjectClass(EXTENDED_TOKEN_CLASS_NAME);
            this.m_lexer.setHelper(this.m_helper);
            this.m_highlightingFilter = new HighlightingBlockFilter((TokenStream)this.m_lexer);
            if (string2.equals(LEXER)) {
                return;
            }
            CommentTokenFilter commentTokenFilter = new CommentTokenFilter(this.m_highlightingFilter, this.m_commentHelper);
            commentTokenFilter.setSingLineCommentTypes(this.getSingleLineCommentTypes());
            commentTokenFilter.setMultiLineCommentTypes(this.getMultiLineCommentTypes());
            KeywordCaseConversionFilter keywordCaseConversionFilter = new KeywordCaseConversionFilter(this.m_lexer, commentTokenFilter);
            this.m_faultTolleranceFilter = new FaultTolleranceFilter(this.m_lexer, keywordCaseConversionFilter, commentTokenFilter);
            this.m_recognizer = this.getRecognizer(this.m_faultTolleranceFilter);
            this.m_recognizer.setHelper(translationHelper);
            if (this.m_recognizer != null) {
                this.m_recognizer.setKeywordIdType(this.getKeywordTokenType());
                this.m_recognizer.setASTNodeClass(EXTENDED_AST_CLASS_NAME);
            }
            this.getTreeWalkers();
            Iterator<TreeParser> iterator = this.m_treeWalkerMap.values().iterator();
            ExtTreeParser extTreeParser = null;
            while (iterator.hasNext()) {
                extTreeParser = (ExtTreeParser)iterator.next();
                extTreeParser.setASTNodeClass(EXTENDED_AST_CLASS_NAME);
                this.setHelper(extTreeParser, translationHelper);
            }
            if (string2.equals(TARGET_GENERATION)) {
                this.loadStringTemplateGroup();
                this.m_outputGenerator = this.getOutputGenerator();
                if (this.m_outputGenerator != null) {
                    this.m_outputGenerator.setASTNodeClass(EXTENDED_AST_CLASS_NAME);
                    this.setHelper((ExtTreeParser)this.m_outputGenerator, translationHelper);
                    this.setOutputStringTemplateGroup(this.m_outputGenerator, this.m_templateGroup);
                }
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.SEVERE, "Issue with classes:" + exception.getMessage());
            exception.printStackTrace();
        }
    }

    @Override
    public ExtAST getAST(String string) throws TranslationException {
        if (string == null) {
            return null;
        }
        if (string.trim().equals("")) {
            return null;
        }
        TranslationHelper translationHelper = new TranslationHelper();
        translationHelper.defaultInit();
        translationHelper.setVariableNameTranslator(this.getVariableNameTranslator());
        this.setupTranslator(string, translationHelper, TreeWalkerType.SOURCE_TREE_WALKER.toString());
        CommonAST commonAST = this.recognize();
        return (ExtAST)commonAST;
    }

    @Override
    public boolean recognize(String string) throws TranslationException {
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        TranslationHelper translationHelper = new TranslationHelper();
        translationHelper.defaultInit();
        translationHelper.setVariableNameTranslator(this.getVariableNameTranslator());
        this.setupTranslator(string, translationHelper, TreeWalkerType.SOURCE_TREE_WALKER.toString());
        CommonAST commonAST = this.recognize();
        return commonAST != null;
    }

    private ITranslationAnalysisResult analyse() throws TranslationException {
        CommonAST commonAST = null;
        ITranslationAnalysisResult iTranslationAnalysisResult = null;
        commonAST = this.generateSourceAST();
        iTranslationAnalysisResult = this.analyseAST(commonAST);
        return iTranslationAnalysisResult;
    }

    private CommonAST recognize() throws TranslationException {
        CommonAST commonAST = null;
        commonAST = this.generateSourceAST();
        return commonAST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String translate() throws TranslationException {
        CommonAST commonAST = null;
        CommonAST commonAST2 = null;
        String string = null;
        try {
            if (this.m_helper != null && this.m_helper.getTranslationContext() != null) {
                this.m_helper.getTranslationContext().setPersistenceUtilityCache(true);
            }
            commonAST2 = this.generateSourceAST();
            ASTUtil.walkAntlrTree((ExtAST)commonAST2, new IVisitor(){

                @Override
                public IVisitorResult returnResult(IVisitorResult iVisitorResult, IVisitorResult iVisitorResult2) {
                    return null;
                }

                @Override
                public IVisitorResult visit(ExtAST extAST) {
                    if (extAST == null) {
                        return null;
                    }
                    ExtAST extAST2 = (ExtAST)extAST.getFirstChild();
                    if (extAST2 != null) {
                        extAST2.setParent(extAST);
                        for (extAST2 = (ExtAST)extAST2.getNextSibling(); extAST2 != null; extAST2 = (ExtAST)extAST2.getNextSibling()) {
                            extAST2.setParent(extAST);
                        }
                    }
                    return null;
                }
            });
            commonAST = commonAST2;
            this.m_astHashMap.put("SOURCE_AST", (AST)commonAST2);
            this.analyseAST(commonAST);
            commonAST = this.generateTargetAST(commonAST);
            commonAST = this.translateTargetAST(commonAST);
            string = this.generateTargetResult(commonAST);
        }
        finally {
            if (this.m_helper != null && this.m_helper.getTranslationContext() != null) {
                this.m_helper.getTranslationContext().setPersistenceUtilityCache(false);
            }
        }
        return string;
    }

    private CommonAST generateSourceAST() throws TranslationException {
        CommonAST commonAST = null;
        if (this.m_recognizer == null) {
            throw new TranslationException(" > " + this.getObjectNameNotNull() + Messages.getString("AbstractParserMain.55"));
        }
        try {
            this.m_recognizer.start();
            commonAST = (CommonAST)this.m_recognizer.getAST();
            if (this.m_astTreeVisibility) {
                this.displayASTTree(((Object)((Object)this.m_recognizer)).getClass().getSimpleName(), commonAST);
            }
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.SOURCE_TREE_WALKER), commonAST);
        }
        catch (Throwable throwable) {
            throw this.getTranslationException(throwable, this.getObjectNameNotNull(), this.m_helper.getErrors());
        }
        this.m_recognizer = null;
        return commonAST;
    }

    private TranslationException getTranslationException(Throwable throwable, String string, ArrayList<String> arrayList) {
        int n;
        TranslationException translationException = null;
        String string2 = "";
        if (throwable instanceof RecognitionException) {
            int n2 = ((RecognitionException)throwable).getLine();
            n = ((RecognitionException)throwable).getColumn();
            string2 = "Line " + n2 + " Column " + n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(throwable.getClass().getName());
        stringBuffer.append(">");
        stringBuffer.append(string);
        stringBuffer.append(":");
        stringBuffer.append(throwable.getLocalizedMessage());
        stringBuffer.append(":");
        stringBuffer.append(string2);
        stringBuffer.append(":");
        stringBuffer.append("\n[");
        n = 1;
        for (String string3 : arrayList) {
            if (n == 0) {
                stringBuffer.append(",");
            }
            n = 0;
            stringBuffer.append(string3);
        }
        stringBuffer.append("]");
        translationException = new TranslationException(stringBuffer.toString());
        translationException.setStackTrace(throwable.getStackTrace());
        return translationException;
    }

    private ITranslationAnalysisResult analyseAST(CommonAST commonAST) throws TranslationException {
        try {
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.STRUCTURAL_ANALYSIS_PASS1), commonAST);
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.STRUCTURAL_ANALYSIS_PASS2), commonAST);
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.DEPENDENCY_ANALYSIS), commonAST);
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.LIMITATION_ANALYSIS), commonAST);
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.METADATA_ANALYSIS), commonAST);
            ((ExtTreeParser)this.m_treeWalkerMap.get((Object)TreeWalkerType.METADATA_ANALYSIS)).getHelper().getTranslationMetaData().persist();
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.EXPRESSION_ANALYSIS), commonAST);
        }
        catch (Throwable throwable) {
            throw this.getTranslationException(throwable, this.getObjectNameNotNull(), this.m_helper.getErrors());
        }
        TranslationAnalysisResult translationAnalysisResult = new TranslationAnalysisResult();
        return translationAnalysisResult;
    }

    private CommonAST generateTargetAST(CommonAST commonAST) throws TranslationException {
        CommonAST commonAST2 = null;
        try {
            commonAST2 = this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.SOURCE_TO_TARGET_TRANSFORMER), commonAST);
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.TARGET_TREE_WALKER), commonAST2);
        }
        catch (Throwable throwable) {
            throw this.getTranslationException(throwable, this.getObjectNameNotNull(), this.m_helper.getErrors());
        }
        return commonAST2;
    }

    private CommonAST translateTargetAST(CommonAST commonAST) throws TranslationException {
        CommonAST commonAST2 = null;
        try {
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.TARGET_TREE_TRANSLATOR), commonAST);
            commonAST2 = commonAST;
        }
        catch (Throwable throwable) {
            throw this.getTranslationException(throwable, this.getObjectNameNotNull(), this.m_helper.getErrors());
        }
        return commonAST2;
    }

    private String generateTargetResult(CommonAST commonAST) throws TranslationException {
        String string = null;
        try {
            if (this.m_outputGenerator != null) {
                this.m_outputGenerator.start((AST)commonAST);
                StringTemplate stringTemplate = this.getOutputStringTemplate(this.m_outputGenerator);
                StringTemplate.setLintMode((boolean)false);
                if (stringTemplate != null) {
                    string = stringTemplate.toString();
                    if (this.m_commentHelper.hasComments()) {
                        string = this.m_commentHelper.getTranslatedTextWithComment(stringTemplate, this.m_helper.getCodeBlockManager().getTopBlock());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw this.getTranslationException(throwable, this.getObjectNameNotNull(), this.m_helper.getErrors());
        }
        return string;
    }

    private void displayBlock(Block block) {
        Block block2 = block;
        AST aST = block2.getAST();
        if (aST != null) {
            TranslationMessages.debuginfo("Block Name: " + block2.getBlockName() + "Block Type: " + block2.getBlockType() + " - source[start:end]=" + block2.getSourceStartLine() + ":" + block2.getSourceEndLine() + "; target[start:end]=" + block2.getTargetStartLine() + ":" + block2.getTargetEndLine());
        }
        ArrayList<Block> arrayList = block2.getChildren();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.displayBlock(arrayList.get(i));
        }
    }

    private CommonAST startTreeWalker(TreeParser treeParser, CommonAST commonAST) throws RecognitionException {
        CommonAST commonAST2 = commonAST;
        if (treeParser == null) {
            return commonAST2;
        }
        treeParser.start((AST)commonAST);
        commonAST2 = (CommonAST)treeParser.getAST();
        if (this.m_astTreeVisibility) {
            this.displayASTTree(treeParser.getClass().getSimpleName(), commonAST2);
        }
        return commonAST2;
    }

    private void displayASTTree(String string, CommonAST commonAST) {
        if (commonAST != null) {
            ASTFrame aSTFrame = new ASTFrame(string, (AST)commonAST);
            aSTFrame.setVisible(true);
        }
    }

    protected void loadStringTemplateGroup() {
        String string = null;
        try {
            StringTemplateGroup stringTemplateGroup;
            CommonGroupLoader commonGroupLoader = new CommonGroupLoader(STRINGTEMPLATE_DIR, null);
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)this.m_templateGroupName);
            this.m_templateGroup.setStringTemplateWriter(ExtAutoIndentWriter.class);
            this.m_templateGroup.setRefreshInterval(0);
            string = this.getTemplateSubgroupName();
            if (string != null && (stringTemplateGroup = StringTemplateGroup.loadGroup((String)string, (StringTemplateGroup)this.m_templateGroup)) != null) {
                stringTemplateGroup.setSuperGroup(this.m_templateGroup);
                this.m_templateGroup = stringTemplateGroup;
                this.m_templateGroup.setStringTemplateWriter(ExtAutoIndentWriter.class);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public String[] getAllTemplateNames() {
        String[] stringArray = null;
        if (this.m_templateGroup != null) {
            Set set = this.m_templateGroup.getTemplateNames();
            stringArray = new String[set.size()];
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n++] = (String)iterator.next();
            }
        }
        return stringArray;
    }

    public StringTemplate getStringTemplate(String string) {
        return this.m_templateGroup != null ? this.m_templateGroup.getInstanceOf(string) : null;
    }

    public void setDisplayASTTree(boolean bl) {
        this.m_astTreeVisibility = bl;
    }

    protected void setHelper(ExtTreeParser extTreeParser, TranslationHelper translationHelper) {
        extTreeParser.setHelper(translationHelper);
    }

    protected IVariableNameTranslator getVariableNameTranslator() {
        return new DefaultVariabletNameTranslator();
    }

    protected Block getFoldingBlockFromTree(TreeParser treeParser) {
        return null;
    }

    public int getKeywordTokenType() {
        return -1;
    }

    protected void setOutputStringTemplateGroup(TreeParser treeParser, StringTemplateGroup stringTemplateGroup) {
    }

    protected BitSet getSingleLineCommentTypes() {
        return null;
    }

    protected BitSet getMultiLineCommentTypes() {
        return null;
    }

    protected RosettaLexer getLexer(StringReader stringReader) {
        return null;
    }

    protected RosettaRecognizer getRecognizer(TokenStream tokenStream) {
        return null;
    }

    protected void getTreeWalkers() {
    }

    protected TreeParser getOutputGenerator() {
        return null;
    }

    protected String getTemplateSubgroupName() {
        return null;
    }

    public StringTemplate getOutputStringTemplate(TreeParser treeParser) {
        return null;
    }

    @Override
    public ArrayList<Token> lex(String string) throws TranslationException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        ArrayList<Token> arrayList = new ArrayList<Token>();
        TranslationHelper translationHelper = new TranslationHelper();
        translationHelper.defaultInit();
        this.setupTranslator(string, translationHelper, LEXER);
        try {
            Token token = this.m_highlightingFilter.nextToken();
            while (token != null && token.getType() != 1) {
                arrayList.add(token);
                token = this.m_highlightingFilter.nextToken();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    @Override
    public ITranslationAnalysisResult analyse(String string) throws TranslationException {
        return this.analyse(string, null, null);
    }

    public ITranslationAnalysisResult analyse(TranslationDBObject translationDBObject, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging) throws TranslationException {
        return this.analyse(translationDBObject.getDdl(), translationDBObject, iTranslationContext, iTranslationLogging);
    }

    public ITranslationAnalysisResult analyse(String string, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging) throws TranslationException {
        return this.analyse(string, null, iTranslationContext, iTranslationLogging);
    }

    private ITranslationAnalysisResult analyse(String string, TranslationDBObject translationDBObject, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging) throws TranslationException {
        TranslationHelper translationHelper = new TranslationHelper(translationDBObject, iTranslationContext, iTranslationLogging, null, null);
        translationHelper.setVariableNameTranslator(this.getVariableNameTranslator());
        return this.analyseStr(string, translationHelper);
    }

    @Override
    public void setPreferences(TranslationPreferences translationPreferences) {
        this.m_prefs = translationPreferences;
    }

    public ArrayList<TranslationDBObject> getExtraObjects() {
        return this.m_helper.getTranslationMetaData().getExtraObjects();
    }

    @Override
    public Fingerprint fingerprint(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        try {
            ArrayList<Token> arrayList = this.lex(string);
            if (arrayList != null && (arrayList.get(0).getText().equalsIgnoreCase("BEGIN") || arrayList.get(0).getText().equalsIgnoreCase("DECLARE"))) {
                bl = true;
            }
            HashMap<Integer, String> hashMap2 = this.getLiteralTypes();
            int n = 1;
            for (Token token : arrayList) {
                if (hashMap2.containsKey(token.getType())) {
                    String string2 = AbstractParserMain.getTag("literal", hashMap2.get(token.getType()), n);
                    String string3 = token.getText();
                    hashMap.put(this.upperCase(string2), string3);
                    stringBuffer.append(this.upperCase(string2));
                    ++n;
                } else {
                    stringBuffer.append(token.getText());
                }
                stringBuffer.append(" ");
            }
        }
        catch (TranslationException translationException) {
            translationException.printStackTrace();
        }
        return new Fingerprint(stringBuffer.toString().trim(), hashMap, bl);
    }

    protected String upperCase(String string) {
        if (!string.startsWith("\"")) {
            return string.toUpperCase();
        }
        return string;
    }

    protected static String getTag(String string, String string2, int n) {
        return "<ora:" + string + " type=" + string2 + " id=" + n + ">";
    }

    protected HashMap<Integer, String> getLiteralTypes() {
        return null;
    }

    protected String getTableTriggerSQLDef(ArrayList<String> arrayList) {
        try {
            TranslationPreferences translationPreferences = this.m_helper.getTranslationContext().getTranslationPreferences(null);
            if (!translationPreferences.getIdentityCols() || arrayList != null || arrayList.size() == 0) {
                return null;
            }
            ExtStringTemplate extStringTemplate = this.m_helper.getTemplateManager().getExtTemplate("collection_package");
            if (arrayList != null && arrayList.size() > 0) {
                for (String string : arrayList) {
                    String[] stringArray = string.split("\\.");
                    String string2 = null;
                    String string3 = null;
                    if (stringArray.length == 1) {
                        string2 = stringArray[0];
                    } else {
                        string3 = stringArray[0];
                        string2 = stringArray[1];
                    }
                    ExtStringTemplate extStringTemplate2 = this.m_helper.getTemplateManager().getExtTemplate("tableType");
                    extStringTemplate2.setValue(1, string3);
                    extStringTemplate2.setValue(2, string2);
                    extStringTemplate.setValue(1, (Object)extStringTemplate2);
                }
                return extStringTemplate.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public TranslationResult getEmulationPackageForConnection(Object object, TranslationDBObjectReference translationDBObjectReference, ITranslationContext iTranslationContext, ArrayList<String> arrayList, TranslationHelper translationHelper) throws TranslationException {
        return null;
    }

    @Override
    public TranslationResult getEmulationPackageForSchema(Object object, TranslationDBObjectReference translationDBObjectReference, ITranslationContext iTranslationContext, ArrayList<String> arrayList, TranslationHelper translationHelper) throws TranslationException {
        return null;
    }

    protected static enum TreeWalkerType {
        SOURCE_TREE_WALKER,
        METADATA_ANALYSIS,
        EXPRESSION_ANALYSIS,
        STRUCTURAL_ANALYSIS_PASS1,
        STRUCTURAL_ANALYSIS_PASS2,
        DEPENDENCY_ANALYSIS,
        LIMITATION_ANALYSIS,
        SOURCE_TO_TARGET_TRANSFORMER,
        TARGET_TREE_WALKER,
        TARGET_TREE_TRANSLATOR;

    }
}

