/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.WholeNumberField;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;

public class ConnectionComponentCache {
    private final Map<String, JLabel> m_labels = new HashMap<String, JLabel>();
    private final Map<String, JTextComponent> m_components = new HashMap<String, JTextComponent>();
    private final DBUIResourceHelper m_resourceHelper;
    private final String m_subType;
    private final DatabaseConnectionHook.ConnectionType m_connType;
    private final String m_panelName;

    public ConnectionComponentCache(String subType, String panelName) {
        this.m_resourceHelper = new DBUIResourceHelper(panelName);
        this.m_subType = subType;
        this.m_panelName = panelName;
        DatabaseConnectionHook.ConnectionType found = null;
        for (DatabaseConnectionHook.ConnectionType type : DatabaseConnectionHook.getHook().getConnectionTypes()) {
            if (!subType.equals(type.getSubtype())) continue;
            found = type;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException(subType + " is not a valid subtype");
        }
        this.m_connType = found;
    }

    protected final void registerTextComponent(String property, JLabel label, JTextComponent field, String componentName) {
        this.registerTextComponent(property, label, field, this.getPropertyLabelText(property), componentName);
    }

    protected final void registerTextComponent(String property, JLabel label, JTextComponent field, String labelText, String componentName) {
        if (this.m_components.containsKey(property)) {
            throw new IllegalStateException("Cannot register a property more than once");
        }
        this.m_components.put(property, field);
        if (label != null) {
            this.getResourceHelper().resLabel(label, (Component)field, labelText, componentName);
            this.m_labels.put(property, label);
        }
    }

    protected final String getPropertyLabelText(String property) {
        return this.m_connType.getPropertyLabelText(property);
    }

    protected final DBUIResourceHelper getResourceHelper() {
        return this.m_resourceHelper;
    }

    protected final String getPanelName() {
        return this.m_panelName;
    }

    protected final DatabaseConnectionHook.ConnectionType getConnectionType() {
        return this.m_connType;
    }

    protected final ConnectionCreator getConnectionCreator() {
        return this.m_connType.getConnectionCreator();
    }

    protected final String getConnectionSubType() {
        return this.m_subType;
    }

    protected String getDefaultValue(String property) {
        String retval = null;
        if ("hostname".equals(property)) {
            retval = "localhost";
        }
        return retval;
    }

    protected void populateConnectionDetails(Properties connectionProps) {
        for (Map.Entry<String, JTextComponent> entry : this.m_components.entrySet()) {
            String property = entry.getKey();
            entry.getValue().setText(connectionProps.getProperty(property, this.getDefaultValue(property)));
        }
    }

    protected final void setEnabled(String property, boolean enabled) {
        this.setEnabled(this.m_components.get(property), enabled);
        this.setEnabled(this.m_labels.get(property), enabled);
    }

    private void setEnabled(Component c, boolean enabled) {
        if (c != null) {
            c.setEnabled(enabled);
        }
    }

    protected final void setVisible(String property, boolean visible) {
        this.setVisible(this.m_components.get(property), visible);
        this.setVisible(this.m_labels.get(property), visible);
    }

    private void setVisible(Component c, boolean visible) {
        if (c != null) {
            c.setVisible(visible);
        }
    }

    protected void commitConnectionDetails(Properties connectionProps) {
        for (Map.Entry<String, JTextComponent> entry : this.m_components.entrySet()) {
            String property = entry.getKey();
            String val = this.getTrimmedText(entry.getValue());
            this.setProperty(connectionProps, property, val);
        }
    }

    protected Collection<String> getRegisteredProperties() {
        return this.m_components.keySet();
    }

    protected final String getTrimmedText(JTextComponent tc) {
        Number n;
        String retval = tc instanceof NumberTextField ? ((n = ((NumberTextField)tc).getNumber()) == null ? null : n.toString()) : this.trimIfNotNull(tc.getText());
        return retval;
    }

    protected final String trimIfNotNull(String s) {
        if (s != null) {
            s = s.trim();
        }
        return ModelUtil.nullifyIfEmpty((String)s);
    }

    protected final void setProperty(Properties connectionProps, String property, String val) {
        if (ModelUtil.hasLength((String)val)) {
            connectionProps.setProperty(property, val);
        } else {
            connectionProps.remove(property);
        }
    }

    protected static NumberTextField newPortField() {
        return new WholeNumberField(6);
    }
}

