/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdevimpl.db.resource.ConnBundle;

public class DatabaseFinder
extends ProgressRunnable {
    private String m_connString;
    private Database m_db;
    private DBException m_exception;

    public static Database findDatabase(String connString) {
        Database db = (Database)DBObjectProviderFactory.findProvider((String)"db", (Object)connString);
        if (db == null) {
            DatabaseFinder c = new DatabaseFinder(connString);
            db = c.getDatabase(true);
        }
        return db;
    }

    public static Database findDatabaseEx(String connString) throws DBException {
        Database db = null;
        if (connString != null && (db = (Database)DBObjectProviderFactory.findProvider((String)"db", (Object)connString)) == null) {
            DatabaseFinder c = new DatabaseFinder(connString);
            db = c.getDatabase(false);
            if (c.m_exception != null) {
                throw c.m_exception;
            }
        }
        return db;
    }

    private DatabaseFinder(String connString) {
        this.setTitle(ConnBundle.get("TITLE_CONNECTING"));
        this.setMessage(ConnBundle.format("MESSAGE_CONNECTING", DatabaseFactory.decodeIdentifier((String)connString)[1]));
        this.m_connString = connString;
    }

    protected Object doWork() {
        try {
            this.m_db = (Database)DBObjectProviderFactory.findOrCreateProvider((String)"db", (Object)this.m_connString);
        }
        catch (DBException dbe) {
            this.m_exception = dbe;
        }
        return null;
    }

    private Database getDatabase(boolean showError) {
        if (this.m_db == null) {
            try {
                this.start(SwingUtilities.isEventDispatchThread());
            }
            catch (ProgressException e) {
                DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Error running connection progress bar", e);
            }
        }
        if (showError && this.m_exception != null) {
            this.reportError(this.m_exception);
        }
        return this.m_db;
    }

    private void reportError(final DBException dbe) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String title = ConnBundle.get("ERROR_CONNECTING");
                DBExceptionDialog.showErrorDialog(null, (String)title, (DBException)dbe);
            }
        });
    }

    protected int getProgressShowDelay() {
        return 1000;
    }
}

