/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.resource.ConnBundle;

public class ConnectionDetails
extends JPanel {
    private JLabel m_usernameLabel;
    private JLabel m_usernameField;
    private JLabel m_driverLabel;
    private JLabel m_driverField;
    private JLabel m_urlLabel;
    private JLabel m_urlField;

    public ConnectionDetails() {
        this.layoutComponents(this);
    }

    private void layoutComponents(JPanel detailsPanel) {
        detailsPanel.setLayout(new GridBagLayout());
        detailsPanel.setName("ConnectionDetails");
        this.m_usernameLabel = new JLabel();
        this.m_usernameField = new JLabel();
        this.m_usernameLabel.setText(ConnBundle.get("LABEL_USERNAME"));
        this.m_usernameLabel.setEnabled(false);
        this.m_usernameField.setName("ConnectionDetails.USER");
        this.m_driverLabel = new JLabel();
        this.m_driverField = new JLabel();
        this.m_driverLabel.setText(ConnBundle.get("LABEL_DRIVER"));
        this.m_driverLabel.setEnabled(false);
        this.m_driverField.setName("ConnectionDetails.DRIVER");
        this.m_urlLabel = new JLabel();
        this.m_urlField = new JLabel();
        this.m_urlLabel.setText(ConnBundle.get("LABEL_URL"));
        this.m_urlLabel.setEnabled(false);
        this.m_urlField.setName("ConnectionDetails.URL");
        Insets i = new Insets(5, 5, 5, 5);
        GridBagConstraints gblabel = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, i, 0, 0);
        GridBagConstraints gbfield = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, i, 0, 0);
        detailsPanel.add((Component)this.m_usernameLabel, gblabel);
        detailsPanel.add((Component)this.m_usernameField, gbfield);
        ++gblabel.gridy;
        ++gbfield.gridy;
        detailsPanel.add((Component)this.m_driverLabel, gblabel);
        detailsPanel.add((Component)this.m_driverField, gbfield);
        ++gblabel.gridy;
        ++gbfield.gridy;
        detailsPanel.add((Component)this.m_urlLabel, gblabel);
        detailsPanel.add((Component)this.m_urlField, gbfield);
    }

    @Override
    public void setEnabled(boolean boo) {
        super.setEnabled(boo);
        this.m_usernameLabel.setEnabled(boo);
        this.m_driverLabel.setEnabled(boo);
        this.m_urlLabel.setEnabled(boo);
        if (!boo) {
            this.m_usernameField.setText(null);
            this.m_driverField.setText(null);
            this.m_urlField.setText(null);
            this.m_urlField.setToolTipText(null);
        }
    }

    public void populateDetails(ConnectionInfo connInfo) {
        this.populateDetails(connInfo == null ? null : connInfo.getReferenceable());
    }

    public void populateDetails(DatabaseProvider connPro) {
        this.setEnabled(connPro != null);
        this.m_usernameField.setText(ConnectionDetails.getUserName(connPro));
        this.m_driverField.setText(ConnectionDetails.getDriverClassName(connPro));
        String url = ConnectionDetails.getConnectionURL(connPro);
        this.m_urlField.setText(url);
        this.m_urlField.setToolTipText(url);
    }

    private static String getUserName(DatabaseProvider connPro) {
        return connPro == null ? null : connPro.getProperty("user");
    }

    private static String getDriverClassName(DatabaseProvider connPro) {
        String driver = null;
        try {
            driver = connPro == null ? null : connPro.getDriverClassName();
        }
        catch (SQLException sqe) {
            driver = null;
        }
        return driver;
    }

    private static String getConnectionURL(DatabaseProvider connPro) {
        String url = null;
        try {
            url = connPro == null ? null : connPro.getConnectionURL();
        }
        catch (SQLException e) {
            url = null;
        }
        return url;
    }

    public static String getTooltipText(ConnectionInfo connInfo) {
        String retval = null;
        if (connInfo != null) {
            retval = ConnectionDetails.getTooltipText(connInfo.getReferenceable());
        }
        return retval;
    }

    public static String getTooltipText(DatabaseProvider connPro) {
        String retval = null;
        if (connPro != null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(ConnBundle.get("LABEL_USERNAME"), ConnectionDetails.getUserName(connPro));
            map.put(ConnBundle.get("LABEL_DRIVER"), ConnectionDetails.getDriverClassName(connPro));
            map.put(ConnBundle.get("LABEL_URL"), ConnectionDetails.getConnectionURL(connPro));
            retval = DBUIResourceHelper.createPropertiesText(map);
        }
        return retval;
    }
}

