/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.awt.Window;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.StoreContext;

public class DatabaseActions
implements Controller {
    private static final String NEW_CONNECTION_ID = "oracle.jdeveloper.db.NewConnection";
    private static final String DISONNECT_ID = "oracle.jdeveloper.db.DisconnectConnection";
    public static final String EDIT_CONNECTION = "ConnectionName";
    public static final String CONNECTION_STORE = "ConnectionStore";

    protected DatabaseActions() {
    }

    public static IdeAction getConnectionEditorAction() {
        return IdeAction.find((String)NEW_CONNECTION_ID);
    }

    public static IdeAction getDisconnectAction() {
        return IdeAction.find((String)DISONNECT_ID);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int id = action.getCommandId();
        if (id == DatabaseActions.getConnectionEditorAction().getCommandId()) {
            String connName = (String)action.getValue(EDIT_CONNECTION);
            String storeName = (String)action.getValue(CONNECTION_STORE);
            this.handleConnectionEditor(storeName, connName, context);
            return true;
        }
        if (id == DatabaseActions.getDisconnectAction().getCommandId()) {
            this.handleDisconnect(context);
            return true;
        }
        return false;
    }

    protected boolean handleDisconnect(Context context) {
        String conn;
        boolean disconnectOK = false;
        DatabaseConnectionStores stores = DatabaseConnectionStores.getInstance();
        DatabaseConnections conns = stores.getCurrentStore(context);
        if (conns != null && (conn = stores.getCurrentConnection(context)) != null) {
            try {
                conns.disconnect(conn);
                disconnectOK = true;
            }
            catch (ConnectionException ce) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ce);
            }
        }
        return disconnectOK;
    }

    protected void handleConnectionEditor(String storeName, String name, Context c) {
        DatabaseConnectionStores stores;
        DatabaseConnections conns;
        if (!ModelUtil.hasLength((String)storeName) && (conns = (stores = DatabaseConnectionStores.getInstance()).getCurrentStore(c)) != null) {
            storeName = conns.getStoreName();
        }
        DatabaseConnectionEditorLauncher launcher = DatabaseConnectionEditor.createLauncher();
        launcher.setEnsureVisible(true);
        if (StoreContext.getContext().isGlobalContext(c)) {
            launcher.setStoreChoice(DatabaseConnectionEditorLauncher.StoreChoice.ALL);
        }
        launcher.launchEditor(storeName, name);
    }

    public boolean update(IdeAction action, Context context) {
        int id = action.getCommandId();
        if (id == DatabaseActions.getConnectionEditorAction().getCommandId()) {
            action.setEnabled(true);
            return true;
        }
        if (id == DatabaseActions.getDisconnectAction().getCommandId()) {
            boolean enabled;
            DatabaseConnectionStores stores = DatabaseConnectionStores.getInstance();
            Element elem = context.getElement();
            boolean bl = enabled = stores.getCurrentConnection(context) != null;
            if (enabled && elem instanceof Node) {
                enabled = ((Node)elem).isOpen();
            }
            action.setEnabled(enabled);
            return true;
        }
        return false;
    }
}

