/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.sqltuningadvisor;

import java.awt.Component;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorAction;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorArb;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorPanel;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAnalyzeAction;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;

public class SqlTuningAdvisorActionProvider
implements ActionProvider<Boolean> {
    public static final String SQLTUNINGADVISOR_CMD_ID = "Worksheet.SQLTuningAdvisor";
    private WorksheetAction sqlTuningAdvisorAction = WorksheetAction.createWorksheetAction("Worksheet.SQLTuningAdvisor", WorksheetAction.ActionType.BOTH, 0, -10.0);
    public static final Version MAX_VERSION = new Version("99.0");
    public static final Version MIN_VERSION = new Version("10.0");

    @Override
    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        if (worksheetContext.isBusy()) {
            return false;
        }
        BasicDocument basicDocument = (BasicDocument)worksheetContext.getEditor().getDocument();
        try {
            String string2;
            if (basicDocument.getLength() > 0 && (string2 = worksheetContext.getConnectionName()) != null && Connections.getInstance().isConnectionOpen(string2)) {
                return SqlTuningAdvisorActionProvider.isOracleConnection(string, string2) && SqlTuningAdvisorActionProvider.canSqlTuningAdvisor(string, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isOracleConnection(String string, String string2) throws DBException, SQLException {
        return !SQLTUNINGADVISOR_CMD_ID.equals(string) || Connections.getInstance().isOracle(string2);
    }

    @Override
    public WorksheetTaskWrapper<Boolean> doAction(String string, WorksheetContext worksheetContext) {
        SqlTuningAnalyzeAction sqlTuningAnalyzeAction = null;
        try {
            if (!SqlTuningAdvisorActionProvider.canSqlTuningAdvisor(string, worksheetContext.getConnectionName())) {
                return null;
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        if (SQLTUNINGADVISOR_CMD_ID.equals(string)) {
            sqlTuningAnalyzeAction = new SqlTuningAdvisorAction(string, worksheetContext);
        }
        boolean bl = sqlTuningAnalyzeAction.checkForSingleOrMultipleSqlStatements();
        String string2 = null;
        String string3 = "'ADVISOR'";
        String string4 = "'ADMINISTER SQL TUNING SET'";
        String string5 = "'SELECT ANY DICTIONARY'";
        try {
            string2 = Connections.getInstance().getConnection(worksheetContext.getConnectionName()).getMetaData().getUserName();
        }
        catch (SQLException sQLException) {
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (!bl) {
            if (!this.checkForSqlTuningPrivileges(worksheetContext.getConnectionName(), string3)) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(SqlTuningAdvisorArb.getString("NO_ADVISOR_PRIVILEGE_ERR"), "'" + string2 + "'"), (String)SqlTuningAdvisorArb.getString("ACTION_REQUIRED_TITLE"), null);
                return null;
            }
        } else {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            bl2 = this.checkForSqlTuningPrivileges(worksheetContext.getConnectionName(), string3);
            bl3 = this.checkForSqlTuningPrivileges(worksheetContext.getConnectionName(), string4);
            bl4 = this.checkForSqlTuningPrivileges(worksheetContext.getConnectionName(), string5);
            StringBuffer stringBuffer = new StringBuffer();
            if (!bl2) {
                stringBuffer.append(string3);
                bl5 = true;
            }
            if (!bl3) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(", ").append(string4);
                } else {
                    stringBuffer.append(string4);
                }
                bl5 = true;
            }
            if (!bl4) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(", ").append(string5);
                } else {
                    stringBuffer.append(string5);
                }
                bl5 = true;
            }
            if (bl5) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(SqlTuningAdvisorArb.getString("NO_SQLSET_PRIVILEGE_ERR"), "'" + string2 + "'", stringBuffer.toString()), (String)SqlTuningAdvisorArb.getString("ACTION_REQUIRED_TITLE"), null);
                return null;
            }
        }
        SqlTuningAdvisorPanel sqlTuningAdvisorPanel = new SqlTuningAdvisorPanel(string, SQLTUNINGADVISOR_CMD_ID.equals(string));
        sqlTuningAnalyzeAction.setSqlTuningAdvisorPanel(sqlTuningAdvisorPanel);
        ArrayList<IRaptorTaskListener> arrayList = new ArrayList<IRaptorTaskListener>();
        arrayList.add((IRaptorTaskListener)new SqlTuningAdvisorPanel.ResultsPanelTaskListener(sqlTuningAdvisorPanel));
        for (IRaptorTaskListener iRaptorTaskListener : arrayList) {
            sqlTuningAnalyzeAction.getDescriptor().addListener(iRaptorTaskListener);
        }
        return sqlTuningAnalyzeAction != null ? new WorksheetTaskWrapper<Boolean>(sqlTuningAnalyzeAction, arrayList, Collections.EMPTY_LIST, worksheetContext) : null;
    }

    public static boolean canSqlTuningAdvisor(String string, String string2) throws DBException, SQLException {
        if (!DBUtil.checkVersion((String)string2, (Version)MAX_VERSION, (Version)MIN_VERSION)) {
            return false;
        }
        return SqlTuningAdvisorActionProvider.isRegistered(string2);
    }

    private static boolean isRegistered(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            return false;
        }
        String string2 = properties.getProperty("driver");
        return string2 != null;
    }

    private boolean checkForSqlTuningPrivileges(String string, String string2) {
        String string3 = "SELECT count(1) FROM session_privs WHERE privilege = " + string2;
        boolean bl = false;
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        String string4 = dBUtil.executeReturnOneCol(string3);
        if (!string4.equals("0")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public WorksheetAction getActionAt(int n) {
        return this.sqlTuningAdvisorAction;
    }

    @Override
    public int getActionsCount() {
        return 1;
    }

    @Override
    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    @Override
    public int getPanelCount() {
        return 0;
    }
}

