/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.util.Service;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeModel;
import oracle.dbtools.worksheet.commands.autotrace.RowSrcNode;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.ide.Ide;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.IdeUtil;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.treetable.JTreeTable;

public class PopupAction
extends MouseAdapter {
    public JTreeTable tbl;
    AutotraceTreeModel mdl;
    public JTreeTable tbl2 = null;
    AutotraceTreeModel md2 = null;
    JPopupMenu popup = this.getPopupMenu();
    Point mousePos = null;

    public PopupAction(JTreeTable jTreeTable, AutotraceTreeModel autotraceTreeModel) {
        this.tbl = jTreeTable;
        this.mdl = autotraceTreeModel;
    }

    public PopupAction(JTreeTable jTreeTable, AutotraceTreeModel autotraceTreeModel, JTreeTable jTreeTable2, AutotraceTreeModel autotraceTreeModel2) {
        this.tbl = jTreeTable;
        this.mdl = autotraceTreeModel;
        this.tbl2 = jTreeTable2;
        this.md2 = autotraceTreeModel2;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
        this.collapseExpand(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void checkPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.mousePos = this.tbl.getMousePosition();
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void collapseExpand(MouseEvent mouseEvent) {
        TreePath treePath;
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        JTree jTree = this.tbl.getTree();
        if (mouseEvent.getSource() == this.tbl2) {
            jTree = this.tbl2.getTree();
        }
        if (jTree.isCollapsed(treePath = jTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()))) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
        this.tbl.revalidate();
        if (this.tbl2 != null) {
            this.tbl2.revalidate();
        }
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("AutotracePanel.6"), OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SerializedData serializedData = SerializedData.getInstance();
                serializedData.collapsePredNodes = false;
                SerializedData.write();
                PopupAction.this.expandPredicates();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("Expand_All"), OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupAction.this.expandAll();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("AutotracePanel.7"), OracleIcons.getIcon((String)"collapseall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SerializedData serializedData = SerializedData.getInstance();
                serializedData.collapsePredNodes = true;
                SerializedData.write();
                PopupAction.this.collapsePredicates();
            }
        });
        if (this.tbl2 == null) {
            jMenuItem = new JMenuItem(Messages.getString("AutotracePanel.8"), OracleIcons.getIcon((String)"collapseall.png"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PopupAction.this.mousePos != null) {
                        JTree jTree = PopupAction.this.tbl.getTree();
                        TreePath treePath = jTree.getClosestPathForLocation(PopupAction.this.mousePos.x, PopupAction.this.mousePos.y);
                        int n = jTree.getRowForPath(treePath);
                        TreePath treePath2 = treePath.getParentPath();
                        int n2 = jTree.getRowForPath(treePath2);
                        for (int i = n - 1; n2 < i; --i) {
                            TreePath treePath3 = jTree.getPathForRow(i);
                            if (treePath3.getPathCount() != treePath.getPathCount()) continue;
                            jTree.collapsePath(treePath3);
                        }
                    }
                }
            });
        }
        jMenuItem = new JMenuItem(Messages.getString("Export"), null);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupAction.this.export();
            }
        });
        return jPopupMenu;
    }

    private void collapsePredicates() {
        PopupAction.collapsePredicates(this.tbl);
        if (this.tbl2 != null) {
            PopupAction.collapsePredicates(this.tbl2);
        }
    }

    private static void collapsePredicates(JTreeTable jTreeTable) {
        JTree jTree = jTreeTable.getTree();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            RowSrcNode rowSrcNode = (RowSrcNode)treePath.getLastPathComponent();
            if (!rowSrcNode.toString().endsWith("Predicates") && !rowSrcNode.toString().endsWith("Projection")) continue;
            jTree.collapsePath(treePath);
        }
        jTreeTable.revalidate();
    }

    private void expandPredicates() {
        PopupAction.expandPredicates(this.tbl);
        if (this.tbl2 != null) {
            PopupAction.expandPredicates(this.tbl2);
        }
    }

    private static void expandPredicates(JTreeTable jTreeTable) {
        JTree jTree = jTreeTable.getTree();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            boolean bl = false;
            for (Object object : treePath.getPath()) {
                RowSrcNode rowSrcNode = (RowSrcNode)object;
                if (!rowSrcNode.toString().endsWith("Predicates") && !rowSrcNode.toString().endsWith("Projection")) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            jTree.expandPath(treePath);
        }
        jTreeTable.revalidate();
    }

    private void expandAll() {
        PopupAction.expandAll(this.tbl);
        if (this.tbl2 != null) {
            PopupAction.expandAll(this.tbl2);
        }
    }

    private static void expandAll(JTreeTable jTreeTable) {
        JTree jTree = jTreeTable.getTree();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            jTree.expandPath(treePath);
        }
        jTreeTable.revalidate();
    }

    private void export() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        WildcardURLFilter wildcardURLFilter = new WildcardURLFilter("*.html", false, "HTML File");
        uRLFileChooser.addChooseableURLFilter((URLFilter)wildcardURLFilter);
        int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), "Export HTML");
        if (n != 0) {
            return;
        }
        URL uRL = uRLFileChooser.getSelectedURL();
        String string = uRL.getPath();
        int n2 = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        if (string.lastIndexOf(46) <= n2) {
            string = string + ".html";
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            String string2 = IdeUtil.getIdeEncoding();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string2);
            if (this.mdl.cmp == null) {
                outputStreamWriter.write(this.mdl.createHtmlWidget(this.tbl.getTree()).render());
            } else {
                outputStreamWriter.write("<TABLE border=0 cellpadding=0 cellspacing=0 width=100%><tr><td> \n");
                outputStreamWriter.write(this.mdl.createHtmlWidget(this.tbl.getTree()).render());
                outputStreamWriter.write("</td><td> \n");
                outputStreamWriter.write(this.mdl.cmp.createHtmlWidget(this.tbl2.getTree()).render());
                outputStreamWriter.write("</td></tr></TABLE> \n");
            }
            outputStreamWriter.close();
            File file = new File(string);
            String string3 = file.getParent() + File.separatorChar + "images";
            new File(string3).mkdir();
            ClassLoader classLoader = this.getClass().getClassLoader();
            for (URL uRL2 : FileUtils.getFilesInPackage((String)"oracle.dbtools.worksheet.images", (ClassLoader)classLoader, (String)"png")) {
                Service.copy((URL)uRL2, (String)string3);
            }
            for (URL uRL2 : FileUtils.getFilesInPackage((String)"oracle.dbtools.worksheet.images", (ClassLoader)classLoader, (String)"gif")) {
                Service.copy((URL)uRL2, (String)string3);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }
}

