/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetFeatures;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.commands.autotrace.AbstractPanel;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeModel;
import oracle.dbtools.worksheet.commands.autotrace.ComparisonPanel;
import oracle.dbtools.worksheet.commands.autotrace.NodeRenderer;
import oracle.dbtools.worksheet.commands.autotrace.PopupAction;
import oracle.dbtools.worksheet.commands.autotrace.RowSrcNode;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.treetable.JTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;

public class AutotracePanel
extends AbstractPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(AutotracePanel.class.getName());
    public JTreeTable tbl;
    private AutotraceTreeModel mdl = null;
    public JTable mystats;
    public Property mystatsData = new Property();
    JTextField filterWidget;
    Map<Integer, HOTSPOT> hotSpots = null;
    Map<HOTSPOT, Integer> hotSpotColumns = new HashMap<HOTSPOT, Integer>();
    final TableCellRenderer cellRenderer = new CellRenderer();

    public AutotraceTreeModel getATMdl() {
        return this.mdl;
    }

    public AutotracePanel(String string, boolean bl, WorksheetContext worksheetContext) {
        super(string, bl ? Messages.getString("AutotracePanel.0") : Messages.getString("AutotracePanel.1"));
        this.isExplainPlan = bl;
        Properties properties = Connections.getInstance().getConnectionInfo(worksheetContext.getConnectionName());
        if (properties != null) {
            String string2 = properties.getProperty("driver");
            WorksheetFeatures worksheetFeatures = WorksheetFeatures.getFeatures(string2);
            Constructor<? extends AutotraceTreeModel> constructor = worksheetFeatures.getAutotraceModelConstructor();
            try {
                this.mdl = constructor.newInstance(this);
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, Messages.getString("ExplainPlanAction.2"), exception);
            }
        }
        this.init();
        oracle.dbtools.raptor.SerializedData.getInstance().addObserver((Observer)this);
        try {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_autotrace_html");
        }
        catch (Exception exception) {
            System.err.println("Fine if standalone test : " + exception.getMessage());
        }
    }

    public AutotracePanel(String string, boolean bl, String string2) {
        super(string, bl ? Messages.getString("AutotracePanel.0") : Messages.getString("AutotracePanel.1"));
        this.isExplainPlan = bl;
        WorksheetFeatures worksheetFeatures = WorksheetFeatures.getFeatures(string2);
        Constructor<? extends AutotraceTreeModel> constructor = worksheetFeatures.getAutotraceModelConstructor();
        try {
            this.mdl = constructor.newInstance(this);
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, Messages.getString("ExplainPlanAction.2"), exception);
        }
        this.init();
        oracle.dbtools.raptor.SerializedData.getInstance().addObserver((Observer)this);
        try {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_autotrace_html");
        }
        catch (Exception exception) {
            System.err.println("Fine if standalone test : " + exception.getMessage());
        }
    }

    public void mdlReset() {
        this.getATMdl().reset();
    }

    public void mdlReload(String string, String string2, Connection connection) {
        this.getATMdl().reload(string, string2, connection);
    }

    public void explainPlan(String string, String string2, Connection connection) {
        this.getATMdl().explainPlan(string, string2, connection);
    }

    public void fetchPlan(String string, String string2, Connection connection) {
        this.getATMdl().fetchPlan(string, string2, connection);
        this.getATMdl().reload(this.tbl.getTree());
    }

    private void init() {
        Serializable serializable;
        this.tbl = new JTreeTable((TreeTableModel)this.getATMdl()){

            protected Boolean isZebraRows() {
                return DBConfig.getInstance().getBoolean("ZEBRA_ROWS");
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = null;
                component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (n2 != 0 && this.isZebraRows().booleanValue() && !this.isCellSelected(n, n2)) {
                    if (n % 2 == 0 && n2 % 2 == 0) {
                        component.setBackground(RaptorGridTable.color00);
                    } else if (n % 2 == 0 && n2 % 2 == 1) {
                        component.setBackground(RaptorGridTable.color10);
                    } else if (n % 2 == 1 && n2 % 2 == 0) {
                        component.setBackground(RaptorGridTable.color01);
                    } else if (n % 2 == 1 && n2 % 2 == 1) {
                        component.setBackground(RaptorGridTable.color11);
                    }
                }
                return component;
            }
        };
        this.tbl.setAutoResizeMode(0);
        this.tbl.setCellSelectionEnabled(false);
        this.tbl.setColumnSelectionAllowed(false);
        this.tbl.setRowSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane((Component)this.tbl);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        for (int i = 1; i < this.tbl.getColumnModel().getColumnCount(); ++i) {
            serializable = this.tbl.getColumnModel().getColumn(i);
            serializable.setCellRenderer(this.cellRenderer);
        }
        JTree jTree = this.tbl.getTree();
        jTree.setCellRenderer(new NodeRenderer(this.tbl));
        jTree.setShowsRootHandles(true);
        serializable = this.tbl.getBackground();
        jScrollPane.setBackground((Color)serializable);
        jScrollPane.getViewport().setBackground((Color)serializable);
        this.tbl.addMouseListener((MouseListener)new PopupAction(this.tbl, this.getATMdl()));
        this.setLayout(new BorderLayout());
        SerializedData.initColumnWidths(this.tbl);
        if (this.isExplainPlan) {
            this.add((Component)jScrollPane, "Center");
        } else {
            this.mystats = new JTable(this.mystatsData);
            JScrollPane jScrollPane2 = new JScrollPane(this.mystats);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel2.add("V$STATNAME Name", new JLabel(OracleIcons.getIcon((String)"filter.png")));
            jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
            this.filterWidget = new JTextField(20);
            this.filterWidget.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    AutotracePanel.this.mystatsData.nonZeroValuedRow2ActualRow = null;
                    AutotracePanel.this.mystats.revalidate();
                }
            });
            jPanel2.add(this.filterWidget);
            jPanel.add(jPanel2);
            jPanel.add(jScrollPane2);
            JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerLocation(SerializedData.getInstance().dividerLocation);
            jSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
                    int n = jSplitPane.getDividerLocation();
                    SerializedData serializedData = SerializedData.getInstance();
                    int n2 = serializedData.dividerLocation;
                    if (Math.abs(n - n2) > 10) {
                        serializedData.dividerLocation = n;
                    }
                    SerializedData.write();
                }
            });
            this.add((Component)jSplitPane, "Center");
        }
        this.initToolbar();
    }

    @Override
    void addSQLbutton() {
        HyperlinkButton hyperlinkButton = new HyperlinkButton("SQL");
        hyperlinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GhostPalette ghostPalette = new GhostPalette();
                ghostPalette.setHideOnLoseFocus(true);
                ghostPalette.fadeInOut(true);
                ghostPalette.setLook(UIConstants.Look.LIGHT);
                int n = AutotracePanel.this.getLocation().x;
                int n2 = AutotracePanel.this.getLocation().y;
                Point point = new Point(n, n2);
                point = SwingUtilities.convertPoint(AutotracePanel.this, point, null);
                ghostPalette.setLocation(point);
                ghostPalette.setTitle(AutotracePanel.this.getTabLabel() + " SQL");
                MultiLineLabel multiLineLabel = new MultiLineLabel();
                multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
                multiLineLabel.setText(AutotracePanel.this.getATMdl().originalSQL);
                JScrollPane jScrollPane = new JScrollPane((Component)multiLineLabel, 20, 30);
                jScrollPane.setPreferredSize(new Dimension(AutotracePanel.this.getSize().width / 2, AutotracePanel.this.getSize().height / 2));
                final HyperlinkButton hyperlinkButton = new HyperlinkButton(Messages.getString("StatementRunnerResultsPanel.2"));
                hyperlinkButton.setBorder(BorderFactory.createEmptyBorder());
                hyperlinkButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StringSelection stringSelection = new StringSelection(AutotracePanel.this.getATMdl().originalSQL);
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        ClipboardStack.pushCurrentClipboard();
                        clipboard.setContents(stringSelection, stringSelection);
                        hyperlinkButton.setSelected(false);
                    }
                });
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)jScrollPane, "Center");
                jPanel.add((Component)hyperlinkButton, "South");
                ghostPalette.add((Component)jPanel);
                ghostPalette.setSize(jScrollPane.getPreferredSize());
                ghostPalette.show(Ide.getMainWindow().getLayeredPane(), false, false);
            }
        });
        this._toolbar.add((Component)hyperlinkButton);
    }

    @Override
    void addHotspotButton() {
        HyperlinkButton hyperlinkButton = new HyperlinkButton(Messages.getString("AutotracePanel.HotSpot"));
        hyperlinkButton.setToolTipText(Messages.getString("AutotracePanel.HotSpotTooltip"));
        hyperlinkButton.addActionListener(new ActionListener(){
            int currentHotSpot = -1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                JTree jTree = AutotracePanel.this.tbl.getTree();
                if (AutotracePanel.this.hotSpots == null) {
                    int n;
                    Iterator iterator;
                    int n2;
                    Number number;
                    RowSrcNode rowSrcNode;
                    oracle.dbtools.raptor.SerializedData.getInstance().autotraceOptions.put("LAST_ELAPSED_TIME", true);
                    oracle.dbtools.raptor.SerializedData.getInstance().autotraceOptions.put("LAST_OUTPUT_ROWS", true);
                    oracle.dbtools.raptor.SerializedData.getInstance().autotraceOptions.put("CARDINALITY", true);
                    oracle.dbtools.raptor.SerializedData.getInstance().notifyObservers();
                    AutotracePanel.this.hotSpots = new TreeMap<Integer, HOTSPOT>();
                    for (int i = 0; i < AutotracePanel.this.tbl.getColumnCount(); ++i) {
                        if ("LAST_ELAPSED_TIME".equals(AutotracePanel.this.tbl.getColumnName(i))) {
                            AutotracePanel.this.hotSpotColumns.put(HOTSPOT.runtime, i);
                            continue;
                        }
                        if (!"CARDINALITY".equals(AutotracePanel.this.tbl.getColumnName(i))) continue;
                        AutotracePanel.this.hotSpotColumns.put(HOTSPOT.cardMismatch, i);
                    }
                    TreeMap<Integer, Number> treeMap = new TreeMap<Integer, Number>();
                    for (int i = 0; i < jTree.getRowCount(); ++i) {
                        TreePath treePath = jTree.getPathForRow(i);
                        rowSrcNode = (RowSrcNode)treePath.getLastPathComponent();
                        if (rowSrcNode.isSpanned() || (Long)(number = rowSrcNode.individualRunTime()) < 1000L) continue;
                        n2 = -1;
                        iterator = treeMap.keySet().iterator();
                        if (iterator.hasNext()) {
                            n = (Integer)iterator.next();
                            if ((Long)treeMap.get(n) < (Long)number) {
                                n2 = n;
                            } else {
                                number = null;
                            }
                        }
                        if (n2 != -1 && 3 <= treeMap.size()) {
                            treeMap.remove(n2);
                        }
                        if (number == null) continue;
                        treeMap.put(i, number);
                    }
                    Iterator iterator2 = treeMap.keySet().iterator();
                    while (iterator2.hasNext()) {
                        int n3 = (Integer)iterator2.next();
                        AutotracePanel.this.hotSpots.put(n3, HOTSPOT.runtime);
                    }
                    treeMap = new TreeMap();
                    for (int i = 0; i < jTree.getRowCount(); ++i) {
                        TreePath treePath = jTree.getPathForRow(i);
                        rowSrcNode = (RowSrcNode)treePath.getLastPathComponent();
                        if (rowSrcNode.rows() == null || rowSrcNode.cardinality() == null || rowSrcNode.rows() == rowSrcNode.cardinality()) continue;
                        number = ((double)rowSrcNode.rows().longValue() + 1.0) / (double)(rowSrcNode.cardinality() + 1L);
                        if ((Double)number < 1.0) {
                            number = 1.0 / (Double)number;
                        }
                        n2 = -1;
                        iterator = treeMap.keySet().iterator();
                        if (iterator.hasNext()) {
                            n = (Integer)iterator.next();
                            if ((Double)treeMap.get(n) * 1.5 < (Double)number) {
                                n2 = n;
                            } else {
                                number = null;
                            }
                        }
                        if (n2 != -1 && 3 <= treeMap.size()) {
                            treeMap.remove(n2);
                        }
                        if (number == null) continue;
                        treeMap.put(i, number);
                    }
                    object = treeMap.keySet().iterator();
                    while (object.hasNext()) {
                        int n4 = (Integer)object.next();
                        AutotracePanel.this.hotSpots.put(n4, HOTSPOT.cardMismatch);
                    }
                }
                if ("true".equals(HiddenParameters.parameters.get("debugHotspot"))) {
                    System.out.println(AutotracePanel.this.hotSpots);
                }
                for (int n : AutotracePanel.this.hotSpots.keySet()) {
                    object = jTree.getPathForRow(n);
                    if (this.currentHotSpot >= n) continue;
                    this.currentHotSpot = n;
                    if ("true".equals(HiddenParameters.parameters.get("debugHotspot"))) {
                        System.out.println("hotSpotRow =" + this.currentHotSpot);
                    }
                    HOTSPOT hOTSPOT = AutotracePanel.this.hotSpots.get(n);
                    AutotracePanel.this.tbl.scrollToVisible(this.currentHotSpot, AutotracePanel.this.hotSpotColumns.get((Object)hOTSPOT).intValue());
                    AutotracePanel.this.tbl.setRowSelectionInterval(this.currentHotSpot, AutotracePanel.this.hotSpotColumns.get((Object)hOTSPOT).intValue());
                    return;
                }
                this.currentHotSpot = -1;
            }
        });
        this._toolbar.add((Component)hyperlinkButton);
    }

    static Object colorize(Object object, String string) {
        if (string.length() == 0) {
            return object;
        }
        String string2 = object.toString();
        StringBuilder stringBuilder = new StringBuilder("<html>");
        int n = string2.indexOf(string);
        if (0 <= n) {
            stringBuilder.append(string2.substring(0, n));
        } else {
            stringBuilder.append(string2);
        }
        while (0 <= n) {
            stringBuilder.append("<font color=blue>");
            stringBuilder.append(string);
            stringBuilder.append("</font>");
            int n2 = string2.indexOf(string, n + string.length());
            if (0 <= n2) {
                stringBuilder.append(string2.substring(n + string.length(), n2));
            } else {
                stringBuilder.append(string2.substring(n + string.length()));
            }
            n = n2;
        }
        return stringBuilder;
    }

    public static boolean showMyStat() {
        return oracle.dbtools.raptor.SerializedData.getInstance().myStat;
    }

    public String getSQL() {
        return this.getATMdl().getSQL();
    }

    @Override
    public Icon getTabIcon() {
        Icon icon = super.getTabIcon();
        if (icon != null) {
            return icon;
        }
        if (this.isExplainPlan) {
            return OracleIcons.getIcon((String)"explain.png");
        }
        return RaptorImagesArb.getIcon((String)"AUTOTRACE");
    }

    public void open() {
        SerializedData.initColumnWidths(this.tbl);
        this.mdlReset();
    }

    @Override
    public JMenuItem[] getTabDynamicCtxMenu(WorksheetResultPanel[] worksheetResultPanelArray) {
        LinkedList<JMenuItem> linkedList = new LinkedList<JMenuItem>();
        for (final WorksheetResultPanel worksheetResultPanel : worksheetResultPanelArray) {
            if (!(worksheetResultPanel instanceof AutotracePanel)) continue;
            JMenuItem jMenuItem = new JMenuItem(Messages.getString("Compare_with") + " " + worksheetResultPanel.getTabLabel());
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AutotracePanel.this.cmp((AutotracePanel)worksheetResultPanel);
                }
            });
            linkedList.add(jMenuItem);
        }
        return linkedList.toArray(new JMenuItem[0]);
    }

    protected void cmp(AutotracePanel autotracePanel) {
        WorksheetContext worksheetContext = this.getContext();
        ComparisonPanel comparisonPanel = new ComparisonPanel(this, autotracePanel);
        worksheetContext.getCallback().showResultPanel(comparisonPanel);
    }

    public boolean isExplainPlanGetter() {
        return this.isExplainPlan;
    }

    @Override
    public void update(Observable observable, Object object) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractTableModel abstractTableModel = (AbstractTableModel)AutotracePanel.this.tbl.getModel();
                abstractTableModel.fireTableStructureChanged();
                AutotracePanel.this.tbl.revalidate();
                SerializedData.initColumnWidths(AutotracePanel.this.tbl);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CellRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            String string = (String)object;
            try {
                Long.valueOf(string);
                jLabel.setHorizontalAlignment(4);
            }
            catch (Exception exception) {
                jLabel.setHorizontalAlignment(2);
            }
            string = AutotracePanel.this.tbl.getColumnName(n2) + "=" + string;
            jLabel.setToolTipText(string);
            TreePath treePath = AutotracePanel.this.tbl.getTree().getPathForRow(n);
            RowSrcNode rowSrcNode = (RowSrcNode)treePath.getLastPathComponent();
            jLabel.setForeground(Color.black);
            jLabel.setIcon(null);
            if (AutotracePanel.this.hotSpots == null || rowSrcNode == null) {
                return jLabel;
            }
            HOTSPOT hOTSPOT = AutotracePanel.this.hotSpots.get(n);
            for (HOTSPOT hOTSPOT2 : AutotracePanel.this.hotSpotColumns.keySet()) {
                if (hOTSPOT2 == HOTSPOT.runtime && n2 == AutotracePanel.this.hotSpotColumns.get((Object)hOTSPOT2)) {
                    jLabel.setToolTipText(this.colorizeRunTime(string, rowSrcNode, hOTSPOT != null && n2 == AutotracePanel.this.hotSpotColumns.get((Object)hOTSPOT)));
                    continue;
                }
                if (hOTSPOT2 != HOTSPOT.cardMismatch || n2 != AutotracePanel.this.hotSpotColumns.get((Object)hOTSPOT2)) continue;
                jLabel.setToolTipText(this.colorizeCard(string, rowSrcNode, hOTSPOT != null && n2 == AutotracePanel.this.hotSpotColumns.get((Object)hOTSPOT)));
            }
            if (hOTSPOT != null && n2 == AutotracePanel.this.hotSpotColumns.get((Object)hOTSPOT)) {
                jLabel.setForeground(Color.red);
                jLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
            }
            return jLabel;
        }

        private String colorizeRunTime(String string, RowSrcNode rowSrcNode, boolean bl) {
            String string2 = bl ? "red" : "blue";
            long l = rowSrcNode.individualRunTime();
            String string3 = 0L < l / 1000000L ? "<b>" + l / 1000000L + "</b>" : "";
            String string4 = "" + l % 1000000L;
            return "<html><font color=blue>" + Messages.getString("AutotracePanel.IndividualRuntime") + "=<font color=" + string2 + ">" + string3 + string4 + "<br><font color=black>" + string + "</html>";
        }

        private String colorizeCard(String string, RowSrcNode rowSrcNode, boolean bl) {
            String string2 = bl ? "red" : "blue";
            String string3 = rowSrcNode.cardinality() == null ? "<NULL>" : rowSrcNode.cardinality().toString();
            String string4 = rowSrcNode.rows() == null ? "<NULL>" : rowSrcNode.rows().toString();
            return "<html><font color=blue>CARDINALITY=<font color=" + string2 + ">" + string3 + "<br><font color=black>LAST_OUTPUT_ROWS=" + string4 + "</html>";
        }
    }

    public final class Property
    extends AbstractTableModel {
        public Map<Integer, String> names = new HashMap<Integer, String>();
        public Map<Integer, Long> values = new TreeMap<Integer, Long>();
        private Map<Integer, Integer> nonZeroValuedRow2ActualRow = null;

        public int nonFilteredNonZeroValuedRowsCount() {
            if (this.nonZeroValuedRow2ActualRow == null) {
                this.calculateNonZeroValuedRow2ActualRow();
            }
            return this.nonZeroValuedRow2ActualRow.size();
        }

        public void calculateNonZeroValuedRow2ActualRow() {
            this.nonZeroValuedRow2ActualRow = new HashMap<Integer, Integer>();
            int n = -1;
            for (int n2 : this.values.keySet()) {
                if (oracle.dbtools.raptor.SerializedData.getInstance().abbrevStat && this.values.get(n2) == 0L || !this.names.get(n2).contains(AutotracePanel.this.filterWidget.getText())) continue;
                this.nonZeroValuedRow2ActualRow.put(++n, n2);
            }
        }

        public void reset() {
            this.names = new HashMap<Integer, String>();
            this.values = new HashMap<Integer, Long>();
            this.nonZeroValuedRow2ActualRow = null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "V$STATNAME Name";
            }
            return "V$MYSTAT Value";
        }

        @Override
        public int getRowCount() {
            return this.nonFilteredNonZeroValuedRowsCount();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 1) {
                return this.values.get(this.nonZeroValuedRow2ActualRow.get(n));
            }
            return AutotracePanel.colorize(this.names.get(this.nonZeroValuedRow2ActualRow.get(n)), AutotracePanel.this.filterWidget.getText());
        }
    }

    static enum HOTSPOT {
        cardMismatch,
        runtime;

    }
}

