/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.sql.Connection;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.utils.CursorUI;
import oracle.ide.help.HelpSystem;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

abstract class AnalyzeAction
extends RaptorTask<Void> {
    protected WorksheetContext ctx;
    int cursorPosition = 0;
    int cursorStart = 0;
    int cursorEnd = 0;
    protected Connection conn;
    protected AutotracePanel autoTracePanel = null;

    public AnalyzeAction(String string, String string2, WorksheetContext worksheetContext) {
        super(string, true, IRaptorTaskRunMode.TASKVIEWER);
        this.ctx = worksheetContext;
        this.setPausable(false);
        this.setCancellable(true);
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    public AutotracePanel getAutoTracePanel() {
        return this.autoTracePanel;
    }

    public void setAutoTracePanel(AutotracePanel autotracePanel) {
        this.autoTracePanel = autotracePanel;
        this.autoTracePanel.setContext(this.ctx);
    }

    public String extractSql(String string) {
        this.cursorPosition = this.ctx.getEditor().getCaretPosition();
        this.cursorStart = this.ctx.getEditor().getSelectionStart();
        this.cursorEnd = this.ctx.getEditor().getSelectionEnd();
        String string2 = this.getSqlStatement();
        return AnalyzeAction.extractSql(this.ctx, this.cursorPosition, string2, string);
    }

    public static String extractSql(WorksheetContext worksheetContext, int n, String string, String string2) {
        BasicDocument basicDocument = (BasicDocument)worksheetContext.getEditor().getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n);
        ScriptParser scriptParser = new ScriptParser(string, null);
        scriptParser.parse();
        ISQLCommand iSQLCommand = null;
        for (ISQLCommand iSQLCommand2 : scriptParser.getSqlStatements()) {
            if (n2 < iSQLCommand2.getStartLine()) continue;
            if (iSQLCommand2.getStartLine() <= n2 && iSQLCommand != null) {
                iSQLCommand = null;
            }
            if (iSQLCommand != null) continue;
            iSQLCommand = iSQLCommand2;
        }
        if (iSQLCommand == null) {
            return null;
        }
        string = iSQLCommand.getSql();
        Object object = "";
        object = iSQLCommand.getSQLOrig() != null ? iSQLCommand.getSQLOrig() : string;
        if (string == null || string.trim().length() < 1 || iSQLCommand.getStmtId() == SQLCommand.StmtSubType.G_S_COMMENT_PLUS || ((String)object).trim().toUpperCase().startsWith("DESC") || ((String)object).trim().toUpperCase().startsWith("@") || ((String)object).trim().toUpperCase().startsWith("START ") || iSQLCommand.getStmtId() == SQLCommand.StmtSubType.G_S_DEFINE || iSQLCommand.getStmtId() == SQLCommand.StmtSubType.G_S_UNDEFINE || iSQLCommand.isSqlPlusSetCmd() || iSQLCommand.getStmtId() == SQLCommand.StmtSubType.G_S_COMMENT_SQL) {
            return null;
        }
        if (string.endsWith(";") && !string.toUpperCase().endsWith("END;")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string2 != null) {
            string = "/*" + string2 + "*/ " + string;
        }
        return string;
    }

    private String getSqlStatement() {
        String string = this.ctx.getEditor().getSelectedText();
        if (string == null) {
            string = this.ctx.getEditor().getText();
        }
        return string;
    }

    public int[] getSelectionLineColumn() {
        int n = this.ctx.getEditor().getSelectionStart();
        BasicDocument basicDocument = (BasicDocument)this.ctx.getEditor().getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n) + 1;
        int n3 = lineMap.getLineStartOffset(n2 - 1);
        int n4 = n - n3 + 1;
        int[] nArray = new int[]{n2, n4};
        return nArray;
    }

    protected boolean init() {
        try {
            this.conn = Connections.getInstance().getConnection(this.ctx.getConnectionName());
        }
        catch (DBException dBException) {
            return false;
        }
        return true;
    }

    protected void showResultPanel() {
        if (this.ctx != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.autoTracePanel, "f1_explainplan_html");
            this.ctx.getCallback().showResultPanel(this.autoTracePanel);
            this.autoTracePanel.open();
        }
    }

    void resetCursor() {
        BasicEditorPane basicEditorPane = this.ctx.getEditor();
        SwingUtilities.invokeLater(new CursorUI(this.cursorPosition, this.cursorStart != this.cursorEnd, this.cursorStart, this.cursorEnd, basicEditorPane));
    }
}

