/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnnotationInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassemble;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DebugJDIMethodInfo
implements DebugMethodInfo,
DebugHasAnnotations {
    static final String javaStratum = "Java";
    DebugJDI dj;
    DebugJDIClassInfo ci;
    Method m;
    String name;
    private static Map hashBytecodes;
    private static Map hashBytecodesStoppedCount;
    private int annotationCount = -1;
    private List javaLineLocations;
    private int hashCode;

    DebugJDIMethodInfo(DebugJDI dj, DebugJDIClassInfo ci, Method m) {
        this.dj = dj;
        this.ci = ci;
        this.m = m;
        this.name = DebugJDIMethodInfo.getFullMethodName(ci.name, m);
        if (hashBytecodes == null) {
            hashBytecodes = new HashMap();
            hashBytecodesStoppedCount = new HashMap();
        }
    }

    public DebugVirtualMachine getVM() {
        return this.dj;
    }

    public boolean hasExpired() {
        return this.ci.hasExpired();
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.ci;
    }

    public boolean isCompiled() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithoutClass() {
        return DebugShared.getNameWithoutClass((String)this.name);
    }

    public String getNameWithoutSignature() {
        return DebugShared.getNameWithoutSignature((String)this.name);
    }

    public String getNameWithoutClassOrSignature() {
        return DebugShared.getNameWithoutClassOrSignature((String)this.name);
    }

    public String getParameterSignature() {
        return DebugShared.getMethodParameterSignature((String)this.name);
    }

    public int getAccess() {
        this.throwIfExpired();
        return this.m.modifiers();
    }

    private List getJavaLineLocations() {
        if (this.javaLineLocations == null) {
            try {
                List<String> filenames;
                ReferenceType rt = this.ci.getReferenceType();
                if (rt != null && (filenames = rt.sourceNames(javaStratum)) != null && filenames.size() >= 1) {
                    String filename = filenames.get(0);
                    this.javaLineLocations = this.m.allLineLocations(javaStratum, filename);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.javaLineLocations;
    }

    private byte[] getOldBytecodes() {
        return (byte[])hashBytecodes.get(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytecodesSmart() {
        int bytecodesStoppedCount;
        byte[] bytecodes = (byte[])hashBytecodes.get(this.name);
        Integer i = (Integer)hashBytecodesStoppedCount.get(this.name);
        int n = bytecodesStoppedCount = i != null ? i : 0;
        if (bytecodes == null || bytecodesStoppedCount != this.dj.stoppedCount) {
            this.dj.tempDisableBreakpoints();
            try {
                bytecodes = new byte[]{};
                try {
                    bytecodes = this.m.bytecodes();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                bytecodesStoppedCount = this.dj.stoppedCount;
                this.dj.tempReenableBreakpoints();
            }
            hashBytecodes.put(this.name, bytecodes);
            hashBytecodesStoppedCount.put(this.name, new Integer(bytecodesStoppedCount));
        }
        return bytecodes;
    }

    public int[] getMethodLineRange() {
        this.throwIfExpired();
        int[] lines = new int[]{0, 0};
        List locations = this.getJavaLineLocations();
        if (locations != null) {
            for (int i = 0; i < locations.size(); ++i) {
                Location location = (Location)locations.get(i);
                int line = DebugJDI.getLineNumber(location, javaStratum);
                if (line < lines[0] || lines[0] == 0) {
                    lines[0] = line;
                }
                if (line <= lines[1] && lines[1] != 0) continue;
                lines[1] = line;
            }
        }
        return lines;
    }

    public int[] getMethodLines() {
        this.throwIfExpired();
        List locations = this.getJavaLineLocations();
        if (locations != null) {
            int[] lines = new int[locations.size()];
            for (int i = 0; i < locations.size(); ++i) {
                Location location = (Location)locations.get(i);
                lines[i] = DebugJDI.getLineNumber(location, javaStratum);
            }
            return lines;
        }
        return new int[0];
    }

    public int[] getCodeCoverage() {
        return new int[0];
    }

    public double getCodeCoverageRatio() {
        return 0.0;
    }

    public DebugLocation getFirstLocation() {
        this.throwIfExpired();
        try {
            int first = 0;
            Location firstLocation = null;
            String defaultStratum = this.ci.getReferenceType().defaultStratum();
            List locations = this.getJavaLineLocations();
            if (locations != null) {
                for (int i = 0; i < locations.size(); ++i) {
                    int line;
                    Location location = (Location)locations.get(i);
                    if (DebugJDI.getLineNumber(location, defaultStratum) == -1 || (line = DebugJDI.getLineNumber(location, javaStratum)) >= first && first != 0) continue;
                    first = line;
                    firstLocation = location;
                }
            }
            if (firstLocation != null) {
                return this.dj.makeLocation(firstLocation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public DebugLocation getLocation(String filename, int line) {
        this.throwIfExpired();
        try {
            ReferenceType rt = this.ci.getReferenceType();
            if (rt != null) {
                List<String> availableStrata = rt.availableStrata();
                for (String stratum : availableStrata) {
                    List locationsOfLine = DebugJDI.getLocationsOfLine(this.m, stratum, filename, line);
                    Location first = DebugJDI.getFirstLocation(locationsOfLine);
                    if (first == null) continue;
                    return this.dj.makeLocation(first);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public DebugDisassembleInfo[] disassembleMethod(boolean java, boolean bytecode, boolean assembly, Project project) {
        if (this.dj.canDisassembleMethod()) {
            int[] lineNumbers = null;
            int[] bcOffsets = null;
            if (java) {
                List lines = this.getJavaLineLocations();
                int size = lines.size();
                lineNumbers = new int[size];
                bcOffsets = new int[size];
                for (int i = 0; i < size; ++i) {
                    Location location = (Location)lines.get(i);
                    lineNumbers[i] = DebugJDI.getLineNumber(location, javaStratum);
                    bcOffsets[i] = (int)location.codeIndex();
                }
            }
            DebugSharedDisassemble d = new DebugSharedDisassemble(java, bytecode, this.getBytecodesSmart(), lineNumbers, bcOffsets, this.getClassInfo());
            return d.getArray();
        }
        return new DebugDisassembleInfo[0];
    }

    public boolean hasMethodChanged() {
        byte[] oldBytecodes = this.getOldBytecodes();
        if (oldBytecodes == null) {
            return true;
        }
        byte[] newBytecodes = this.getBytecodesSmart();
        if (oldBytecodes == newBytecodes) {
            return false;
        }
        if (oldBytecodes.length != newBytecodes.length) {
            return true;
        }
        for (int i = 0; i < oldBytecodes.length; ++i) {
            if (oldBytecodes[i] == newBytecodes[i]) continue;
            return true;
        }
        return false;
    }

    public byte[] getBytecodes() {
        byte[] bytecodes = this.getBytecodesSmart();
        byte[] b = new byte[bytecodes.length];
        System.arraycopy(bytecodes, 0, b, 0, bytecodes.length);
        return b;
    }

    public byte getBytecode(int offset) {
        byte[] bytecodes = this.getBytecodesSmart();
        if (offset >= 0 && offset < bytecodes.length) {
            return bytecodes[offset];
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DebugDataInfo invoke(List arguments) {
        if (this.dj.eventThread == null) return null;
        Object object = this.dj.methodCallLock;
        synchronized (object) {
            Value value;
            block27: {
                int argumentsSize = arguments.size();
                int i = 0;
                ArrayList<Value> argList = new ArrayList<Value>(argumentsSize);
                ClassType ct = null;
                ObjectReference or = null;
                if (this.m.isStatic()) {
                    ct = (ClassType)this.ci.getReferenceType();
                    if (ct == null) {
                        JDebugger.logger.trace("Cannot evaluate method: {0}.{1}, static call on class without reference type", (Object)this.ci.name, (Object)this.m.name());
                        return null;
                    }
                } else {
                    Object o;
                    if ((o = arguments.get(i++)) instanceof DebugJDIDataObjectInfo) {
                        DebugJDIDataObjectInfo ddoi = (DebugJDIDataObjectInfo)((Object)o);
                        or = (ObjectReference)ddoi.value;
                    } else if (o instanceof String) {
                        or = this.dj.makeStringValue((String)o);
                    }
                    if (or == null) {
                        JDebugger.logger.trace("Cannot evaluate method: {0}.{1}, non-static call while 'this' == null", (Object)this.ci.name, (Object)this.m.name());
                        return null;
                    }
                }
                while (i < argumentsSize) {
                    Object argument = arguments.get(i++);
                    Value argValue = this.dj.makeValue(argument);
                    argList.add(argValue);
                }
                value = null;
                Log logger = JDebugger.logger;
                DebugWindowSettings debuggerSettings = DebugWindowSettings.getInstance();
                List prev = this.dj.tempDisableRequests();
                try {
                    if (debuggerSettings.isDetectMethodEvalDeadlocks()) {
                        this.dj.startMethodEvaluationWorker();
                        DebugJDI.MethodEvaluationWorker worker = this.dj.methodEvaluationWorker;
                        if (ct != null) {
                            worker.ct = ct;
                            worker.methodEvaluationType = DebugJDI.MethodEvaluationType.STATIC_CALL;
                        } else {
                            worker.or = or;
                            worker.methodEvaluationType = DebugJDI.MethodEvaluationType.NON_VIRTUAL_CALL;
                        }
                        worker.m = this.m;
                        worker.argList = argList;
                        worker.dj = this.dj;
                        try {
                            value = this.dj.evaluateMethodCheckForHang();
                            break block27;
                        }
                        catch (Exception e2) {
                            DebugDataInfo debugDataInfo = null;
                            DebugJDIStackFrameInfo.rebuildCache(this.dj);
                            this.dj.tempReenableRequests(prev);
                            return debugDataInfo;
                        }
                    }
                    try {
                        int flag;
                        if (ct != null) {
                            if (logger.isEnabled()) {
                                logger.trace("Invoking static method: {0}.{1}", (Object)ct.name(), (Object)this.m.name());
                            }
                            flag = DebugJDI.MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                            value = ct.invokeMethod(this.dj.eventThread, this.m, argList, flag);
                            if (logger.isEnabled()) {
                                logger.trace("Method return is {0}", (Object)(value == null ? "null" : "not null"));
                            }
                            break block27;
                        }
                        if (logger.isEnabled()) {
                            ClassType ctClass = (ClassType)or.referenceType();
                            logger.trace("Invoking method: {0}.{1}", (Object)(ctClass != null ? ctClass.name() : "<unknown>"), (Object)this.m.name());
                        }
                        flag = DebugJDI.MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                        value = or.invokeMethod(this.dj.eventThread, this.m, argList, flag |= 2);
                        if (logger.isEnabled()) {
                            logger.trace("Method return is {0}", (Object)(value == null ? "null" : "not null"));
                        }
                    }
                    catch (Exception e) {
                        Assert.println((String)("invokeMethod threw " + e));
                        logger.trace("Exception thrown during invocation of method");
                        DebugDataInfo e2 = null;
                        DebugJDIStackFrameInfo.rebuildCache(this.dj);
                        this.dj.tempReenableRequests(prev);
                        return e2;
                    }
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
            if (value != null) {
                return this.dj.makeData(value, null);
            }
            String returnTypeName = this.m.returnTypeName();
            if (returnTypeName == null) return null;
            DebugJDIClassInfo classInfo = this.dj.findClassByName(returnTypeName, true);
            if (classInfo == null) return null;
            return this.dj.makeNullData(classInfo, null);
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.m.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIMethodInfo) {
            DebugJDIMethodInfo other = (DebugJDIMethodInfo)o;
            return this.m.equals(other.m);
        }
        return false;
    }

    public int countAnnotations() {
        this.throwIfExpired();
        if (this.dj.isRIM()) {
            return 0;
        }
        if (this.annotationCount < 0) {
            this.getAnnotations();
        }
        return this.annotationCount < 0 ? 0 : this.annotationCount;
    }

    public DebugAnnotationInfo[] getAnnotations() {
        this.throwIfExpired();
        try {
            ObjectReference orMethodOrConstructor;
            if (this.dj.isSafeToGetAnnotations() && (orMethodOrConstructor = DebugJDIMethodInfo.getReflectedMethodOrConstructor(this.dj, this.m)) != null) {
                DebugAnnotationInfo[] result = this.dj.getAnnotations(orMethodOrConstructor);
                this.annotationCount = result.length;
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DebugJDIAnnotationInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ObjectReference getReflectedMethodOrConstructor(DebugJDI dj, Method m) {
        ObjectReference orMethodOrConstructor = null;
        Log logger = JDebugger.logger;
        try {
            if (dj.eventThread == null) return orMethodOrConstructor;
            Object object = dj.methodCallLock;
            synchronized (object) {
                block14: {
                    ReferenceType rt = m.declaringType();
                    if (rt == null) return orMethodOrConstructor;
                    ClassObjectReference orClass = rt.classObject();
                    if (orClass == null) return orMethodOrConstructor;
                    ClassType ctClass = (ClassType)orClass.referenceType();
                    boolean isConstructor = m.isConstructor();
                    Method mGetDeclaredMethodOrConstructor = isConstructor ? ctClass.concreteMethodByName("getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;") : ctClass.concreteMethodByName("getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
                    if (mGetDeclaredMethodOrConstructor == null) return orMethodOrConstructor;
                    ArrayList<Value> argsGetDeclaredMethodOrConstructor = new ArrayList<Value>(isConstructor ? 1 : 2);
                    if (!isConstructor) {
                        argsGetDeclaredMethodOrConstructor.add(dj.vm.mirrorOf(m.name()));
                    }
                    ArrayType atClass = (ArrayType)mGetDeclaredMethodOrConstructor.argumentTypes().get(isConstructor ? 0 : 1);
                    List<Type> argumentTypes = m.argumentTypes();
                    int countArguments = argumentTypes.size();
                    ArrayReference arParameterTypes = atClass.newInstance(countArguments);
                    for (int i = 0; i < countArguments; ++i) {
                        DebugJDIClassInfo classInfo = dj.findClassByType(argumentTypes.get(i));
                        ClassObjectReference cor = classInfo.getClassObjectReference();
                        arParameterTypes.setValue(i, (Value)cor);
                    }
                    argsGetDeclaredMethodOrConstructor.add(arParameterTypes);
                    DebugWindowSettings debuggerSettings = DebugWindowSettings.getInstance();
                    List prev = dj.tempDisableRequests();
                    try {
                        if (debuggerSettings.isDetectMethodEvalDeadlocks()) {
                            dj.startMethodEvaluationWorker();
                            DebugJDI.MethodEvaluationWorker worker = dj.methodEvaluationWorker;
                            worker.or = orClass;
                            worker.methodEvaluationType = DebugJDI.MethodEvaluationType.VIRTUAL_CALL;
                            worker.dj = dj;
                            worker.m = mGetDeclaredMethodOrConstructor;
                            worker.argList = argsGetDeclaredMethodOrConstructor;
                            try {
                                orMethodOrConstructor = (ObjectReference)dj.evaluateMethodCheckForHang();
                                break block14;
                            }
                            catch (Exception ex) {
                                ObjectReference objectReference = null;
                                DebugJDIStackFrameInfo.rebuildCache(dj);
                                dj.tempReenableRequests(prev);
                                return objectReference;
                            }
                        }
                        if (logger.isEnabled()) {
                            logger.trace("Invoking method: {0}.{1}", (Object)ctClass.name(), (Object)mGetDeclaredMethodOrConstructor.name());
                        }
                        int flag = DebugJDI.MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                        orMethodOrConstructor = (ObjectReference)orClass.invokeMethod(dj.eventThread, mGetDeclaredMethodOrConstructor, argsGetDeclaredMethodOrConstructor, flag);
                        if (!logger.isEnabled()) return orMethodOrConstructor;
                        logger.trace("Method return is {0},", (Object)(orMethodOrConstructor == null ? "null" : "not null"));
                    }
                    finally {
                        DebugJDIStackFrameInfo.rebuildCache(dj);
                        dj.tempReenableRequests(prev);
                    }
                }
                return orMethodOrConstructor;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return orMethodOrConstructor;
    }

    static String getFullMethodName(String c, Method m) {
        String s = m.returnTypeName() + " " + c + "." + m.name() + "(";
        List<String> args = m.argumentTypeNames();
        for (int i = 0; i < args.size(); ++i) {
            s = s + args.get(i);
            if (i + 1 >= args.size()) continue;
            s = s + ", ";
        }
        s = s + ")";
        return s;
    }

    public Method getJDIMethod() {
        return this.m;
    }
}

