/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;

final class DebugJDIBreakpointPackageFileLine
extends DebugJDIBreakpointFileLine
implements DebugBreakpointPackageFileLine {
    static final List<String> jspPackages = new ArrayList<String>();
    private String pkg;

    DebugJDIBreakpointPackageFileLine(DebugJDI dj, String pkg, String filename, int line) {
        super(dj, filename, line);
        this.pkg = pkg;
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setPackageFileLine(String pkg, String filename, int line) {
        if (ModelUtil.areDifferent((Object)this.pkg, (Object)pkg) || ModelUtil.areDifferent((Object)this.filename, (Object)filename) || this.line != line) {
            this.prepareForChange();
            this.pkg = pkg;
            this.filename = filename;
            this.line = line;
            this.afterChange();
        }
    }

    @Override
    String getClassPrepareFilter() {
        if (this.pkg.length() > 0) {
            if (this.pkg.charAt(0) == '*') {
                return "";
            }
            return this.pkg + ".*";
        }
        return "";
    }

    @Override
    boolean verify(ReferenceType rt, String rtName) {
        String rtPkg;
        int i = rtName.lastIndexOf(".");
        String string = rtPkg = i == -1 ? "" : rtName.substring(0, i);
        if (rtPkg.equals(this.pkg) || jspPackages.contains(this.pkg) && jspPackages.contains(rtPkg)) {
            return super.verify(rt, rtName);
        }
        if (this.pkg.length() > 0 && this.pkg.charAt(0) == '*' && rtPkg.endsWith(this.pkg.substring(1))) {
            return super.verify(rt, rtName);
        }
        return false;
    }

    static {
        jspPackages.add("jsp_servlet");
        jspPackages.add("org.apache.jsp");
        jspPackages.add("com.ibm._jsp");
        jspPackages.add("_ibmjsp");
    }
}

