/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.List;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;

final class DebugJDIBreakpointMethodBytecode
extends DebugJDIBreakpoint
implements DebugBreakpointMethodBytecode {
    private String method;
    private int bytecodeOffset;
    private String className;

    DebugJDIBreakpointMethodBytecode(DebugJDI dj, String method, int bytecodeOffset) {
        super(dj);
        int lastDot;
        int paren;
        this.method = method;
        this.bytecodeOffset = bytecodeOffset;
        int space = method.indexOf(" ");
        this.className = space == -1 ? "" : ((paren = method.indexOf("(", space + 1)) == -1 ? "" : ((lastDot = method.lastIndexOf(".", paren - 1)) == -1 ? "" : method.substring(space + 1, lastDot)));
    }

    public String getMethod() {
        return this.method;
    }

    public int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    public void setMethodBytecodeOffset(String method, int bytecodeOffset) {
        if (ModelUtil.areDifferent((Object)this.method, (Object)method) || this.bytecodeOffset != bytecodeOffset) {
            this.prepareForChange();
            this.method = method;
            this.bytecodeOffset = bytecodeOffset;
            this.afterChange();
        }
    }

    @Override
    String getClassPrepareFilter() {
        return this.className;
    }

    @Override
    boolean verify(ReferenceType rt, String rtName) {
        boolean identified = false;
        if (this.className.equals(rtName)) {
            List<Method> methods = rt.methods();
            for (int im = 0; im < methods.size(); ++im) {
                Location location;
                String fullname;
                Method m = methods.get(im);
                if (this.method.indexOf(m.name()) == -1 || !this.method.equals(fullname = DebugJDIMethodInfo.getFullMethodName(this.className, m)) || (location = m.locationOfCodeIndex(this.bytecodeOffset)) == null) continue;
                this.locationIdentified(location);
                identified = true;
            }
        }
        return identified;
    }
}

