/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import javax.swing.Icon;
import oracle.ide.layout.Layout;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.SmartController;
import oracle.jdevimpl.runner.debug.SmartPanel;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;

final class SmartWindow
extends DataWindow {
    static final String SMART_WINDOW_ID = "Debugger.SmartWindow";
    private SmartPanel smartPanel;
    private Boolean useFilters;

    SmartWindow() {
        super(SMART_WINDOW_ID, DbgArb.getString(557), "f1_deb_smartdatawindow_html");
    }

    @Override
    protected final DataPanel getDataPanel(boolean forceCreate) {
        if (this.smartPanel == null && forceCreate) {
            this.smartPanel = new SmartPanel(this, SmartWindowSettings.getInstance());
            if (this.useFilters != null) {
                this.smartPanel.setUseFilters(this.useFilters);
            }
        }
        return this.smartPanel;
    }

    @Override
    final void setUseFilters(boolean useFilters) {
        if (this.smartPanel != null) {
            this.smartPanel.setUseFilters(useFilters);
        } else {
            this.useFilters = useFilters;
        }
    }

    public Icon getTabIcon() {
        DebuggerDataWindowOptions options = this.getDataPanel(true).getController().getDebuggerWindowOptions();
        if (options != null) {
            return options.getTabIcon();
        }
        return OracleIcons.getIcon((String)"debugger/smrtdata.png");
    }

    @Override
    public int getDefaultVisibility(Layout layout) {
        int visibility = super.getDefaultVisibility(layout);
        if (visibility == 1) {
            return visibility | 4;
        }
        return visibility;
    }

    void refreshWindow() {
        if (this.smartPanel != null) {
            ((SmartController)this.smartPanel.getController()).refreshWindow();
        }
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    public boolean installByDefault() {
        return true;
    }

    @Override
    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.getController() != null) {
            ((SmartController)this.getController()).processFinished(debuggingProcess);
        }
        super.processFinished(debuggingProcess);
    }
}

