/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JToolBar;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.builders.ToolBarBuilder;
import oracle.javatools.ui.segmented.DefaultSegment;
import oracle.javatools.ui.segmented.Segment;
import oracle.javatools.ui.segmented.SegmentedControl;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

abstract class MultiViewPanel
extends DataPanel {
    private SegmentedControl<String> viewControl;
    private DebugVirtualMachine vm;

    MultiViewPanel(DockableWindow dockableWindow, DataPanelSettings dataPanelSettings) {
        super(dockableWindow, dataPanelSettings);
    }

    abstract String getWindowId();

    @Override
    protected Toolbar createToolbar() {
        this.viewControl = new SegmentedControl();
        DefaultSegment tableSeg = new DefaultSegment((Object)"TABLE_TABLE", OracleIcons.getIcon((String)"table.png"), DbgArb.getString(864));
        DefaultSegment treeSeg = new DefaultSegment((Object)"TREE_TABLE", OracleIcons.getIcon((String)"tree.png"), DbgArb.getString(863));
        this.viewControl.addSegment((Segment)tableSeg);
        this.viewControl.addSegment((Segment)treeSeg);
        this.viewControl.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                DataPanelSettings localSettings = MultiViewPanel.this.dataPanelSettings;
                DebugVirtualMachine localVM = MultiViewPanel.this.vm;
                if (MultiViewPanel.this.viewControl == null) {
                    return;
                }
                String selection = (String)MultiViewPanel.this.viewControl.getSelected();
                MultiViewPanel.this.setDataTableView(selection);
                if (localSettings != null) {
                    if (localVM == null) {
                        DebuggingProcess process = JDebugger.getInstance().getActiveDebuggingProcess();
                        if (process == null) {
                            return;
                        }
                        localVM = process.getVM();
                    }
                    if (localSettings != null && localVM != null) {
                        String windowId = MultiViewPanel.this.dockableWindow.getUniqueName();
                        if (windowId == null) {
                            windowId = MultiViewPanel.this.getWindowId();
                        }
                        WindowSettingsColumnManager.setActiveDataView(localSettings.getHash(), localVM.getID(), windowId, selection);
                    }
                }
            }
        });
        ToolBarBuilder toolBarBuilder = new ToolBarBuilder();
        toolBarBuilder.setToolBar((JToolBar)new Toolbar());
        toolBarBuilder.addComponents(false, new Component[]{this.viewControl, Box.createHorizontalStrut(4)});
        toolBarBuilder.addActions(false, new Action[]{this.getController()._actionSettings});
        return (Toolbar)toolBarBuilder.build().getToolBar();
    }

    void setNewVm(DebugVirtualMachine newVM, DebuggerDataWindowOptions options) {
        if (this.vm != null) {
            this.saveSettings();
        }
        this.vm = newVM;
        if (newVM != null) {
            this.loadSettings(options);
        }
        this.getController().setVm(newVM);
    }

    @Override
    void dataPanelSettingsChanged() {
        if (this.vm != null) {
            this.loadSettings(null);
        }
        super.dataPanelSettingsChanged();
    }

    void loadSettings(DebuggerDataWindowOptions options) {
        String viewType = WindowSettingsColumnManager.getActiveDataViewNoDefault(this.dataPanelSettings.getHash(), this.vm.getID(), this.dockableWindow.getUniqueName());
        if (viewType == null && options != null) {
            viewType = options.getDefaultView().equals((Object)DebuggerDataWindowOptions.View.TREE) ? "TREE_TABLE" : "TABLE_TABLE";
        }
        if (viewType != null && this.viewControl != null) {
            this.viewControl.setSelected((Object)viewType);
        }
    }

    void saveSettings() {
        if (this.dataPanelSettings != null && this.viewControl.getSelected() != null) {
            WindowSettingsColumnManager.setActiveDataView(this.dataPanelSettings.getHash(), this.vm.getID(), this.dockableWindow.getUniqueName(), (String)this.viewControl.getSelected());
        }
    }
}

