/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.runner.debug.DebuggerLanguageHelper;
import oracle.jdevimpl.runner.debug.DebuggerProtocolHelper;

public final class DebuggerHelperHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension/jdev-runner", "debugger-helper-hook");
    private static HashStructureHook hashStructureHook;
    private static Set<String> _emittedErrors;
    private static Map<String, ToolDescription<DebuggerProtocolHelper>> _protocolSpecificHelpers;
    private static Map<String, ToolDescription<DebuggerLanguageHelper>> _languageSpecificHelpers;

    public static DebuggerProtocolHelper getProtocolSpecificHelper(Project project, String id) {
        DebuggerHelperHook.primeHook();
        DebuggerHelperHook.getTools(_protocolSpecificHelpers, project);
        ToolDescription<DebuggerProtocolHelper> toolDescription = _protocolSpecificHelpers.get(id);
        return toolDescription == null ? null : toolDescription.getTool();
    }

    public static List<DebuggerProtocolHelper> getProtocolSpecificHelpers(Project project) {
        DebuggerHelperHook.primeHook();
        return DebuggerHelperHook.getTools(_protocolSpecificHelpers, project);
    }

    public static List<DebuggerLanguageHelper> getLanguageSpecificHelpers(Project project) {
        DebuggerHelperHook.primeHook();
        return DebuggerHelperHook.getTools(_languageSpecificHelpers, project);
    }

    private static <T> void addTool(T tool, Map<String, ToolDescription<T>> knownTools, Category category) {
        if (tool == null) {
            assert (tool != null) : "tool argument cannot be null in call to addTool";
            return;
        }
        ToolDescription desc = new ToolDescription(tool, category);
        String className = desc.getClassName();
        String key = desc.getID();
        if (!knownTools.containsKey(key)) {
            knownTools.put(key, desc);
        } else {
            DebuggerHelperHook.logDuplicateTool(className, category, null);
        }
    }

    public static synchronized <T> void removeTool(T tool, Map<String, ToolDescription<T>> knownTools) {
        if (tool == null) {
            assert (tool != null) : "tool arguments cannot be null in call to removeTool";
            return;
        }
        if (knownTools != null) {
            String key = Integer.toString(System.identityHashCode(tool));
            knownTools.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> getTools(Map<String, ToolDescription<T>> knownTools, Project project) {
        if (knownTools == null) {
            assert (knownTools != null) : "knownTools argument cannot be null in call to getTools";
            return Collections.emptyList();
        }
        Class<DebuggerHelperHook> clazz = DebuggerHelperHook.class;
        synchronized (DebuggerHelperHook.class) {
            DebuggerHelperHook.primeHook();
            ArrayList<ToolDescription<T>> toolDescriptions = new ArrayList<ToolDescription<T>>(knownTools.values());
            // ** MonitorExit[clazz] (shouldn't be in output)
            ArrayList list = new ArrayList(toolDescriptions.size());
            for (ToolDescription toolDescription : toolDescriptions) {
                Object tool;
                if (!toolDescription.areRulesSatisfied(project) || (tool = toolDescription.getTool()) == null) continue;
                list.add(tool);
            }
            return list;
        }
    }

    private static void logDuplicateTool(String className, Category category, HashStructure hash) {
        DebuggerHelperHook.logError("Duplicate Registration: " + className, category.toString(), hash);
    }

    private static boolean checkRule(String rule, String categoryAsString, HashStructure hash) {
        String errorMsg = DebuggerHelperHook.checkMissingRule(rule, categoryAsString);
        if (errorMsg != null) {
            DebuggerHelperHook.logError(errorMsg, categoryAsString, hash);
            return true;
        }
        errorMsg = DebuggerHelperHook.checkValidRule(rule, categoryAsString);
        if (errorMsg != null) {
            DebuggerHelperHook.logError(errorMsg, categoryAsString, hash);
            return false;
        }
        return true;
    }

    private static synchronized <T> Map<String, ToolDescription<T>> updateTools(HashStructure hashStructure, Map<String, ToolDescription<T>> knownTools, Category category) {
        ArrayList newTools = new ArrayList();
        if (knownTools == null) {
            knownTools = new LinkedHashMap<String, ToolDescription<T>>();
        }
        DebuggerHelperHook.getItems(hashStructure, category, newTools);
        for (ToolDescription desc : newTools) {
            if (desc.getClassName() == null) continue;
            String key = desc.getID();
            if (!knownTools.containsKey(key)) {
                if (!DebuggerHelperHook.checkRule(desc.getRule(), category.toString(), hashStructure)) continue;
                knownTools.put(key, desc);
                continue;
            }
            DebuggerHelperHook.logDuplicateTool(key, category, hashStructure);
        }
        return knownTools;
    }

    private static synchronized void primeHook() {
        if (hashStructureHook == null) {
            hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
            if (hashStructureHook == null) {
                return;
            }
            hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    DebuggerHelperHook.getItemsFromHook(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    DebuggerHelperHook.getItemsFromHook(e.getCombinedHashStructure());
                }
            });
        }
    }

    private static synchronized void getItemsFromHook(HashStructure hashStructure) {
        _languageSpecificHelpers = DebuggerHelperHook.updateTools(hashStructure, _languageSpecificHelpers, Category.DEBUGGER_LANGUAGE_HELPER);
        _protocolSpecificHelpers = DebuggerHelperHook.updateTools(hashStructure, _protocolSpecificHelpers, Category.DEBUGGER_PROTOCOL_HELPER);
    }

    private static <T> void getItems(HashStructure hashStructure, Category itemCategory, List<T> items) {
        List definitions = hashStructure.getAsList(itemCategory.toString());
        if (definitions != null && definitions.size() > 0) {
            block4: for (Object definition : definitions) {
                HashStructure defHash = (HashStructure)definition;
                ToolDescription item = null;
                switch (itemCategory) {
                    default: {
                        assert (false);
                        continue block4;
                    }
                    case DEBUGGER_LANGUAGE_HELPER: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new ToolDescription(defHash, extensionId, Category.DEBUGGER_LANGUAGE_HELPER);
                        break;
                    }
                    case DEBUGGER_PROTOCOL_HELPER: {
                        String extensionId = HashStructureHook.getExtensionId((HashStructure)defHash);
                        item = new ToolDescription(defHash, extensionId, Category.DEBUGGER_PROTOCOL_HELPER);
                    }
                }
                items.add(item);
            }
        }
    }

    private static void logError(String msg, String category, HashStructure hash) {
        String extensionId = hash == null ? null : HashStructureHook.getExtensionId((HashStructure)hash);
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" in ");
        buf.append(category);
        if (extensionId != null) {
            buf.append(" in extension ");
            buf.append(extensionId);
        }
        if (_emittedErrors == null) {
            _emittedErrors = new HashSet<String>();
        }
        if (!_emittedErrors.contains(buf.toString())) {
            _emittedErrors.add(buf.toString());
            ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            if (extensionId != null) {
                Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
                ExtensionLogRecord record = new ExtensionLogRecord(Level.SEVERE, buf.toString(), ext, -1);
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
            }
        }
    }

    private static String getAttributeValue(HashStructure hash, String category, String name) {
        String value = hash.getString(name, null);
        if (value == null || value.trim().length() == 0) {
            DebuggerHelperHook.logError("Missing " + name + " attribute", category, hash);
            return null;
        }
        return value;
    }

    private static ClassLoader getClassLoader(String extensionId) {
        ClassLoader loader = null;
        if (extensionId != null) {
            loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
        }
        if (loader == null) {
            loader = DebuggerHelperHook.class.getClass().getClassLoader();
        }
        return loader;
    }

    static String checkMissingRule(String rule, String className) {
        if (rule == null || rule.trim().length() == 0) {
            return DebuggerHelperHook.ruleError("Missing", null, className);
        }
        return null;
    }

    static String checkValidRule(String rule, String className) {
        RuleEngine engine = RuleEngine.getInstance();
        Rule engineRule = engine.getRule(rule);
        HashSet<String> acceptedRules = new HashSet<String>(2);
        acceptedRules.add("project-has-techscope");
        acceptedRules.add("always-enabled");
        acceptedRules.add("project-content-has-contents");
        if (engineRule == null || !engineRule.matchesType(acceptedRules)) {
            return DebuggerHelperHook.ruleError("Invalid", rule, className);
        }
        return null;
    }

    static String isKnownRule(String rule, String className) {
        RuleEngine engine = RuleEngine.getInstance();
        if (!engine.isKnownRule(rule)) {
            return DebuggerHelperHook.ruleError("Unknown", rule, className);
        }
        return null;
    }

    private static boolean areRulesSatisfied(String rule, Project project, Node node) {
        if (project == null) {
            return true;
        }
        if (rule != null && rule.trim().length() > 0) {
            RuleEngine engine = RuleEngine.getInstance();
            if (engine.isKnownRule(rule)) {
                Context context = new Context(null, project);
                if (node != null) {
                    context.setNode(node);
                }
                return engine.evaluateRule(rule, context);
            }
            return false;
        }
        return true;
    }

    private static String ruleError(String prefix, String rule, String className) {
        StringBuilder buf = new StringBuilder();
        buf.append(prefix);
        buf.append(" rule attribute");
        if (rule != null) {
            buf.append(" '");
            buf.append(rule);
            buf.append("'");
        }
        buf.append(" in ");
        buf.append(className);
        buf.append(" registration");
        return buf.toString();
    }

    private static class ToolDescription<T> {
        private String extensionId;
        private String className;
        private T tool;
        protected HashStructure hash;
        protected Category category;
        private String rule;
        private String id;

        private ToolDescription(HashStructure hash, String extensionId, Category category) {
            this.hash = hash;
            this.extensionId = extensionId;
            this.category = category;
        }

        private ToolDescription(T tool, Category category) {
            this.tool = tool;
            this.className = tool.getClass().getName();
            this.category = category;
            this.rule = "always-enabled";
        }

        protected String getValue(String name) {
            return DebuggerHelperHook.getAttributeValue(this.hash, this.category.toString(), name);
        }

        public String getClassName() {
            if (this.className == null) {
                this.className = this.getValue("class");
            }
            return this.className;
        }

        public String getID() {
            if (this.id == null) {
                this.id = this.getValue("id");
            }
            return this.id;
        }

        public String getRule() {
            if (this.rule == null) {
                this.rule = DebuggerHelperHook.getAttributeValue(this.hash, this.category.toString(), "rule");
                if (this.rule == null) {
                    this.rule = "always-enabled";
                }
            }
            return this.rule;
        }

        public boolean areRulesSatisfied(Project project) {
            return DebuggerHelperHook.areRulesSatisfied(this.getRule(), project, null);
        }

        public synchronized T getTool() {
            if (this.tool == null) {
                ClassLoader classLoader = DebuggerHelperHook.getClassLoader(this.extensionId);
                MetaClass metaClass = new MetaClass(classLoader, this.getClassName());
                try {
                    this.tool = metaClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.printStackTrace((Throwable)ex);
                    DebuggerHelperHook.logError("Failed to create instance of class " + this.getClassName(), this.category.toString(), this.hash);
                }
            }
            return this.tool;
        }
    }

    private static enum Category {
        DEBUGGER_PROTOCOL_HELPER{

            public String toString() {
                return "debugger-protocol-helper";
            }
        }
        ,
        DEBUGGER_LANGUAGE_HELPER{

            public String toString() {
                return "debugger-language-helper";
            }
        };

    }
}

