/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.config.Preferences;
import oracle.ideri.util.Product;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class DebugWindowSettings
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "DebugWindowOptions";
    static final String START_RUNNING = "running";
    static final String START_STEPOVER = "stepover";
    static final String START_STEPINTO = "stepinto";
    private static final String TABLE_RESIZE_MODE = "tableResizeMode";
    private static final String USE_FILTERS = "useFilters";
    private static final String CONNECTION_RETRIES = "connectionRetries";
    private static final String TOOLTIP_IN_CODE_EDITOR = "toolTipInCodeEditor";
    private static final String TOOLBAR_IN_LOG_WINDOW = "toolbarInLogWindow";
    private static final String ACTION_BUTTONS_ON_TOOLBAR = "actionButtonsOnToolbar";
    private static final String PROMPT_FOR_DEBUGGER_HOST_FOR_DATABASE_DEBUGGING = "promptForDebuggerHostForDatabaseDebugging";
    private static final String LOCAL_PORT_RANGE = "localPortRange";
    private static final String LOCAL_PORT_RANGE_MIN = "localPortRangeMin";
    private static final String LOCAL_PORT_RANGE_MAX = "localPortRangeMax";
    private static final String START_OPTION = "startOption";
    private static final String DETECT_METHOD_EVAL_DEADLOCKS = "detectMethodEvaluationDeadlocks";
    private static final String CHANGE_TRACKING_ENABLED = "changeTrackingEnabled";
    private static final String CHANGED_TABLECELL_FOREGROUND_COLOR = "changedCellForeground";
    private static final String CHANGED_TABLECELL_BACKGROUND_COLOR = "changedCellBackground";
    private static final String SHOW_SIO_DIALOG = "SHOW_STEPINTO_INITIAL_DIALOG";
    private static final String UNINSTALLED_WINDOWS = "UNINSTALLED_WINDOWS";

    public static DebugWindowSettings getInstance() {
        return DebugWindowSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    public DebugWindowSettings() {
        super(HashStructure.newInstance());
    }

    private DebugWindowSettings(HashStructure hs) {
        super(hs);
    }

    public static DebugWindowSettings getInstance(PropertyStorage ps) {
        return new DebugWindowSettings(DebugWindowSettings.findOrCreate((PropertyStorage)ps, (String)KEY_SETTINGS));
    }

    public int getTableResizeMode() {
        return this._hash.getInt(TABLE_RESIZE_MODE, 1);
    }

    public void setTableResizeMode(int tableResizeMode) {
        this._hash.putInt(TABLE_RESIZE_MODE, tableResizeMode);
    }

    public boolean isUseFilters() {
        return this._hash.getBoolean(USE_FILTERS, false);
    }

    public void setUseFilters(boolean useFilters) {
        this._hash.putBoolean(USE_FILTERS, useFilters);
    }

    public int getConnectionRetries() {
        return this._hash.getInt(CONNECTION_RETRIES, 90);
    }

    public void setConnectionRetries(int connectionRetries) {
        this._hash.putInt(CONNECTION_RETRIES, connectionRetries);
    }

    public boolean isShowToolTipInCodeEditor() {
        return this._hash.getBoolean(TOOLTIP_IN_CODE_EDITOR, true);
    }

    public void setShowToolTipInCodeEditor(boolean showToolTipInCodeEditor) {
        this._hash.putBoolean(TOOLTIP_IN_CODE_EDITOR, showToolTipInCodeEditor);
    }

    @Deprecated
    public boolean isShowToolbarInLogWindow() {
        return this._hash.getBoolean(TOOLBAR_IN_LOG_WINDOW, Product.isRaptor());
    }

    @Deprecated
    public void setShowToolbarInLogWindow(boolean showToolbarInLogWindow) {
        this._hash.putBoolean(TOOLBAR_IN_LOG_WINDOW, showToolbarInLogWindow);
    }

    public boolean isShowActionButtonsOnToolbar() {
        return this._hash.getBoolean(ACTION_BUTTONS_ON_TOOLBAR, Product.isRaptor());
    }

    public void setShowActionButtonsOnToolbar(boolean showActionButtonsOnToolbar) {
        this._hash.putBoolean(ACTION_BUTTONS_ON_TOOLBAR, showActionButtonsOnToolbar);
    }

    public boolean isPromptForDebuggerHostForDatabaseDebugging() {
        return this._hash.getBoolean(PROMPT_FOR_DEBUGGER_HOST_FOR_DATABASE_DEBUGGING, false);
    }

    public void setPromptForDebuggerHostForDatabaseDebugging(boolean promptForDebuggerHostForDatabaseDebugging) {
        this._hash.putBoolean(PROMPT_FOR_DEBUGGER_HOST_FOR_DATABASE_DEBUGGING, promptForDebuggerHostForDatabaseDebugging);
    }

    public boolean isLocalPortRange() {
        return this._hash.getBoolean(LOCAL_PORT_RANGE, false);
    }

    public void setLocalPortRange(boolean localPortRange) {
        this._hash.putBoolean(LOCAL_PORT_RANGE, localPortRange);
    }

    public int getLocalPortRangeMin() {
        return this._hash.getInt(LOCAL_PORT_RANGE_MIN, 4000);
    }

    public void setLocalPortRangeMin(int localPortRangeMin) {
        this._hash.putInt(LOCAL_PORT_RANGE_MIN, localPortRangeMin);
    }

    public int getLocalPortRangeMax() {
        return this._hash.getInt(LOCAL_PORT_RANGE_MAX, 4999);
    }

    public void setLocalPortRangeMax(int localPortRangeMax) {
        this._hash.putInt(LOCAL_PORT_RANGE_MAX, localPortRangeMax);
    }

    public String getStartOption() {
        return this._hash.getString(START_OPTION, START_RUNNING);
    }

    public void setStartOption(String startOption) {
        this._hash.putString(START_OPTION, startOption);
    }

    public boolean isDetectMethodEvalDeadlocks() {
        return this._hash.getBoolean(DETECT_METHOD_EVAL_DEADLOCKS, true);
    }

    public void setDetectMethodEvalDeadlocks(boolean detectIt) {
        this._hash.putBoolean(DETECT_METHOD_EVAL_DEADLOCKS, detectIt);
    }

    public boolean isChangeTrackingEnabled() {
        return this._hash.getBoolean(CHANGE_TRACKING_ENABLED, true);
    }

    public void setChangeTrackingEnabled(boolean enabled) {
        this._hash.putBoolean(CHANGE_TRACKING_ENABLED, enabled);
    }

    public Color getChangedCellForegroundColor() {
        int rgbValue = this._hash.getInt(CHANGED_TABLECELL_FOREGROUND_COLOR);
        if (rgbValue != -1) {
            return new Color(rgbValue);
        }
        return Color.black;
    }

    public void setChangedCellForegroundColor(Color color) {
        int rgbValue = color.getRGB();
        this._hash.putInt(CHANGED_TABLECELL_FOREGROUND_COLOR, rgbValue);
    }

    public Color getChangedCellBackgroundColor() {
        int rgbValue = this._hash.getInt(CHANGED_TABLECELL_BACKGROUND_COLOR, -1);
        if (rgbValue != -1) {
            return new Color(rgbValue);
        }
        return new Color(251, 249, 210);
    }

    public void setChangedCellBackgroundColor(Color color) {
        int rgbValue = color.getRGB();
        this._hash.putInt(CHANGED_TABLECELL_BACKGROUND_COLOR, rgbValue);
    }

    public boolean isShowStepIntoOuterInitialDialog() {
        return this._hash.getBoolean(SHOW_SIO_DIALOG, true);
    }

    public void setShowStepIntoOuterInitialDialog(boolean value) {
        this._hash.putBoolean(SHOW_SIO_DIALOG, value);
    }

    public List<String> getUninstalledWindows() {
        List finalList = this._hash.getAsList(UNINSTALLED_WINDOWS);
        if (finalList == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> modifiableList = new ArrayList<String>(finalList);
        return modifiableList;
    }

    public void setUninstalledWindows(List<String> windows) {
        ListStructure list = ListStructure.newInstance();
        list.addAll(windows);
        this._hash.putListStructure(UNINSTALLED_WINDOWS, list);
    }
}

