/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.treetable.JFastTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.runner.debug.DataInfoPath;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DataTableUtils;
import oracle.jdevimpl.runner.debug.DataTreeTableModel;

abstract class AbstractDataTreeTable
implements DataTable {
    private JFastTreeTable treeTable;
    private JScrollPane scrollPane;
    private JComponent gui;
    protected DebuggerWindowOptions.WindowId windowId;
    protected DataPanel dataPanel;

    public AbstractDataTreeTable(DataPanel dataPanel) {
        this.dataPanel = dataPanel;
        this.windowId = dataPanel.getWindowIdEnum();
        this.treeTable = this.createTreeTable(dataPanel.getModel());
        this.scrollPane = this.createScrollPane();
        this.gui = this.createGUI(dataPanel);
    }

    @Override
    public Component getGUI() {
        return this.gui;
    }

    protected abstract JFastTreeTable createTreeTable(DataTreeTableModel var1);

    protected abstract JScrollPane createScrollPane();

    protected abstract JComponent createGUI(DataPanel var1);

    @Override
    public final JTable getTable() {
        return this.treeTable;
    }

    @Override
    public final JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    protected final JFastTreeTable getTreeTable() {
        return this.treeTable;
    }

    @Override
    public final TreePath makeVisible(DataTreeTableModel model, DataInfoPath dataInfoPath) {
        TreePath treePath = DataTableUtils.convertDataInfoPathToTreePath((TreeTableModel)model, dataInfoPath);
        if (treePath != null) {
            this.makeVisible(treePath);
        }
        return treePath;
    }

    @Override
    public final void makeVisible(TreePath treePath) {
        int row = this.treeTable.getTree().getRowForPath(treePath);
        Rectangle r = this.treeTable.getCellRect(row, 0, true);
        if (r != null) {
            this.treeTable.scrollRectToVisible(r);
        }
    }

    @Override
    public final TreePath getPathForRow(int row) {
        return this.treeTable.getTree().getPathForRow(row);
    }

    @Override
    public final TreePath getSelectionPath() {
        return this.treeTable.getTree().getSelectionPath();
    }

    @Override
    public final void setSelectionPath(TreePath path) {
        try {
            this.treeTable.getTree().setSelectionPath(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public final boolean isVisible(TreePath treePath) {
        return this.treeTable.getTree().isVisible(treePath);
    }

    @Override
    public final boolean isExpanded(TreePath treePath) {
        return this.treeTable.getTree().isExpanded(treePath);
    }

    @Override
    public final void expandPath(TreePath treePath) {
        this.treeTable.getTree().expandPath(treePath);
    }

    @Override
    public final void collapsePath(TreePath treePath) {
        this.treeTable.getTree().expandPath(treePath);
    }

    @Override
    public void addSelectionListener(ListSelectionListener l) {
        this.treeTable.getSelectionModel().addListSelectionListener(l);
    }

    @Override
    public void removeSelectionListener(ListSelectionListener l) {
        this.treeTable.getSelectionModel().removeListSelectionListener(l);
    }
}

