/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.net.URLPath;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JavaOptionProvider;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.EnvironmentVariable;

public class JStarter
extends Starter {
    private static final List javaOptionProviders = new ArrayList();
    private Element[] explicitCompilationTargets = null;
    protected JRunProcess jrunProcess;
    protected String[] target;
    protected RunConfiguration runConfiguration;
    public static final String JAVA_HOME = "java.home";
    public static final String JAVA_VERSION = "java.specification.version";
    public static final String JAVA_ARCH_DATA_MODEL = "sun.arch.data.model";

    public static void addJavaOptionProvider(JavaOptionProvider javaOptionProvider) {
        javaOptionProviders.add(javaOptionProvider);
    }

    public static void removeJavaOptionProvider(JavaOptionProvider javaOptionProvider) {
        javaOptionProviders.remove(javaOptionProvider);
    }

    protected JStarter(JRunProcess jrunProcess, String[] target) {
        super((RunProcess)jrunProcess);
        this.jrunProcess = jrunProcess;
        Assert.check((jrunProcess != null ? 1 : 0) != 0, (String)"jrunProcess is null");
        this.target = target;
        this.runConfiguration = jrunProcess.getRunConfiguration();
        Assert.check((this.runConfiguration != null ? 1 : 0) != 0, (String)"runConfiguration is null");
    }

    public String[] getStartCommand() {
        ArrayList list = new ArrayList();
        if (!this.addJavaExecutableName(list)) {
            return null;
        }
        if (!this.addJavaVmOption(list)) {
            return null;
        }
        this.addFirstJavaCommandOptions(list);
        this.addEndorsedDirsOption(list);
        this.addBootClassPathOption(list);
        this.addClassPathOption(list);
        this.addJavaOptions(list);
        this.addLastJavaCommandOptions(list);
        this.addTarget(list);
        this.addProgramArguments(list);
        return list.toArray(new String[list.size()]);
    }

    public boolean start() {
        this.setEnvironmentVariables();
        return super.start();
    }

    private void setEnvironmentVariables() {
        List<EnvironmentVariable> evs = this.runConfiguration.getEnvironmentVariables();
        for (EnvironmentVariable environmentVariable : evs) {
        }
    }

    protected boolean addJavaExecutableName(List list) {
        JDK jdk = this.jrunProcess.getJdkDefinition();
        if (jdk != null) {
            String java = jdk.getSDKBinJavaExecutableNoConsole();
            if (java != null) {
                list.add(java);
                return true;
            }
            java = jdk.getJavaExecutableNoConsole();
            if (java != null) {
                list.add(java);
                return true;
            }
        }
        return false;
    }

    protected boolean addJavaVmOption(List list) {
        String vmName = this.getVMName();
        if (vmName != null && vmName.length() > 0) {
            String s = "-" + vmName;
            list.add(s);
        }
        if (!IdeBootProperties.isAssertTracingDisabled().booleanValue()) {
            list.add("-ea");
        }
        return true;
    }

    protected final String getVMName() {
        JDK jdk = this.jrunProcess.getJdkDefinition();
        return this.runConfiguration.getVMName(jdk);
    }

    protected final void addFirstJavaCommandOptions(List list) {
        String[] a = (String[])this.jrunProcess.getValue("Java", null, "FirstJavaCommandOptions");
        if (a != null) {
            JStarter.addArrayToList(list, a);
        }
    }

    protected void addJavaOptions(List list) {
        this.addJavaOptionProvidersJavaOptions(list);
        this.addProxyJavaOptions(list);
        this.addRunConfigurationJavaOptions(list);
    }

    protected void addRunConfigurationJavaOptions(List list) {
        String s = this.runConfiguration.getJavaOptions();
        String[] a = IdeUtil.convertStringToStringArray((String)s, (boolean)true, (boolean)true);
        JStarter.addArrayToList(list, a);
    }

    protected void addJavaOptionProvidersJavaOptions(List list) {
        int size = javaOptionProviders.size();
        for (int i = 0; i < size; ++i) {
            try {
                JavaOptionProvider javaOptionProvider = (JavaOptionProvider)javaOptionProviders.get(i);
                String[] options = javaOptionProvider.getJavaOptions(this.jrunProcess);
                if (options == null || options.length <= 0) continue;
                JStarter.addArrayToList(list, options);
                continue;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    protected void addProxyJavaOptions(List list) {
        if (this.runConfiguration.isUseProxy()) {
            String[] jpo;
            IdeSettings settings = Ide.getSettings();
            ProxyOptions po = ProxyOptions.getProxyOptions();
            if (po != null && (jpo = po.getJavaProxyOptions()) != null) {
                int length = jpo.length;
                for (int i = 0; i < length; ++i) {
                    list.add(jpo[i]);
                }
            }
        }
    }

    protected final void addClassPathOption(List list) {
        String[] a;
        String classPath = this.getClassPath();
        if (classPath != null && classPath.length() > 0 && (a = this.makeClassPathOption(classPath)) != null) {
            JStarter.addArrayToList(list, a);
        }
    }

    protected String getClassPath() {
        String processClassPath;
        Project jproject = this.jrunProcess.getJProject();
        String classPath = PathsConfiguration.getInstance((Project)jproject).getRunClassPath().toString();
        if (classPath == null) {
            classPath = "";
        }
        if ((processClassPath = (String)this.jrunProcess.getValue("Java", null, "ClassPath")) != null && processClassPath.length() != 0) {
            if (classPath.length() > 0) {
                classPath = classPath + File.pathSeparator;
            }
            classPath = classPath + processClassPath;
        }
        return classPath;
    }

    private String[] makeClassPathOption(String classPath) {
        if (classPath != null && classPath.length() > 0) {
            String[] option = new String[]{"-classpath", classPath};
            return option;
        }
        return null;
    }

    protected final void addBootClassPathOption(List list) {
        String[] a;
        String classPath = this.getBootClassPath();
        if (classPath != null && classPath.length() > 0 && (a = this.makeBootClassPathOption(classPath)) != null) {
            JStarter.addArrayToList(list, a);
        }
    }

    protected final void addEndorsedDirsOption(List list) {
        URLPath urlPath;
        String endorsedDirs;
        Project project = this.jrunProcess.getJProject();
        if (project != null && (endorsedDirs = (urlPath = PathsConfiguration.getInstance((Project)project).getEndorsedStandardsDirectories()).toString()) != null && endorsedDirs.trim().length() > 0) {
            String[] endorsedOption = new String[]{"-Djava.endorsed.dirs=" + endorsedDirs.trim()};
            JStarter.addArrayToList(list, endorsedOption);
        }
    }

    protected String getBootClassPath() {
        String bootClassPath = "";
        String processBootClassPath = (String)this.jrunProcess.getValue("Java", null, "BootClassPath");
        if (processBootClassPath != null && processBootClassPath.length() != 0) {
            bootClassPath = bootClassPath + processBootClassPath;
        }
        return bootClassPath;
    }

    void fireCompilationError() {
    }

    private String[] makeBootClassPathOption(String classPath) {
        if (classPath != null && classPath.length() > 0) {
            String[] option = new String[]{"-Xbootclasspath/a:" + classPath};
            return option;
        }
        return null;
    }

    protected final void addLastJavaCommandOptions(List list) {
        String[] a = (String[])this.jrunProcess.getValue("Java", null, "LastJavaCommandOptions");
        if (a != null) {
            JStarter.addArrayToList(list, a);
        }
    }

    private void addTarget(List list) {
        if (this.target != null) {
            JStarter.addArrayToList(list, this.target);
        }
    }

    protected void addProgramArguments(List list) {
        String s = this.runConfiguration.getProgramArguments();
        String[] a = IdeUtil.convertStringToStringArray((String)s, (boolean)true, (boolean)true);
        JStarter.addArrayToList(list, a);
        int size = javaOptionProviders.size();
        for (int i = 0; i < size; ++i) {
            try {
                JavaOptionProvider javaOptionProvider = (JavaOptionProvider)javaOptionProviders.get(i);
                String[] arguments = javaOptionProvider.getProgramArguments(this.jrunProcess);
                if (arguments == null || arguments.length <= 0) continue;
                JStarter.addArrayToList(list, arguments);
                continue;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    protected static void addArrayToList(List list, String[] a) {
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            list.add(a[i]);
        }
    }

    protected JRunProcess.CompilationScope getCompilationScope() {
        return this.jrunProcess.getCompilationScope();
    }

    protected Element[] getExplicitCompilationTargets() {
        return this.explicitCompilationTargets;
    }

    protected void setExplicitCompilationTargets(Element[] targets) {
        this.explicitCompilationTargets = targets;
    }

    public String getJdkSystemProperty(String key) {
        if (JAVA_HOME.equals(key) || JAVA_VERSION.equals(key) || JAVA_ARCH_DATA_MODEL.equals(key)) {
            return this.jrunProcess.getJdkDefinition().getSystemProperties().getProperty(key);
        }
        return null;
    }
}

