/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.javatools.data.HashStructure;

public final class RunnerShapingPreferences {
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/customization", "runner-shaping-preferences");
    private static RunnerShapingPreferences _sInstance = new RunnerShapingPreferences();
    private RunnerHashStructureHookListener _listener;
    private boolean _useCurrentWorkingSetDefault = false;

    public static RunnerShapingPreferences getInstance() {
        return _sInstance;
    }

    public boolean getUseCurrentWorkingSetDefault() {
        this.initializeIfNeeded();
        return this._useCurrentWorkingSetDefault;
    }

    public synchronized void initializeIfNeeded() {
        if (this._listener == null) {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            HashStructureHook runnerShapingPreferences = (HashStructureHook)registry.getHook(NAME);
            this._listener = new RunnerHashStructureHookListener();
            runnerShapingPreferences.addHashStructureHookListener((HashStructureHookListener)this._listener);
        }
    }

    private class RunnerHashStructureHookListener
    implements HashStructureHookListener {
        private RunnerHashStructureHookListener() {
        }

        public void listenerAttached(HashStructureHookEvent e) {
            this._getRunnerShapingPreferences(e.getCombinedHashStructure());
        }

        public void elementVisited(HashStructureHookEvent e) {
            this._getRunnerShapingPreferences(e.getNewElementHashStructure());
        }

        private void _getRunnerShapingPreferences(HashStructure structure) {
            String useCurrentWorkingSetDefault = structure.getString("useCurrentWorkingSetDefault/#text", "false");
            if (useCurrentWorkingSetDefault == null) {
                return;
            }
            RunnerShapingPreferences.this._useCurrentWorkingSetDefault = "true".equalsIgnoreCase(useCurrentWorkingSetDefault);
        }
    }
}

