/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.presutil;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.util.Locale;
import java.util.Vector;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.presutil.FontMetricsResolver;

public class PresUtils {
    protected static final String ha_left = "LEFT";
    protected static final String ha_center = "CENTER";
    protected static final String ha_right = "RIGHT";
    protected static final String ha_leading = "LEADING";
    public static final String ELLIPSES = "...";
    public static final int MIN_TRUNCATION_ZERO = 0;
    private static final ThreadLocal<StringBuilder> _STRINGBUILDER = new ThreadLocal();

    public static String mapJavaFontToHTMLFont(String fontName, boolean bVirtualFontsEnabled) {
        if (fontName.equalsIgnoreCase("serif")) {
            fontName = "serif";
        } else if (fontName.equalsIgnoreCase("dialog")) {
            fontName = "sans-serif";
        } else if (fontName.equalsIgnoreCase("dialoginput")) {
            fontName = "monospace";
        } else if (fontName.equalsIgnoreCase("sansserif")) {
            fontName = "sans-serif";
        } else if (fontName.equalsIgnoreCase("monospaced")) {
            fontName = "monospace";
        } else {
            return fontName;
        }
        if (bVirtualFontsEnabled) {
            return fontName;
        }
        return null;
    }

    public static int hexStringToInt(String str) {
        String noPound = str.substring(1);
        return Integer.parseInt(noPound, 16);
    }

    public static Color parseColor(String str) {
        return new Color(PresUtils.hexStringToInt(str));
    }

    public static String toHexString(int value) {
        String base = "#000000";
        String hexStr = Integer.toHexString(value & 0xFFFFFF);
        StringBuilder buff = new StringBuilder();
        int nchars = base.length() - hexStr.length();
        if (nchars > 0) {
            buff.append(base.substring(0, nchars));
        }
        buff.append(hexStr);
        return buff.toString();
    }

    public static String toHexStringWithAlpha(int value) {
        StringBuilder hexStr = DataviewUtils.getSharedStringBuilder(_STRINGBUILDER, Integer.toHexString(value));
        int length = hexStr.length();
        if (length == 8 && hexStr.substring(0, 2).equals("ff")) {
            hexStr = hexStr.delete(0, 2);
        } else if (length < 8) {
            int diff = 8 - length;
            for (int i = 0; i < diff; ++i) {
                hexStr.insert(0, "0");
            }
        }
        hexStr.insert(0, "#");
        return hexStr.toString();
    }

    public static int hexStringWithAlphaToInt(String str) {
        String noPound = str.substring(1);
        boolean includesAlpha = noPound.length() > 6;
        int alpha = -16777216;
        if (includesAlpha) {
            if (noPound.length() == 7) {
                noPound = "0" + noPound;
            }
            int opacity = Integer.parseInt(noPound.substring(0, 2), 16);
            alpha = opacity << 88;
            noPound = noPound.substring(2);
        }
        int i = Integer.parseInt(noPound, 16);
        i = alpha | i;
        return i;
    }

    public static String getColorValue(Color color) {
        return PresUtils.toHexString(color.getRGB());
    }

    public static int convertHorizontalAlignmentToInt(String str) {
        int alignment = 0;
        if (str.equals(ha_left)) {
            alignment = 2;
        } else if (str.equals(ha_center)) {
            alignment = 0;
        } else if (str.equals(ha_right)) {
            alignment = 4;
        } else if (str.equals(ha_leading)) {
            alignment = 10;
        }
        return alignment;
    }

    public static String convertHorizontalAlignmentToString(int alignment) {
        String str = "";
        switch (alignment) {
            case 2: {
                str = ha_left;
                break;
            }
            case 0: {
                str = ha_center;
                break;
            }
            case 4: {
                str = ha_right;
                break;
            }
            case 10: {
                str = ha_leading;
            }
        }
        return str;
    }

    public static String truncateText(String text, FontMetrics fm, int minChars, int width) {
        return PresUtils.truncateText(text, fm, minChars, width, null);
    }

    public static String truncateText(String text, FontMetrics fm, int minChars, int width, FontMetricsResolver resolver) {
        return PresUtils.truncateText(text, fm, minChars, width, resolver, Locale.getDefault());
    }

    public static String truncateText(String text, FontMetrics fm, int minChars, int width, FontMetricsResolver resolver, Locale locale) {
        int totalChars = text.length();
        if (totalChars > minChars) {
            int j;
            int strWidth = PresUtils._stringWidth(text, fm, resolver);
            float wRatio = (float)width / (float)strWidth;
            StringBuilder buffer = new StringBuilder();
            int numChars = 0;
            int twentyPercChars = (int)((double)totalChars * 0.2);
            if (twentyPercChars > 2) {
                if ((double)wRatio > 0.2) {
                    numChars = (int)((float)totalChars * (wRatio -= 0.1f));
                    numChars = Math.min(numChars, totalChars - 1);
                    buffer.append(text.substring(0, numChars));
                }
            } else if (twentyPercChars >= 1 && (double)wRatio > 0.3) {
                numChars = (int)((float)totalChars * (wRatio -= 0.2f));
                numChars = Math.min(numChars, totalChars - 1);
                buffer.append(text.substring(0, numChars));
            }
            int dotsWidth = PresUtils._stringWidth(ELLIPSES, fm, resolver);
            if (PresUtils._stringWidth(buffer.toString(), fm, resolver) + dotsWidth < width) {
                for (j = numChars; j < text.length(); ++j) {
                    buffer.append(text.charAt(j));
                    if (PresUtils._stringWidth(buffer.toString(), fm, resolver) + dotsWidth <= width) continue;
                    numChars = j;
                    break;
                }
            } else {
                for (j = numChars - 1; j >= 0; --j) {
                    buffer.deleteCharAt(j);
                    if (PresUtils._stringWidth(buffer.toString(), fm, resolver) + dotsWidth >= width) continue;
                    numChars = j;
                    break;
                }
            }
            if (numChars < minChars) {
                text = "";
            } else {
                buffer = new StringBuilder(text);
                numChars = Math.min(numChars, totalChars - 1);
                String subString = buffer.substring(0, numChars);
                text = PresUtils.isBIDILocale(locale) ? ELLIPSES.concat(subString) : subString.concat(ELLIPSES);
                if (numChars == 0 && PresUtils._stringWidth(text, fm, resolver) > width) {
                    text = "";
                }
            }
        } else {
            text = "";
        }
        return text;
    }

    private static int _stringWidth(String text, FontMetrics fm, FontMetricsResolver resolver) {
        if (resolver != null) {
            return resolver.stringWidth(text, fm);
        }
        return fm.stringWidth(text);
    }

    public static Polygon mergePolygons(Vector polygons) {
        Point rightmostPoint;
        int i;
        Polygon ret = null;
        int size = 0;
        for (i = 0; i < polygons.size(); ++i) {
            size += ((Polygon)polygons.elementAt((int)i)).npoints;
        }
        Vector<Point> in_points = new Vector<Point>(size);
        int rightmost = 0;
        int rightX = -1;
        for (i = 0; i < polygons.size(); ++i) {
            Polygon curr_poly = (Polygon)polygons.elementAt(i);
            int nPoints = curr_poly.npoints;
            if (curr_poly.xpoints[0] == curr_poly.xpoints[nPoints - 1] && curr_poly.ypoints[0] == curr_poly.ypoints[nPoints - 1]) {
                --nPoints;
            }
            int added = 0;
            for (int n = 0; n < nPoints; ++n) {
                boolean alreadyInArray = false;
                if (i != 0) {
                    for (int ii = 0; !alreadyInArray && ii < in_points.size() - added; ++ii) {
                        if (curr_poly.xpoints[n] != ((Point)in_points.elementAt((int)ii)).x || curr_poly.ypoints[n] != ((Point)in_points.elementAt((int)ii)).y) continue;
                        alreadyInArray = true;
                    }
                }
                if (alreadyInArray) continue;
                ++added;
                in_points.addElement(new Point(curr_poly.xpoints[n], curr_poly.ypoints[n]));
                if (curr_poly.xpoints[n] <= rightX) continue;
                rightX = curr_poly.xpoints[n];
                rightmost = in_points.size() - 1;
            }
        }
        Vector<Point> out_points = new Vector<Point>(in_points.size());
        Point prevPoint = rightmostPoint = (Point)in_points.elementAt(rightmost);
        int next = 0;
        double cos = -1.0;
        for (i = 0; i < in_points.size(); ++i) {
            if (i == rightmost) continue;
            Point p = (Point)in_points.elementAt(i);
            double len = Math.sqrt(Math.pow(p.x - rightmostPoint.x, 2.0) + Math.pow(p.y - rightmostPoint.y, 2.0));
            double newcos = (double)(p.y - rightmostPoint.y) / len;
            if (!(newcos > cos)) continue;
            next = i;
            cos = newcos;
        }
        Point curr = (Point)in_points.elementAt(next);
        out_points.addElement(curr);
        in_points.removeElementAt(next);
        while (in_points.size() > 0) {
            cos = 1.0;
            next = 0;
            size = out_points.size();
            Point p1 = prevPoint;
            double len1 = Math.sqrt(Math.pow(p1.x - curr.x, 2.0) + Math.pow(p1.y - curr.y, 2.0));
            for (i = 0; i < in_points.size(); ++i) {
                Point p2 = (Point)in_points.elementAt(i);
                int dot_prod = (p1.x - curr.x) * (p2.x - curr.x) + (p1.y - curr.y) * (p2.y - curr.y);
                double len2 = Math.sqrt(Math.pow(p2.x - curr.x, 2.0) + Math.pow(p2.y - curr.y, 2.0));
                double newcos = (double)dot_prod / (len1 * len2);
                if (!(newcos < cos)) continue;
                next = i;
                cos = newcos;
            }
            prevPoint = curr;
            curr = (Point)in_points.elementAt(next);
            if (curr.equals(rightmostPoint)) break;
            out_points.addElement(curr);
            in_points.removeElementAt(next);
        }
        out_points.addElement(rightmostPoint);
        ret = new Polygon();
        for (i = 0; i < out_points.size(); ++i) {
            curr = (Point)out_points.elementAt(i);
            ret.addPoint(curr.x, curr.y);
        }
        return ret;
    }

    public static Polygon rectToPoly(Rectangle rect) {
        int[] xPts = new int[]{rect.x, rect.x + rect.width, rect.x + rect.width, rect.x};
        int[] yPts = new int[]{rect.y, rect.y, rect.y + rect.height, rect.y + rect.height};
        return new Polygon(xPts, yPts, 4);
    }

    public static Polygon lineToPoly(Line2D line) {
        Polygon poly = new Polygon();
        int startX = (int)line.getP1().getX();
        int startY = (int)line.getP1().getY();
        int endX = (int)line.getP2().getX();
        int endY = (int)line.getP2().getY();
        poly.addPoint(startX - 1, startY - 1);
        poly.addPoint(startX - 1, endY + 1);
        poly.addPoint(endX + 1, endY + 1);
        poly.addPoint(endX + 1, startY - 1);
        return poly;
    }

    public static Polygon shapeToPoly(Shape s) {
        Polygon poly = new Polygon();
        double[] path = new double[6];
        FlatteningPathIterator fpi = new FlatteningPathIterator(s.getPathIterator(null), 1.0, 3);
        while (!fpi.isDone()) {
            int type = fpi.currentSegment(path);
            if (type == 1 || type == 0) {
                poly.addPoint((int)path[0], (int)path[1]);
            }
            fpi.next();
        }
        return poly;
    }

    public static Color getPastel(Color c, double factor) {
        int gRed = Math.min(c.getRed() + (int)((double)(255 - c.getRed()) * factor), 255);
        int gGreen = Math.min(c.getGreen() + (int)((double)(255 - c.getGreen()) * factor), 255);
        int gBlue = Math.min(c.getBlue() + (int)((double)(255 - c.getBlue()) * factor), 255);
        return new Color(gRed, gGreen, gBlue, c.getAlpha());
    }

    public static boolean isBIDILocale(Locale loc) {
        if (loc != null) {
            String language = loc.getLanguage();
            return language.equals("ar") || language.equals("he") || language.equals("iw");
        }
        return false;
    }
}

