/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.shared.marker;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.legend.shared.marker.LegendMarker;
import oracle.dss.legend.shared.marker.MarkerShape;
import oracle.dss.legend.shared.util.LegendUtils;
import oracle.dss.util.containers.Marker;
import oracle.dss.util.shapes.Container;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.FillTexture;
import oracle.dss.util.shapes.Path;

public class CustomShapeMarker
extends LegendMarker {
    protected Color m_markerFillColor;
    protected int m_markerPattern = -1;
    protected Marker m_customMarker = null;
    protected MarkerShape m_markerShape;

    public CustomShapeMarker(Marker marker, Color color, int pattern, double opacity) {
        this.m_customMarker = marker;
        this.m_markerFillColor = color;
        this.m_markerPattern = pattern;
        this.m_opacity = opacity;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CustomShapeMarker)) {
            return false;
        }
        CustomShapeMarker other = (CustomShapeMarker)object;
        if (!(this.m_markerFillColor != null ? this.m_markerFillColor.equals(other.m_markerFillColor) : other.m_markerFillColor == null)) {
            return false;
        }
        if (this.m_markerPattern != other.m_markerPattern) {
            return false;
        }
        if (!(this.m_markerShape != null ? this.m_markerShape.equals((Object)other.m_markerShape) : other.m_markerShape == null)) {
            return false;
        }
        if (Double.compare(this.m_opacity, other.m_opacity) != 0) {
            return false;
        }
        return this.m_customMarker.getID() != null ? this.m_customMarker.getID().equals(other.m_customMarker.getID()) : other.m_customMarker.getID() == null;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this.m_markerFillColor == null ? 0 : this.m_markerFillColor.hashCode());
        result = 37 * result + this.m_markerPattern;
        result = 37 * result + (this.m_markerShape == null ? 0 : this.m_markerShape.hashCode());
        long temp = Double.doubleToLongBits(this.m_opacity);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        result = 37 * result + (this.m_customMarker.getID() == null ? 0 : this.m_customMarker.getID().hashCode());
        return result;
    }

    public MarkerShape getMarkerShape() {
        return this.m_markerShape;
    }

    public int getPattern() {
        return this.m_markerPattern;
    }

    public Color getFillColor() {
        return this.m_markerFillColor;
    }

    public Marker getCustomMarker() {
        return this.m_customMarker;
    }

    @Override
    public void calc() {
    }

    @Override
    public void calcFinal() {
    }

    @Override
    public List<DrawableObject> render() {
        ArrayList<DrawableObject> item = new ArrayList<DrawableObject>();
        Container marker = null;
        int markerWidth = this.m_width;
        int markerHeight = this.m_height;
        if (this.m_customMarker != null) {
            Marker newMarker = new Marker(this.m_customMarker.getID());
            List<DrawableObject> list = this.m_customMarker.getDrawables();
            for (DrawableObject drawable : list) {
                Shape shape = drawable.getShape();
                shape = LegendUtils.scaleAndTranslateToSize(shape, this.m_x, this.m_y, markerWidth, markerHeight);
                Path newObj = new Path(shape);
                newObj.setFill(drawable.getFill());
                newMarker.add(newObj);
            }
            marker = newMarker;
        }
        if (marker != null) {
            AffineTransform translate = AffineTransform.getTranslateInstance(markerWidth / 2, markerHeight / 2);
            LegendUtils.transformDrawables(marker.getDrawables(), translate);
            Color fillColor = LegendUtils.applyOpacity(this.m_markerFillColor, this.m_opacity);
            if (this.m_markerPattern != -1) {
                Color bc = Color.WHITE;
                bc = LegendUtils.applyOpacity(bc, this.m_opacity);
                marker.setFill(new FillTexture(fillColor, bc, this.m_markerPattern));
            } else {
                marker.setFill(new FillColor(fillColor));
            }
            marker.setStroke(this.getInstanceBorder());
            item.add(marker);
        }
        return item;
    }
}

